/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ExpressionStatement;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.ParenthesisExpression;
import java.util.ArrayList;

public class IfExpression
extends Expression {
    private final Expression if_condition_;
    private CompoundStatement if_body_;
    private ArrayList<Elseif> elsifs = new ArrayList();
    private CompoundStatement else_body_;

    public IfExpression(Expression condition, Expression left, Expression right) {
        this.if_condition_ = condition;
        this.if_body_ = new CompoundStatement();
        this.if_body_.addStatement(new ExpressionStatement(left));
        this.else_body_ = new CompoundStatement();
        this.else_body_.addStatement(new ExpressionStatement(right));
    }

    public IfExpression(Expression condition, CompoundStatement body) {
        this.if_condition_ = condition;
        this.if_body_ = body;
    }

    public void addElsif(Expression condition, CompoundStatement body) {
        this.elsifs.add(new Elseif(condition, body));
    }

    public void addElse(CompoundStatement body) {
        this.else_body_ = body;
    }

    private void ensureIfBodyAndElseBodyAreNotEmpty() {
        if (null == this.if_body_) {
            this.if_body_ = new CompoundStatement();
            this.if_body_.addStatement(new ExpressionStatement(new NilExpression()));
        }
        if (null == this.else_body_) {
            this.else_body_ = new CompoundStatement();
            this.else_body_.addStatement(new ExpressionStatement(new NilExpression()));
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.ensureIfBodyAndElseBodyAreNotEmpty();
        if (this.if_condition_ instanceof ParenthesisExpression) {
            ((ParenthesisExpression)this.if_condition_).ensureVariablesAreInitialized(visitor);
        }
        this.if_body_.ensureVariablesAreInitialized(visitor);
        for (Elseif elsif : this.elsifs) {
            elsif.body_.ensureVariablesAreInitialized(visitor);
        }
        this.else_body_.ensureVariablesAreInitialized(visitor);
        ArrayList<Block> pulled_blocks = new ArrayList<Block>();
        this.if_body_.pullBlock(pulled_blocks);
        for (Elseif elsif : this.elsifs) {
            elsif.body_.pullBlock(pulled_blocks);
        }
        this.else_body_.pullBlock(pulled_blocks);
        for (Block block : pulled_blocks) {
            block.acceptAsPulled(visitor);
        }
        if (this.conditionIsAlwayTrue(this.if_condition_)) {
            this.if_body_.accept(visitor);
            if (!this.if_body_.lastStatementHasReturnValue()) {
                visitor.visitNilExpression();
            }
            return;
        }
        this.accept_with_no_optimazation(visitor);
    }

    private void accept_with_no_optimazation(CodeVisitor visitor) {
        this.if_condition_.accept(visitor);
        Object next_label = visitor.visitAfterIfCondition();
        this.if_body_.accept(visitor);
        if (!this.if_body_.lastStatementHasReturnValue()) {
            visitor.visitNilExpression();
        }
        Object end_label = visitor.visitAfterIfBody(next_label, null);
        for (Elseif elsif : this.elsifs) {
            elsif.accept(visitor, end_label);
        }
        this.else_body_.accept(visitor);
        visitor.visitAfterIfBody(null, end_label);
    }

    @Override
    void pullBlock(ArrayList<Block> result) {
        this.if_condition_.pullBlock(result);
        if (null != this.if_body_) {
            this.if_body_.pullBlock(result);
        }
        for (Elseif elsif : this.elsifs) {
            elsif.pullBlock(result);
        }
        if (null != this.else_body_) {
            this.else_body_.pullBlock(result);
        }
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        this.if_condition_.getNewlyAssignedVariables(symboltable, result);
        if (null != this.if_body_) {
            this.if_body_.getNewlyAssignedVariables(symboltable, result);
        }
        for (Elseif elsif : this.elsifs) {
            elsif.getNewlyAssignedVariables(symboltable, result);
        }
        if (null != this.else_body_) {
            this.else_body_.getNewlyAssignedVariables(symboltable, result);
        }
    }

    private class Elseif {
        private final Expression condition_;
        private final CompoundStatement body_;

        Elseif(Expression condition, CompoundStatement body) {
            this.condition_ = condition;
            if (body == null) {
                this.body_ = new CompoundStatement();
                this.body_.addStatement(new ExpressionStatement(new NilExpression()));
            } else {
                this.body_ = body;
            }
        }

        public void accept(CodeVisitor visitor, Object end_label) {
            if (null == this.condition_) {
                visitor.visitTrueExpression();
            } else {
                this.condition_.accept(visitor);
            }
            Object next_label = visitor.visitAfterIfCondition();
            if (null != this.body_) {
                this.body_.accept(visitor);
            } else {
                visitor.visitNilExpression();
            }
            visitor.visitAfterIfBody(next_label, end_label);
        }

        void pullBlock(ArrayList<Block> result) {
            this.condition_.pullBlock(result);
            this.body_.pullBlock(result);
        }

        void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
            this.condition_.getNewlyAssignedVariables(symboltable, result);
            this.body_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

