/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import java.math.BigInteger;
import java.util.ArrayList;

public class IntegerExpression
extends Expression {
    private BigInteger value_;
    private static final BigInteger FIXNUM_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger FIXNUM_MIN = BigInteger.valueOf(Integer.MIN_VALUE);

    public IntegerExpression(BigInteger value2) {
        this.value_ = value2;
    }

    public IntegerExpression(int value2) {
        this.value_ = BigInteger.valueOf(value2);
    }

    public IntegerExpression(String value2, int radix) throws RecognitionException {
        try {
            this.value_ = new BigInteger(value2, radix);
        }
        catch (NumberFormatException e) {
            throw new RecognitionException(e.toString());
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (this.value_.compareTo(FIXNUM_MIN) >= 0 && this.value_.compareTo(FIXNUM_MAX) <= 0) {
            visitor.visitFixnumExpression(this.value_.intValue());
        } else {
            visitor.visitBignumExpression(this.value_);
        }
    }

    @Override
    public void getFrequentlyUsedIntegers(ArrayList<Integer> result) {
        if (this.value_.compareTo(FIXNUM_MIN) >= 0 && this.value_.compareTo(FIXNUM_MAX) <= 0) {
            result.add(this.value_.intValue());
        }
    }
}

