/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.AssignmentOperatorExpression;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.MethodCallExpression;
import com.xruby.compiler.codedom.NilExpression;
import com.xruby.compiler.codedom.ParameterVariableExpression;
import java.util.ArrayList;

public class LocalVariableExpression
extends ParameterVariableExpression {
    private final String value_;
    private final boolean isFunction_;

    public LocalVariableExpression(String value2, boolean isFunction) {
        this.value_ = value2;
        this.isFunction_ = isFunction;
    }

    String getValue() {
        return this.value_;
    }

    private boolean isFunction(CodeVisitor visitor) {
        if (visitor.isDefinedInCurrentScope(this.value_)) {
            return false;
        }
        return this.isFunction_;
    }

    @Override
    public void acceptAsInitializeToNil(CodeVisitor visitor) {
        AssignmentOperatorExpression assign;
        try {
            assign = new AssignmentOperatorExpression(new LocalVariableExpression(this.value_, false), new NilExpression());
        }
        catch (RecognitionException e) {
            throw new Error(e);
        }
        assign.accept(visitor);
        visitor.visitTerminal();
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (this.isFunction(visitor)) {
            MethodCallExpression exp2;
            try {
                exp2 = new MethodCallExpression(null, this.value_, null, null);
            }
            catch (RecognitionException e) {
                throw new Error(e);
            }
            exp2.accept(visitor);
        } else {
            visitor.visitLocalVariableExpression(this.value_);
        }
    }

    @Override
    public void acceptAsAssignment(CodeVisitor visitor, boolean rhs_is_method_call, boolean is_multiple_assign) {
        visitor.visitLocalVariableAssignmentOperator(this.value_, rhs_is_method_call, is_multiple_assign);
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
    }
}

