/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.ArrayExpression;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.Visitable;
import java.util.ArrayList;

public class MethodCallArguments
implements Visitable {
    protected final ArrayList<Expression> arguments_ = new ArrayList();
    protected Expression asterisk_argument_ = null;
    protected Expression block_argument_ = null;

    public MethodCallArguments() {
    }

    public MethodCallArguments(Expression argument) {
        this.arguments_.add(argument);
    }

    Expression getAsteriskArgument() {
        return this.asterisk_argument_;
    }

    Expression getBlockArgument() {
        return this.block_argument_;
    }

    public int size() {
        return this.arguments_.size();
    }

    Expression getFirstExpression() {
        return this.arguments_.get(0);
    }

    Expression getSecondExpression() {
        return this.arguments_.get(1);
    }

    public MethodCallArguments clone() {
        MethodCallArguments r = new MethodCallArguments();
        for (Expression exp2 : this.arguments_) {
            r.addArgument(exp2);
        }
        return r;
    }

    public void setAsteriskArgument(Expression argument) {
        assert (null == this.asterisk_argument_);
        this.asterisk_argument_ = argument;
    }

    public void setBlockArgument(Expression argument) {
        assert (null == this.block_argument_);
        this.block_argument_ = argument;
    }

    public void addArgument(Expression argument) {
        this.arguments_.add(argument);
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (this.arguments_.isEmpty() && null == this.asterisk_argument_) {
            visitor.visitNoParameter();
        } else {
            ArrayExpression to_a2 = new ArrayExpression(this.arguments_, this.asterisk_argument_);
            to_a2.accept(visitor);
        }
    }

    public void getFrequentlyUsedIntegers(ArrayList<Integer> result) {
        for (Expression exp2 : this.arguments_) {
            exp2.getFrequentlyUsedIntegers(result);
        }
    }

    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        for (Expression exp2 : this.arguments_) {
            exp2.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

