/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import antlr.RecognitionException;
import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.MethodCallArguments;
import java.util.ArrayList;

public class MethodCallExpression
extends Expression {
    private Expression receiver_;
    private String methodName_;
    private Block block_;
    private MethodCallArguments arguments_;

    public MethodCallExpression(Expression receiver, String methodName, MethodCallArguments arguments, Block block) throws RecognitionException {
        if (null != block && null != arguments && null != arguments.getBlockArgument()) {
            throw new RecognitionException("both block arg and actual block given");
        }
        this.receiver_ = receiver;
        this.methodName_ = methodName;
        this.arguments_ = arguments;
        this.block_ = block;
    }

    boolean isElementSet() {
        return this.methodName_.equals("[]") || null != this.receiver_;
    }

    Expression convertElementAccessToElementSet(Expression value2) throws RecognitionException {
        MethodCallArguments args = null != this.arguments_ ? this.arguments_.clone() : new MethodCallArguments();
        args.addArgument(value2);
        MethodCallExpression r = new MethodCallExpression(this.receiver_, this.methodName_ + "=", args, null);
        return r;
    }

    Expression getReceiver() {
        return this.receiver_;
    }

    public final String getName() {
        return this.methodName_;
    }

    public MethodCallArguments getArguments() {
        return this.arguments_;
    }

    public Block getBlock() {
        return this.block_;
    }

    private boolean isLambdaCall() {
        if (null == this.receiver_) {
            return false;
        }
        if (!this.methodName_.equals("call")) {
            return false;
        }
        if (!(this.receiver_ instanceof MethodCallExpression)) {
            return false;
        }
        MethodCallExpression m = (MethodCallExpression)this.receiver_;
        if (null == m.block_) {
            return false;
        }
        return m.methodName_.equals("lambda") || m.methodName_.equals("proc");
    }

    public void acceptMultipleArrayAssign(CodeVisitor visitor) {
        this.arguments_.getFirstExpression().accept(visitor);
        this.receiver_.accept(visitor);
        visitor.visitMultipleArrayAssign();
    }

    public void acceptAsLambdaCall(CodeVisitor visitor) {
        MethodCallExpression m = (MethodCallExpression)this.receiver_;
        m.block_.accept(visitor);
        visitor.visitSpecialLambdaCallBegin();
        if (null == this.arguments_) {
            visitor.visitNoParameter();
        } else {
            this.arguments_.accept(visitor);
        }
        visitor.visitSpecialLambdaCallEnd();
    }

    @Override
    public void accept(CodeVisitor visitor) {
        int argc;
        if (this.isLambdaCall()) {
            this.acceptAsLambdaCall(visitor);
            return;
        }
        boolean is_eval = false;
        if (null == this.receiver_ && (this.methodName_.equals("eval") || this.methodName_.equals("binding"))) {
            is_eval = true;
        }
        visitor.visitMethodCallBegin();
        if (null != this.receiver_) {
            this.receiver_.accept(visitor);
            if (this.methodName_.equals("call")) {
                visitor.visitPotentialProcCall();
            }
        } else {
            visitor.visitSelfExpression();
        }
        int n = argc = is_eval ? -1 : this.getArgc();
        if (null == this.arguments_) {
            if (is_eval) {
                visitor.visitBinding(true);
                argc = 1;
            }
        } else {
            switch (argc) {
                case 0: {
                    break;
                }
                case 1: {
                    this.arguments_.getFirstExpression().accept(visitor);
                    break;
                }
                case 2: {
                    this.arguments_.getFirstExpression().accept(visitor);
                    this.arguments_.getSecondExpression().accept(visitor);
                    break;
                }
                default: {
                    this.arguments_.accept(visitor);
                    if (!is_eval || this.arguments_.size() > 1) break;
                    visitor.visitBinding(false);
                }
            }
        }
        String name = null;
        if (null != this.block_) {
            name = this.block_.accept(visitor);
        } else if (null != this.arguments_ && null != this.arguments_.getBlockArgument()) {
            this.arguments_.getBlockArgument().accept(visitor);
            visitor.visitBlockArgument();
        } else {
            boolean is_block_given_call = false;
            if (null == this.receiver_ && (this.methodName_.equals("block_given?") || this.methodName_.equals("iterator?"))) {
                is_block_given_call = true;
            }
            visitor.visitNoBlock(is_block_given_call);
        }
        visitor.visitMethodCallEnd(this.methodName_, null != this.receiver_, name, argc);
    }

    private int getArgc() {
        if (this.arguments_ == null) {
            return 0;
        }
        if (this.arguments_.getAsteriskArgument() == null) {
            return this.arguments_.size();
        }
        return -1;
    }

    @Override
    public void getFrequentlyUsedIntegers(ArrayList<Integer> result) {
        if (null != this.receiver_) {
            this.receiver_.getFrequentlyUsedIntegers(result);
        }
        if (null != this.arguments_) {
            this.arguments_.getFrequentlyUsedIntegers(result);
        }
    }

    @Override
    void pullBlock(ArrayList<Block> result) {
        if (null != this.block_) {
            result.add(this.block_);
        }
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        if (null != this.receiver_) {
            this.receiver_.getNewlyAssignedVariables(symboltable, result);
        }
        if (null != this.arguments_) {
            this.arguments_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

