/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.BlockFarm;
import com.xruby.compiler.codedom.BodyStatement;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codegen.NameFactory;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class MethodDefinitionExpression
extends Expression {
    private String methodName_;
    private Expression method_owner_;
    private BodyStatement bodyStatement_ = null;
    private ArrayList<String> parameters_ = new ArrayList();
    private String asterisk_parameter_ = null;
    private String block_parameter_ = null;
    private ArrayList<Expression> default_parameters_ = new ArrayList();

    public MethodDefinitionExpression(String methodName) {
        this.methodName_ = methodName;
        this.method_owner_ = null;
    }

    public MethodDefinitionExpression(String methodName, Expression method_owner) {
        this.methodName_ = methodName;
        this.method_owner_ = method_owner;
    }

    public void setBody(BodyStatement bodyStatement) {
        this.bodyStatement_ = bodyStatement;
    }

    public void addParameter(String name, Expression default_value) {
        this.parameters_.add(name);
        if (null != default_value) {
            this.default_parameters_.add(default_value);
        }
    }

    public void setAsteriskParameter(String name) {
        this.asterisk_parameter_ = null == name ? "$unused" : name;
    }

    public void setBlockParameter(String name) {
        assert (null == this.block_parameter_);
        this.block_parameter_ = name;
    }

    @Override
    public void accept(CodeVisitor visitor) {
        int firstLine;
        if (null != this.method_owner_) {
            this.method_owner_.accept(visitor);
        }
        String uniqueMethodName = visitor.visitMethodDefinition(this.methodName_, this.parameters_.size(), null != this.asterisk_parameter_, this.default_parameters_.size(), null != this.method_owner_);
        for (String p2 : this.parameters_) {
            visitor.visitMethodDefinitionParameter(p2);
        }
        if (null != this.asterisk_parameter_) {
            visitor.visitMethodDefinitionAsteriskParameter(this.asterisk_parameter_, this.parameters_.size());
        }
        if (null != this.block_parameter_) {
            visitor.visitMethodDefinitionBlockParameter(this.block_parameter_);
        }
        int i = this.parameters_.size() - this.default_parameters_.size();
        if (!this.default_parameters_.isEmpty()) {
            visitor.visitMethodDefinitionDefaultParameters(this.default_parameters_.size());
            for (Expression e : this.default_parameters_) {
                Object next_label = visitor.visitMethodDefinitionDefaultParameterBegin(i);
                e.accept(visitor);
                visitor.visitMethodDefinitionDefaultParameterEnd(next_label);
                ++i;
            }
        }
        if (null != this.bodyStatement_) {
            this.bodyStatement_.accept(visitor);
        }
        visitor.visitMethodDefinitionEnd(null != this.bodyStatement_ ? this.bodyStatement_.lastStatementHasReturnValue() : false);
        int lastLine = firstLine = this.getPosition();
        if (this.bodyStatement_ != null) {
            lastLine = this.bodyStatement_.getLastLine();
        }
        String scriptName = MethodDefinitionExpression.extractScriptName(uniqueMethodName);
        BlockFarm.markMethod(scriptName, uniqueMethodName, new int[]{firstLine, lastLine});
    }

    private static String extractScriptName(String uniqueMethodName) {
        StringTokenizer st;
        if (uniqueMethodName.startsWith(NameFactory.name_classprefix_ + "/")) {
            uniqueMethodName = uniqueMethodName.substring(6);
        }
        if ((st = new StringTokenizer(uniqueMethodName, "/")).hasMoreTokens()) {
            return st.nextToken() + ".rb";
        }
        return null;
    }
}

