/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ExpressionStatement;
import com.xruby.compiler.codedom.ISymbolTable;
import com.xruby.compiler.codedom.NilExpression;
import java.util.ArrayList;

public class UnlessExpression
extends Expression {
    private final Expression unless_condition_;
    private CompoundStatement unless_body_;
    private CompoundStatement else_body_;

    public UnlessExpression(Expression condition, CompoundStatement body, CompoundStatement else_body) {
        this.unless_condition_ = condition;
        this.unless_body_ = body;
        this.else_body_ = else_body;
    }

    private void ensureUnlessBodyAndElseBodyAreNotEmpty() {
        if (null == this.unless_body_) {
            this.unless_body_ = new CompoundStatement();
            this.unless_body_.addStatement(new ExpressionStatement(new NilExpression()));
        }
        if (null == this.else_body_) {
            this.else_body_ = new CompoundStatement();
            this.else_body_.addStatement(new ExpressionStatement(new NilExpression()));
        }
    }

    @Override
    public void accept(CodeVisitor visitor) {
        this.ensureUnlessBodyAndElseBodyAreNotEmpty();
        this.unless_body_.ensureVariablesAreInitialized(visitor);
        this.else_body_.ensureVariablesAreInitialized(visitor);
        if (this.conditionIsAlwayFalse(this.unless_condition_)) {
            this.unless_body_.accept(visitor);
            if (!this.unless_body_.lastStatementHasReturnValue()) {
                visitor.visitNilExpression();
            }
            return;
        }
        this.accept_with_no_optimazation(visitor);
    }

    private void accept_with_no_optimazation(CodeVisitor visitor) {
        this.unless_condition_.accept(visitor);
        Object next_label = visitor.visitAfterUnlessCondition();
        this.unless_body_.accept(visitor);
        if (!this.unless_body_.lastStatementHasReturnValue()) {
            visitor.visitNilExpression();
        }
        Object end_label = visitor.visitAfterUnlessBody(next_label, null);
        this.else_body_.accept(visitor);
        visitor.visitAfterUnlessBody(null, end_label);
    }

    @Override
    void pullBlock(ArrayList<Block> result) {
        this.unless_condition_.pullBlock(result);
        if (null != this.unless_body_) {
            this.unless_body_.pullBlock(result);
        }
        if (null != this.else_body_) {
            this.else_body_.pullBlock(result);
        }
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        this.unless_condition_.getNewlyAssignedVariables(symboltable, result);
        if (null != this.unless_body_) {
            this.unless_body_.getNewlyAssignedVariables(symboltable, result);
        }
        if (null != this.else_body_) {
            this.else_body_.getNewlyAssignedVariables(symboltable, result);
        }
    }
}

