/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.Block;
import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.CompoundStatement;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.ISymbolTable;
import java.util.ArrayList;

public class WhileExpression
extends Expression {
    private final Expression condition_;
    private final CompoundStatement body_;
    private boolean is_until_;
    private boolean do_first_;

    public WhileExpression(Expression condition, CompoundStatement body, boolean is_until, boolean do_first) {
        assert (null != condition);
        this.condition_ = condition;
        this.body_ = body;
        this.is_until_ = is_until;
        this.do_first_ = do_first && body.isSingleBeginEnd();
    }

    @Override
    boolean willNotBeExecuted() {
        if (!this.is_until_ && !this.do_first_ && this.conditionIsAlwayFalse(this.condition_)) {
            return true;
        }
        return this.is_until_ && !this.do_first_ && this.conditionIsAlwayTrue(this.condition_);
    }

    @Override
    public void accept(CodeVisitor visitor) {
        if (null != this.body_) {
            this.body_.ensureVariablesAreInitialized(visitor);
            ArrayList<Block> pulled_blocks = new ArrayList<Block>();
            this.body_.pullBlock(pulled_blocks);
            for (Block block : pulled_blocks) {
                block.acceptAsPulled(visitor);
            }
        }
        visitor.visitWhileConditionBegin(this.do_first_);
        boolean always_true = this.conditionIsAlwayTrue(this.condition_);
        if (!always_true) {
            this.condition_.accept(visitor);
        }
        visitor.visitWhileConditionEnd(always_true, this.is_until_);
        if (null != this.body_) {
            this.body_.accept(visitor);
        }
        visitor.visitWhileBodyEnd(null != this.body_);
    }

    @Override
    void pullBlock(ArrayList<Block> result) {
        this.condition_.pullBlock(result);
        this.body_.pullBlock(result);
    }

    @Override
    void getNewlyAssignedVariables(ISymbolTable symboltable, ArrayList<String> result) {
        this.condition_.getNewlyAssignedVariables(symboltable, result);
        this.body_.getNewlyAssignedVariables(symboltable, result);
    }
}

