/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import com.xruby.compiler.codegen.ClassGeneratorForRubyBlock;
import java.util.HashSet;
import java.util.Set;

class FieldManager {
    private final FieldManager parent_;
    private final ClassGeneratorForRubyBlock cg_;
    private final Set<String> fields_ = new HashSet<String>();
    private final Set<String> assigned_fields_ = new HashSet<String>();
    private final Set<String> previous_blocks_ = new HashSet<String>();

    public FieldManager(FieldManager parent, ClassGeneratorForRubyBlock cg) {
        this.parent_ = parent;
        this.cg_ = cg;
    }

    public void addPreviousBlock(String block) {
        this.previous_blocks_.add(block);
    }

    public void addField(String s) {
        this.fields_.add(s);
        if (null != this.parent_) {
            this.parent_.addField(s);
        }
    }

    public void addAssignedField(String s, boolean is_for_in_expression) {
        this.fields_.add(s);
        if (is_for_in_expression || this.cg_.isDefinedInOwnerScope(s)) {
            this.assigned_fields_.add(s);
        }
        if (null != this.parent_) {
            this.parent_.addField(s);
            this.parent_.addAssignedField(s, false);
        }
    }

    public String[] getPreviousBlocks() {
        return this.previous_blocks_.toArray(new String[this.previous_blocks_.size()]);
    }

    public String[] getFields() {
        return this.fields_.toArray(new String[this.fields_.size()]);
    }

    public String[] getAssignedFields() {
        return this.assigned_fields_.toArray(new String[this.assigned_fields_.size()]);
    }
}

