/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Program;
import com.xruby.compiler.codegen.CgUtil;
import com.xruby.compiler.codegen.ClassGenerator;
import com.xruby.compiler.codegen.ClassGeneratorForClassModuleBuilder;
import com.xruby.compiler.codegen.ClassGeneratorForRubyBlock;
import com.xruby.compiler.codegen.ClassGeneratorForRubyMethod;
import com.xruby.compiler.codegen.ClassGeneratorForRubyMethodFactory;
import com.xruby.compiler.codegen.ClassGeneratorForRubyProgram;
import com.xruby.compiler.codegen.CompilationResults;
import com.xruby.compiler.codegen.LabelManager;
import com.xruby.compiler.codegen.MethodGenerator;
import com.xruby.compiler.codegen.NameFactory;
import com.xruby.compiler.codegen.RubyIDClassGenerator;
import com.xruby.compiler.codegen.SymbolTable;
import com.xruby.compiler.codegen.Types;
import com.xruby.runtime.lang.RubyBinding;
import java.math.BigInteger;
import java.util.Stack;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class RubyCompilerImpl
implements CodeVisitor {
    private ClassGenerator cg_;
    private final Stack<ClassGenerator> suspended_cgs_ = new Stack();
    private final CompilationResults compilation_results_;
    private final String extra_;
    private final String script_name_;
    private RubyBinding binding_;
    private Label currentLineLabel;
    private boolean enableDebug = false;

    public RubyCompilerImpl(String extra, String script_name) {
        this.extra_ = extra;
        this.script_name_ = script_name;
        this.compilation_results_ = new CompilationResults();
    }

    private boolean isInGlobalScope() {
        return this.suspended_cgs_.empty() && !this.isInClassBuilder();
    }

    private boolean isInBlock() {
        return this.cg_ instanceof ClassGeneratorForRubyBlock;
    }

    private boolean isInSingletonMethod() {
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            return ((ClassGeneratorForRubyMethod)this.cg_).isSingletonMethod();
        }
        return false;
    }

    private boolean isInClassBuilder() {
        return this.cg_ instanceof ClassGeneratorForClassModuleBuilder;
    }

    public void enableDebug() {
        this.enableDebug = true;
    }

    private void switchToNewClassGenerator(ClassGenerator cg) {
        this.suspended_cgs_.push(this.cg_);
        this.cg_ = cg;
    }

    private void switchToPreviousClassGenerator(boolean last_statement_has_return_value) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (!last_statement_has_return_value) {
            mg.loadNil();
        }
        mg.returnValue();
        mg.endMethod();
        this.cg_.visitEnd();
        this.compilation_results_.add(this.cg_.getCompilationResult());
        this.cg_ = this.suspended_cgs_.pop();
    }

    public CompilationResults compile(Program program, RubyBinding binding2) {
        this.binding_ = binding2;
        RubyIDClassGenerator.initScript(this.extra_, this.script_name_);
        String className = NameFactory.createClassName(this.extra_, this.script_name_, null);
        this.cg_ = new ClassGeneratorForRubyProgram(className, this.script_name_, binding2, false, false);
        program.accept(this);
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (this.enableDebug) {
            mg.writeLocalVariableInfo();
        }
        mg.endMethod();
        this.cg_.visitEnd();
        this.compilation_results_.add(RubyIDClassGenerator.getCompilationResult());
        this.compilation_results_.add(this.cg_.getCompilationResult());
        return this.compilation_results_;
    }

    @Override
    public void visitClassDefinition1(String className, boolean has_scope) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (!this.isInGlobalScope() && !has_scope) {
            mg.loadCurrentClass(this.isInBlock());
        } else if (has_scope) {
            mg.checkCast(Types.RUBY_MODULE_TYPE);
        }
        mg.push(className);
    }

    @Override
    public void visitClassDefinition2(String className, boolean has_scope) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (has_scope) {
            mg.checkCast(Types.RUBY_MODULE_TYPE);
            mg.RubyModule_defineClass();
        } else if (this.isInGlobalScope()) {
            mg.RubyAPI_defineClass();
        } else {
            mg.RubyModule_defineClass();
        }
        this.callClassModuleBuilder(className, false);
    }

    private void callClassModuleBuilder(String name, boolean is_singleton) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        int i = mg.newLocal(Types.RUBY_VALUE_TYPE);
        mg.storeLocal(i);
        String uniqueName = NameFactory.createClassnameForClassModuleBuilder(this.extra_, this.script_name_, name);
        Type builder = Type.getType("L" + uniqueName + ";");
        mg.newInstance(builder);
        mg.dup();
        mg.invokeConstructor(builder, CgUtil.CONSTRUCTOR);
        mg.loadLocal(i);
        mg.pushNull();
        mg.pushNull();
        mg.loadLocal(i);
        mg.invokeVirtual(builder, CgUtil.getMethod("invoke", Types.RUBY_VALUE_TYPE, Types.RUBY_VALUE_TYPE, Types.RUBY_ARRAY_TYPE, Types.RUBY_BLOCK_TYPE, Types.RUBY_MODULE_TYPE));
        this.switchToNewClassGenerator(new ClassGeneratorForClassModuleBuilder(uniqueName, this.script_name_, null, is_singleton));
    }

    @Override
    public void visitSingletonClassDefinition() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        mg.RubyValue_getSingletonClass();
        this.callClassModuleBuilder("SINGLETON", true);
    }

    @Override
    public void visitClassDefinitionEnd(boolean last_statement_has_return_value) {
        this.switchToPreviousClassGenerator(last_statement_has_return_value);
    }

    @Override
    public void visitModuleDefinition(String moduleName, boolean has_scope) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (!mg.RubyRuntime_getBuiltinModule(moduleName)) {
            if (has_scope) {
                mg.checkCast(Types.RUBY_MODULE_TYPE);
                mg.RubyModule_defineModule(moduleName);
            } else if (this.isInGlobalScope()) {
                mg.RubyAPI_defineModule(moduleName);
            } else {
                mg.loadArg(3);
                mg.RubyModule_defineModule(moduleName);
            }
        }
        this.callClassModuleBuilder(moduleName, false);
    }

    @Override
    public void visitModuleDefinitionEnd(boolean last_statement_has_return_value) {
        this.switchToPreviousClassGenerator(last_statement_has_return_value);
    }

    @Override
    public int visitBlockBegin(StringBuilder name, boolean pulled) {
        String method_name = null;
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            method_name = ((ClassGeneratorForRubyMethod)this.cg_).getOrginalMethodName();
        } else if (this.cg_ instanceof ClassGeneratorForRubyBlock) {
            method_name = ((ClassGeneratorForRubyBlock)this.cg_).getOrginalMethodName();
        }
        String uniqueBlockName = NameFactory.createClassNameForBlock(this.extra_, this.script_name_, method_name);
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.new_BlockClass(this.cg_, uniqueBlockName, this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        assert (name.length() == 0);
        name.insert(0, uniqueBlockName);
        if (pulled) {
            int i = mg.newLocal(Type.getType("L" + uniqueBlockName + ";"));
            mg.storeLocal(i);
            return i;
        }
        return -1;
    }

    @Override
    public void visitBlockBodyBegin(String uniqueBlockName, int argc, boolean has_asterisk_parameter, int num_of_default_args, boolean is_for_in_expression, boolean has_extra_comma, boolean has_body) {
        this.switchToNewClassGenerator(new ClassGeneratorForRubyBlock(uniqueBlockName, this.script_name_, argc, has_asterisk_parameter, num_of_default_args, this.cg_, is_for_in_expression, has_extra_comma, this.binding_));
        if (has_body) {
            if (argc >= 1 || has_asterisk_parameter || is_for_in_expression) {
                this.cg_.getMethodGenerator().loadArg(1);
            } else {
                this.cg_.getMethodGenerator().loadNil();
            }
        }
        this.cg_.getMethodGenerator().getLabelManager().openNewScope();
    }

    @Override
    public void visitBlockBodyEnd(String uniqueBlockName, boolean last_statement_has_return_value, int saved_as_pulled) {
        int i;
        ClassGeneratorForRubyBlock block_cg = (ClassGeneratorForRubyBlock)this.cg_;
        String[] commons = block_cg.getFields();
        String[] assigned_commons = block_cg.getAssignedFields();
        String[] blocks = block_cg.getPreviousBlocks();
        block_cg.createFieldsAndConstructorOfRubyBlock(commons, blocks);
        this.cg_.getMethodGenerator().getLabelManager().closeCurrentScope();
        this.switchToPreviousClassGenerator(last_statement_has_return_value);
        if (saved_as_pulled >= 0) {
            this.cg_.getMethodGenerator().loadLocal(saved_as_pulled);
        }
        for (i = 0; i < commons.length; ++i) {
            this.cg_.getMethodGenerator().dup();
            this.cg_.loadVariable(commons[i]);
            this.cg_.getMethodGenerator().putField(Type.getType("L" + uniqueBlockName + ";"), ClassGenerator.decorateName(commons[i]), Types.RUBY_VALUE_TYPE);
        }
        for (i = 0; i < blocks.length; ++i) {
            this.cg_.getMethodGenerator().dup();
            this.cg_.getSharedBlock(blocks[i]);
            this.cg_.getMethodGenerator().putField(Type.getType("L" + uniqueBlockName + ";"), ClassGeneratorForRubyBlock.getNameFromFullpath(blocks[i]), Type.getType("L" + blocks[i] + ";"));
        }
        this.cg_.getMethodGenerator().storeVariablesAssignedInBlock(uniqueBlockName, assigned_commons, saved_as_pulled);
    }

    @Override
    public void visitBlockBody() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.mark(mg.getLabelManager().getCurrentRedo());
    }

    @Override
    public String visitMethodDefinition(String methodName, int num_of_args, boolean has_asterisk_parameter, int num_of_default_args, boolean is_singleton_method) {
        String uniqueMethodName = NameFactory.createClassName(this.extra_, this.script_name_, methodName);
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (!is_singleton_method) {
            mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        } else {
            mg.pushNull();
            mg.RubyValue_getSingletonClass();
        }
        mg.RubyModule_defineMethod(methodName, uniqueMethodName);
        this.switchToNewClassGenerator(ClassGeneratorForRubyMethodFactory.createClassGeneratorForRubyMethod(methodName, this.script_name_, uniqueMethodName, num_of_args, has_asterisk_parameter, num_of_default_args, is_singleton_method || mg.isSingleton()));
        return uniqueMethodName;
    }

    @Override
    public void visitMethodDefinitionParameter(String name) {
        this.cg_.addParameter(name);
    }

    @Override
    public void visitMethodDefinitionAsteriskParameter(String name, int argc) {
        this.cg_.setAsteriskParameter(name, argc);
    }

    @Override
    public void visitMethodDefinitionBlockParameter(String name) {
        this.cg_.setBlockParameter(name);
    }

    @Override
    public void visitMethodDefinitionEnd(boolean last_statement_has_return_value) {
        this.switchToPreviousClassGenerator(last_statement_has_return_value);
    }

    @Override
    public void visitMethodDefinitionDefaultParameters(int size2) {
        assert (size2 > 0);
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadArg(1);
        Label label = new Label();
        mg.ifNonNull(label);
        mg.ObjectFactory_createArray(size2, 0, false);
        mg.storeArg(1);
        mg.mark(label);
    }

    @Override
    public Object visitMethodDefinitionDefaultParameterBegin(int index2) {
        Label next_label = new Label();
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadMethodPrameterLength();
        mg.push(index2);
        mg.ifICmp(157, next_label);
        mg.loadArg(1);
        return next_label;
    }

    @Override
    public void visitMethodDefinitionDefaultParameterEnd(Object next_label) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.RubyArray_add(false);
        mg.pop();
        mg.mark((Label)next_label);
    }

    @Override
    public void visitNoParameter() {
        this.cg_.getMethodGenerator().pushNull();
    }

    @Override
    public void visitNoParameterForSuper() {
        if (this.cg_ instanceof ClassGeneratorForRubyBlock) {
            ((ClassGeneratorForRubyBlock)this.cg_).loadNoParameterForSuper();
        } else {
            this.cg_.getMethodGenerator().loadMethodArg();
        }
    }

    @Override
    public void visitNoBlock(boolean is_super_or_block_given_call) {
        if (is_super_or_block_given_call) {
            if (this.isInGlobalScope()) {
                this.cg_.getMethodGenerator().pushNull();
            } else {
                this.cg_.getMethodGenerator().loadBlock(this.isInBlock());
            }
        } else {
            this.cg_.getMethodGenerator().pushNull();
        }
    }

    @Override
    public void visitNoSuperClass() {
        this.cg_.getMethodGenerator().pushNull();
    }

    @Override
    public void visitBlockArgument() {
        this.cg_.getMethodGenerator().RubyAPI_convertRubyValue2RubyBlock();
    }

    @Override
    public void visitMethodCallBegin() {
        this.cg_.getMethodGenerator().addCurrentVariablesOnStack(Types.RUBY_VALUE_CLASS);
    }

    @Override
    public void visitMethodCallEnd(String methodName, boolean hasReceiver, String blockName, int argc) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.removeCurrentVariablesOnStack();
        if (hasReceiver) {
            switch (argc) {
                case 0: {
                    mg.RubyAPI_callPublicNoArgMethod(methodName);
                    break;
                }
                case 1: {
                    mg.RubyAPI_callPublicOneArgMethod(methodName);
                    break;
                }
                case 2: {
                    mg.RubyAPI_callPublicTwoArgMethod(methodName);
                    break;
                }
                default: {
                    mg.RubyAPI_callPublicMethod(methodName);
                    break;
                }
            }
        } else {
            switch (argc) {
                case 0: {
                    mg.RubyAPI_callNoArgMethod(methodName);
                    break;
                }
                case 1: {
                    mg.RubyAPI_callOneArgMethod(methodName);
                    break;
                }
                case 2: {
                    mg.RubyAPI_callTwoArgMethod(methodName);
                    break;
                }
                default: {
                    mg.RubyAPI_callMethod(methodName);
                }
            }
        }
        mg.returnIfBlockReturned();
    }

    @Override
    public void visitBinaryOperator(String operator) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.pushNull();
        if (operator.equals("!=")) {
            mg.RubyAPI_callPublicOneArgMethod("==");
            mg.RubyAPI_operatorNot();
        } else if (operator.equals("!~")) {
            mg.RubyAPI_callPublicOneArgMethod("=~");
            mg.RubyAPI_operatorNot();
        } else {
            mg.RubyAPI_callPublicOneArgMethod(operator);
        }
    }

    @Override
    public Object visitAndBinaryOperatorLeft() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.dup();
        Label label = (Label)this.visitAfterIfCondition();
        mg.pop();
        return label;
    }

    @Override
    public void visitAndBinaryOperatorRight(Object label) {
        this.cg_.getMethodGenerator().mark((Label)label);
    }

    @Override
    public Object visitOrBinaryOperatorLeft() {
        this.cg_.getMethodGenerator().dup();
        Label label = (Label)this.visitAfterUnlessCondition();
        this.cg_.getMethodGenerator().pop();
        return label;
    }

    @Override
    public void visitOrBinaryOperatorRight(Object label) {
        this.visitAndBinaryOperatorRight(label);
    }

    @Override
    public void visitUnaryOperator(String operator) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (operator.equals("!")) {
            mg.RubyAPI_operatorNot();
        } else {
            mg.pushNull();
            mg.pushNull();
            mg.RubyAPI_callPublicMethod(operator);
        }
    }

    @Override
    public void visitGlobalVariableAssignmentOperator(String var, boolean rhs_is_method_call, boolean is_multiple_assign) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (rhs_is_method_call) {
            mg.RubyAPI_expandArrayIfThereIsZeroOrOneValue();
        }
        mg.GlobalVatiables_set(var);
        if (is_multiple_assign) {
            mg.pop();
        }
    }

    @Override
    public void visitLocalVariableAssignmentOperator(String var, boolean rhs_is_method_call, boolean is_multiple_assign) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (rhs_is_method_call) {
            mg.RubyAPI_expandArrayIfThereIsZeroOrOneValue();
        }
        if (!is_multiple_assign) {
            mg.dup();
        }
        this.cg_.storeVariable(var);
        SymbolTable table = mg.getSymbolTable();
        if (this.enableDebug && table.isNewLocalVar(var)) {
            table.setVarLineNumberInfo(var, this.currentLineLabel);
        }
    }

    @Override
    public void visitFloatExpression(double value2) {
        this.cg_.getMethodGenerator().ObjectFactory_createFloat(value2);
    }

    @Override
    public void visitFixnumExpression(int value2) {
        this.cg_.getMethodGenerator().ObjectFactory_createFixnum(value2);
    }

    @Override
    public void visitBignumExpression(BigInteger value2) {
        this.cg_.getMethodGenerator().ObjectFactory_createBignum(value2);
    }

    @Override
    public void visitStringExpression(String value2) {
        this.cg_.getMethodGenerator().ObjectFactory_createString(value2);
    }

    @Override
    public void visitStringExpressionWithExpressionSubstitutionBegin() {
        this.cg_.getMethodGenerator().ObjectFactory_createString();
    }

    @Override
    public void visitStringExpressionWithExpressionSubstitution(String value2) {
        this.cg_.getMethodGenerator().RubyString_append(value2);
    }

    @Override
    public void visitStringExpressionWithExpressionSubstitution() {
        this.cg_.getMethodGenerator().RubyString_append();
    }

    @Override
    public void visitStringExpressionWithExpressionSubstitutionEnd() {
    }

    @Override
    public void visitRegexpExpressionWithExpressionSubstitutionEnd(String option) {
        this.cg_.getMethodGenerator().ObjectFactory_createRegexp(option);
    }

    @Override
    public void visitCommandOutputExpressionWithExpressionSubstitutionEnd() {
        this.cg_.getMethodGenerator().RubyAPI_runCommandAndCaptureOutput();
    }

    @Override
    public void visitRegexpExpression(String value2, String option) {
        this.cg_.getMethodGenerator().ObjectFactory_createRegexp(value2, option);
    }

    @Override
    public void visitSymbolExpression(String value2) {
        this.cg_.getMethodGenerator().ObjectFactory_createSymbol(value2);
    }

    @Override
    public void visitTerminal() {
        this.cg_.getMethodGenerator().pop();
    }

    @Override
    public void visitEof(boolean last_statement_has_return_value) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (!last_statement_has_return_value) {
            mg.loadNil();
        }
        mg.returnValue();
    }

    @Override
    public void visitLocalVariableExpression(String value2) {
        this.cg_.loadVariable(value2);
    }

    @Override
    public void visitNilExpression() {
        this.cg_.getMethodGenerator().loadNil();
    }

    @Override
    public Object visitAfterIfCondition() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.RubyValue_isTrue();
        Label label = new Label();
        mg.ifZCmp(153, label);
        return label;
    }

    @Override
    public void visitWhileConditionBegin(boolean do_first) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        LabelManager lm = mg.getLabelManager();
        lm.openNewScope();
        if (do_first) {
            mg.goTo(lm.getCurrentRedo());
        }
        mg.mark(lm.getCurrentNext());
    }

    @Override
    public void visitWhileConditionEnd(boolean always_true, boolean is_until) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (always_true) {
            mg.push(true);
        } else {
            mg.RubyValue_isTrue();
        }
        if (is_until) {
            mg.ifZCmp(154, mg.getLabelManager().getCurrentX());
        } else {
            mg.ifZCmp(153, mg.getLabelManager().getCurrentX());
        }
        mg.mark(mg.getLabelManager().getCurrentRedo());
    }

    @Override
    public void visitWhileBodyEnd(boolean has_body) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (has_body) {
            mg.pop();
        }
        LabelManager lm = mg.getLabelManager();
        mg.goTo(lm.getCurrentNext());
        mg.mark(lm.getCurrentX());
        this.visitNilExpression();
        mg.mark(lm.getCurrentBreak());
        lm.closeCurrentScope();
    }

    @Override
    public Object visitAfterIfBody(Object next_label, Object end_label) {
        if (null == end_label) {
            end_label = new Label();
        }
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (null != next_label) {
            mg.goTo((Label)end_label);
            mg.mark((Label)next_label);
        } else {
            mg.mark((Label)end_label);
        }
        return end_label;
    }

    @Override
    public Object visitAfterCaseCondition() {
        int i = this.cg_.getAnonymousLocalVariable();
        this.cg_.getMethodGenerator().storeLocal(i);
        return i;
    }

    @Override
    public Object visitAfterWhenCondition(Object case_value, boolean mrhs) {
        int i = (Integer)case_value;
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadLocal(i);
        if (!mrhs) {
            mg.RubyAPI_testCaseEqual();
        } else {
            mg.RubyAPI_testCaseEqual2();
        }
        Label label = new Label();
        mg.ifZCmp(153, label);
        return label;
    }

    @Override
    public Object visitAfterWhenConditionNotNil(Object case_value) {
        int i = (Integer)case_value;
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadLocal(i);
        mg.RubyAPI_testCaseEqualNotNil();
        Label label = new Label();
        mg.ifZCmp(153, label);
        return label;
    }

    @Override
    public Object visitAfterWhenBody(Object next_label, Object end_label) {
        return this.visitAfterIfBody(next_label, end_label);
    }

    @Override
    public void visitTrueExpression() {
        this.cg_.getMethodGenerator().loadTrue();
    }

    @Override
    public void visitFalseExpression() {
        this.cg_.getMethodGenerator().loadFalse();
    }

    @Override
    public Object visitAfterUnlessCondition() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.RubyValue_isTrue();
        Label label = new Label();
        mg.ifZCmp(154, label);
        return label;
    }

    @Override
    public Object visitAfterUnlessBody(Object next_label, Object end_label) {
        return this.visitAfterIfBody(next_label, end_label);
    }

    @Override
    public Object visitBodyBegin(boolean has_ensure) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.saveCurrentVariablesOnStack();
        mg.getEnsureLabelManager().openNewScope();
        if (has_ensure) {
            mg.getEnsureLabelManager().setCurrentFinally(new Label());
        }
        mg.mark(mg.getEnsureLabelManager().getCurrentRetry());
        return mg.getEnsureLabelManager().getCurrentRetry();
    }

    @Override
    public Object visitBodyAfter() {
        return this.cg_.getMethodGenerator().mark();
    }

    @Override
    public void visitBodyEnd(Object label) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.mark((Label)label);
        mg.getEnsureLabelManager().closeCurrentScope();
        mg.restoreCurrentVariablesOnStack();
    }

    @Override
    public int visitEnsureBodyBegin() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.mark(mg.getEnsureLabelManager().getCurrentFinally());
        mg.getEnsureLabelManager().setCurrentFinally(null);
        int var = mg.newLocal(Type.getType(Object.class));
        mg.storeLocal(var);
        return var;
    }

    @Override
    public void visitEnsureBodyEnd(int var) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.pop();
        mg.ret(var);
    }

    public Object visitPrepareEnsure1() {
        Label label = new Label();
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.visitJumpInsn(168, mg.getEnsureLabelManager().getCurrentFinally());
        return label;
    }

    @Override
    public void visitEnsure(int exception_var) {
        if (exception_var >= 0) {
            MethodGenerator mg = this.cg_.getMethodGenerator();
            Label l = mg.getEnsureLabelManager().getCurrentFinally();
            if (null != l) {
                mg.visitJumpInsn(168, l);
            }
            mg.loadLocal(exception_var);
            mg.throwException();
        } else {
            this.invokeFinallyIfExist();
        }
    }

    @Override
    public Object visitPrepareEnsure() {
        Label after_exception = new Label();
        this.cg_.getMethodGenerator().goTo(after_exception);
        return after_exception;
    }

    @Override
    public int visitRescueBegin(Object begin, Object end) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.catchRubyException((Label)begin, (Label)end);
        int exception_variable = this.cg_.getAnonymousLocalVariable();
        mg.storeLocal(exception_variable);
        return exception_variable;
    }

    @Override
    public void visitRescueEnd(int exception_variable, boolean has_ensure) {
        if (!has_ensure) {
            MethodGenerator mg = this.cg_.getMethodGenerator();
            mg.loadLocal(exception_variable);
            mg.throwException();
        }
    }

    @Override
    public Object visitRescueVariable(String name, int exception_variable) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadLocal(exception_variable);
        mg.RubyAPI_testExceptionType();
        Label label = new Label();
        mg.ifZCmp(153, label);
        if (null != name) {
            mg.loadLocal(exception_variable);
            mg.RubyAPI_convertRubyException2RubyValue();
            this.cg_.storeVariable(name);
        }
        return label;
    }

    @Override
    public void visitAfterRescueBody(Object next_label, Object end_label) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.goTo((Label)end_label);
        mg.mark((Label)next_label);
    }

    @Override
    public void visitArrayBegin(int size2, int rhs_size, boolean has_single_asterisk) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.ObjectFactory_createArray(size2, rhs_size, has_single_asterisk);
        mg.addCurrentVariablesOnStack(Types.RUBY_ARRAY_CLASS);
    }

    @Override
    public void visitHashBegin() {
        this.cg_.getMethodGenerator().ObjectFactory_createHash();
    }

    @Override
    public void visitArrayElement(boolean asterisk, boolean is_method_call) {
        if (asterisk) {
            this.cg_.getMethodGenerator().RubyArray_expand(is_method_call);
        } else {
            this.cg_.getMethodGenerator().RubyArray_add(is_method_call);
        }
    }

    @Override
    public void visitBinding(boolean single_arg) {
        this.cg_.createBinding(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        if (!single_arg) {
            this.cg_.getMethodGenerator().RubyArray_add(false);
        }
    }

    @Override
    public void visitHashElement() {
        this.cg_.getMethodGenerator().RubyHash_addValue();
    }

    @Override
    public void visitArrayEnd() {
        this.cg_.getMethodGenerator().removeCurrentVariablesOnStack();
    }

    @Override
    public void visitHashEnd() {
    }

    @Override
    public void visitYieldBegin() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadBlock(this.isInBlock());
        mg.dup();
        this.visitSelfExpression();
    }

    @Override
    public void visitYieldEnd(int argc) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        switch (argc) {
            case 0: {
                mg.RubyBlock_invokeNoArg(this.isInBlock());
                break;
            }
            case 1: {
                mg.RubyBlock_invokeOneArg(this.isInBlock());
                break;
            }
            default: {
                mg.RubyBlock_invoke(this.isInBlock());
            }
        }
        mg.checkBreakedOrReturned(this.isInBlock());
    }

    @Override
    public void visitSuperBegin() {
        this.cg_.getMethodGenerator().loadArg(0);
    }

    @Override
    public void visitImplicitSuperEnd() {
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            ((ClassGeneratorForRubyMethod)this.cg_).callSuperMethod(true, false);
        } else {
            ((ClassGeneratorForRubyBlock)this.cg_).callSuperMethod(true, false);
        }
    }

    @Override
    public void visitExplicitSuperEnd(int argc) {
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            MethodGenerator mg = this.cg_.getMethodGenerator();
            switch (argc) {
                case 0: {
                    mg.RubyAPI_callSuperNoArgMethod();
                    break;
                }
                case 1: {
                    mg.RubyAPI_callSuperOneArgMethod();
                    break;
                }
                case 2: {
                    mg.RubyAPI_callSuperTwoArgMethod();
                    break;
                }
                default: {
                    mg.RubyAPI_callSuperMethod();
                    break;
                }
            }
        } else {
            ((ClassGeneratorForRubyBlock)this.cg_).callSuperMethod(false, 1 == argc);
        }
    }

    @Override
    public void visitGlobalVariableExpression(String value2) {
        this.cg_.getMethodGenerator().GlobalVatiables_get(value2);
    }

    @Override
    public void visitCommandOutputExpression(String value2) {
        this.cg_.getMethodGenerator().RubyAPI_runCommandAndCaptureOutput(value2);
    }

    private void invokeFinallyIfExist() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        Label l = mg.getEnsureLabelManager().getCurrentFinally();
        if (null != l) {
            int tmp = this.cg_.getAnonymousLocalVariable();
            mg.storeLocal(tmp);
            mg.visitJumpInsn(168, l);
            mg.loadLocal(tmp);
        }
    }

    @Override
    public void visitReturn() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (this.isInBlock()) {
            this.invokeFinallyIfExist();
            mg.RubyBlock__return__();
            mg.returnValue();
        } else {
            this.invokeFinallyIfExist();
            mg.returnValue();
        }
    }

    @Override
    public void visitAliasGlobalVariable(String newName, String oldName) {
        this.cg_.getMethodGenerator().GlobalVariables_alias(newName, oldName);
    }

    @Override
    public void visitAliasMethod(String newName, String oldName) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentClass(this.isInBlock());
        mg.RubyModule_aliasMethod(newName, oldName);
    }

    @Override
    public void visitUndef(String name) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentClass(this.isInBlock());
        mg.RubyModule_undefMethod(name);
    }

    @Override
    public void visitSelfExpression() {
        this.cg_.getMethodGenerator().loadSelf(this.isInBlock());
    }

    @Override
    public void visitClassVariableExpression(String name) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        mg.RubyModule_getClassVariable(name);
    }

    @Override
    public void visitClassVariableAssignmentOperator(String name, boolean rhs_is_method_call, boolean is_multiple_assign) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (rhs_is_method_call) {
            mg.RubyAPI_expandArrayIfThereIsZeroOrOneValue();
        }
        mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        mg.swap();
        mg.RubyModule_setClassVariable(name);
        if (is_multiple_assign) {
            mg.pop();
        }
    }

    @Override
    public void visitInstanceVariableExpression(String name) {
        this.visitSelfExpression();
        this.cg_.getMethodGenerator().RubyValue_getInstanceVariable(name);
    }

    @Override
    public void visitInstanceVariableAssignmentOperator(String name, boolean rhs_is_method_call, boolean is_multiple_assign) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (rhs_is_method_call) {
            mg.RubyAPI_expandArrayIfThereIsZeroOrOneValue();
        }
        this.visitSelfExpression();
        mg.swap();
        mg.RubyValue_setInstanceVariable(name);
        if (is_multiple_assign) {
            mg.pop();
        }
    }

    @Override
    public void visitMrhs(int var, int index2, boolean asterisk) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadLocal(var);
        if (asterisk) {
            mg.RubyArray_collect(index2);
        } else {
            mg.RubyArray_get(index2);
        }
    }

    @Override
    public int visitMultipleAssignment(boolean single_lhs, boolean has_mlhs, boolean has_mrhs) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.dup();
        if (single_lhs && !has_mrhs) {
            return 0;
        }
        if (single_lhs) {
            mg.RubyAPI_expandArrayIfThereIsZeroOrOneValue2();
            return 0;
        }
        if (has_mlhs) {
            mg.RubyAPI_expandArrayIfThereIsOnlyOneRubyArray();
            return mg.saveRubyArrayAsLocalVariable();
        }
        return mg.saveRubyArrayAsLocalVariable();
    }

    @Override
    public int visitNestedVariable(boolean single_lhs, boolean has_mlhs) {
        if (single_lhs) {
            return 0;
        }
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.RubyAPI_convertToArrayIfNotYet();
        if (has_mlhs) {
            mg.RubyAPI_expandArrayIfThereIsOnlyOneRubyArray();
        }
        return mg.saveRubyArrayAsLocalVariable();
    }

    @Override
    public void visitBreak() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (this.isInBlock() && mg.getLabelManager().isAtTopLevel()) {
            this.invokeFinallyIfExist();
            mg.RubyBlock__break__();
            mg.returnValue();
        } else {
            this.invokeFinallyIfExist();
            mg.goTo(mg.getLabelManager().getCurrentBreak());
        }
    }

    @Override
    public void visitNext() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (this.isInBlock() && mg.getLabelManager().isAtTopLevel()) {
            mg.returnValue();
        } else {
            mg.pop();
            mg.goTo(mg.getLabelManager().getCurrentNext());
        }
    }

    @Override
    public void visitRedo() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.goTo(mg.getLabelManager().getCurrentRedo());
    }

    @Override
    public void visitRetry() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (this.isInBlock() && mg.getLabelManager().isAtTopLevel()) {
            mg.RubyBlock__retry__();
            mg.loadNil();
            mg.returnValue();
        } else {
            mg.goTo(mg.getEnsureLabelManager().getCurrentRetry());
        }
    }

    @Override
    public void visitExclusiveRangeOperator() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.push(true);
        mg.ObjectFactory_createRange();
    }

    @Override
    public void visitInclusiveRangeOperator() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.push(false);
        mg.ObjectFactory_createRange();
    }

    @Override
    public void visitCurrentNamespaceConstant(String name) {
        if (this.isInGlobalScope()) {
            this.visitTopLevelConstant(name);
            return;
        }
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        mg.RubyAPI_getCurrentNamespaceConstant(name);
    }

    @Override
    public void visitConstant(String name) {
        this.cg_.getMethodGenerator().RubyAPI_getConstant(name);
    }

    @Override
    public void visitTopLevelConstant(String name) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (mg.RubyRuntime_getBuiltinClass(name)) {
            return;
        }
        if (mg.RubyRuntime_getBuiltinModule(name)) {
            return;
        }
        this.loadTopScope();
        mg.RubyAPI_getCurrentNamespaceConstant(name);
    }

    private void loadTopScope() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        if (this.isInGlobalScope()) {
            mg.loadCurrentClass(false);
        } else {
            mg.RubyRuntime_GlobalScope();
        }
    }

    @Override
    public void visitCurrentNamespaceConstantAssignmentOperator(String name, boolean rhs_is_method_call, boolean is_multiple_assign) {
        if (this.isInGlobalScope()) {
            this.visitTopLevelConstantAssignmentOperator(name, rhs_is_method_call, is_multiple_assign);
            return;
        }
        this.cg_.getMethodGenerator().loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        this.visitConstantAssignmentOperator(name, rhs_is_method_call, is_multiple_assign);
    }

    @Override
    public void visitConstantAssignmentOperator(String name, boolean rhs_is_method_call, boolean is_multiple_assignment) {
        this.cg_.getMethodGenerator().RubyAPI_setConstant(name);
    }

    @Override
    public void visitTopLevelConstantAssignmentOperator(String name, boolean rhs_is_method_call, boolean is_multiple_assignment) {
        this.cg_.getMethodGenerator().RubyAPI_setTopLevelConstant(name);
    }

    @Override
    public void visitDefinedPublicMethod(String name) {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        mg.RubyAPI_isDefinedPublicMethod(name);
    }

    @Override
    public void visitDefinedCurrentNamespaceConstant(String name) {
        if (Types.isBuiltinClass(name) || Types.isBuiltinModule(name)) {
            this.visitStringExpression("constant");
            return;
        }
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.loadCurrentScope(this.isInClassBuilder(), this.isInSingletonMethod(), this.isInGlobalScope(), this.isInBlock());
        mg.RubyAPI_isDefinedCurrentNamespaceConstant(name);
    }

    @Override
    public void visitDefinedTopLevelConstant(String name) {
        if (Types.isBuiltinClass(name) || Types.isBuiltinModule(name)) {
            this.visitStringExpression("constant");
            return;
        }
        this.loadTopScope();
        this.cg_.getMethodGenerator().RubyAPI_isDefinedCurrentNamespaceConstant(name);
    }

    @Override
    public void visitDefinedConstant(String name) {
        this.cg_.getMethodGenerator().RubyAPI_isDefinedCurrentNamespaceConstant(name);
    }

    @Override
    public void visitDefinedMethod(String name) {
        this.cg_.getMethodGenerator().RubyAPI_isDefinedMethod(name);
    }

    @Override
    public void visitDefinedSuperMethod() {
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            this.visitSelfExpression();
            this.cg_.getMethodGenerator().RubyAPI_isDefinedSuperMethod(((ClassGeneratorForRubyMethod)this.cg_).getOrginalMethodName());
        } else {
            this.visitNilExpression();
        }
    }

    @Override
    public void visitDefinedLocalVariable(String name) {
        if (this.cg_.getSymbolTable().isDefinedInCurrentScope(name)) {
            this.visitStringExpression("local-variable");
        } else {
            this.visitNilExpression();
        }
    }

    @Override
    public void visitDefinedInstanceVariable(String name) {
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            this.visitSelfExpression();
            this.cg_.getMethodGenerator().RubyAPI_isDefinedInstanceVariable(name);
        } else {
            this.visitNilExpression();
        }
    }

    @Override
    public void visitDefinedYield() {
        if (this.cg_ instanceof ClassGeneratorForRubyMethod) {
            MethodGenerator mg = this.cg_.getMethodGenerator();
            mg.loadCurrentBlock();
            mg.RubyAPI_isDefinedYield();
        } else {
            this.visitNilExpression();
        }
    }

    @Override
    public boolean isDefinedInCurrentScope(String name) {
        return this.cg_.isDefinedInCurrentScope(name);
    }

    @Override
    public void visitSpecialLambdaCallBegin() {
        this.visitSelfExpression();
    }

    @Override
    public void visitSpecialLambdaCallEnd() {
        this.cg_.getMethodGenerator().RubyBlock_invoke(this.isInBlock());
    }

    @Override
    public void visitPotentialProcCall() {
        MethodGenerator mg = this.cg_.getMethodGenerator();
        mg.dup();
        mg.instanceOf(Types.RUBY_PROC_TYPE);
        Label label1 = new Label();
        mg.ifZCmp(153, label1);
        mg.dup();
        mg.checkCast(Types.RUBY_PROC_TYPE);
        mg.dup();
        mg.RubyProc_isDefinedInAnotherBlock();
        Label label2 = new Label();
        mg.ifZCmp(154, label2);
        this.cg_.addVariableToBinding();
        mg.mark(label2);
        mg.pop();
        mg.mark(label1);
    }

    @Override
    public void visitMultipleArrayAssign() {
        this.cg_.getMethodGenerator().RubyAPI_callArraySet();
    }

    @Override
    public Label visitLineLabel(int lineNumber) {
        if (this.enableDebug) {
            this.currentLineLabel = this.cg_.getMethodGenerator().mark();
            this.cg_.getMethodGenerator().visitLineNumber(lineNumber, this.currentLineLabel);
            return this.currentLineLabel;
        }
        return null;
    }
}

