/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codegen;

import com.xruby.compiler.codegen.CompilationResult;
import com.xruby.compiler.codegen.NameFactory;
import com.xruby.compiler.codegen.Types;
import com.xruby.runtime.lang.RubyID;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class RubyIDClassGenerator {
    private static String RubyIDClassName;
    private static Map<String, String> idMap;
    private static long counter;

    private static boolean isAlphabeta(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isValidJavaID(String s) {
        char firstChar = s.charAt(0);
        if (firstChar == '_' || RubyIDClassGenerator.isAlphabeta(firstChar)) {
            int len = s.length();
            for (int i = 1; i < len; ++i) {
                char currentChar = s.charAt(i);
                if (currentChar == '_' || RubyIDClassGenerator.isAlphabeta(currentChar) || RubyIDClassGenerator.isNumber(currentChar)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String nextID() {
        return "ID" + counter++;
    }

    public static void initScript(String extra, String script_name) {
        RubyIDClassName = NameFactory.createClassNameForIDContainer(extra, script_name);
    }

    public static void clear() {
        idMap.clear();
    }

    public static void getField(GeneratorAdapter mg, String s) {
        String id = idMap.get(s);
        if (id == null) {
            id = RubyIDClassGenerator.isValidJavaID(s) ? s + "ID" : RubyIDClassGenerator.nextID();
            idMap.put(s, id);
        }
        mg.getStatic(Type.getType("L" + RubyIDClassName + ";"), id, Types.RUBY_ID_TYPE);
    }

    private static byte[] visitEnd() {
        ClassWriter cw = new ClassWriter(1);
        cw.visit(196653, 1, RubyIDClassName, null, "java/lang/Object", null);
        Method staticBlock = Method.getMethod("void <clinit> ()V");
        GeneratorAdapter staticBlockMg = new GeneratorAdapter(8, staticBlock, null, null, cw);
        for (Map.Entry<String, String> e : idMap.entrySet()) {
            cw.visitField(9, e.getValue(), Types.RUBY_ID_TYPE.getDescriptor(), null, null);
            staticBlockMg.push(e.getKey());
            staticBlockMg.invokeStatic(Type.getType(RubyID.class), Method.getMethod("com.xruby.runtime.lang.RubyID intern(String)"));
            staticBlockMg.putStatic(Type.getType("L" + RubyIDClassName + ";"), e.getValue(), Types.RUBY_ID_TYPE);
        }
        staticBlockMg.returnValue();
        staticBlockMg.endMethod();
        cw.visitEnd();
        RubyIDClassGenerator.clear();
        return cw.toByteArray();
    }

    public static CompilationResult getCompilationResult() {
        return new CompilationResult(RubyIDClassName, RubyIDClassGenerator.visitEnd());
    }

    static {
        idMap = new HashMap<String, String>();
        counter = 0L;
    }
}

