/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.parser;

import com.xruby.compiler.parser.SymbolTable;
import com.xruby.compiler.parser.SymbolTableForBlock;
import java.util.List;
import java.util.Stack;

public class SymbolTableManager {
    private Stack<SymbolTable> stStack = new Stack();

    public SymbolTableManager() {
        this.enterScope();
    }

    public SymbolTableManager(List<String> preDefinedVar) {
        this.enterScope();
        for (String s : preDefinedVar) {
            this.addVariable(s);
        }
    }

    public void enterScope() {
        this.stStack.add(new SymbolTable());
    }

    public void enterBlockScope() {
        this.stStack.add(new SymbolTableForBlock(this.stStack.peek()));
    }

    public void leaveScope() {
        this.stStack.pop();
    }

    public boolean isDefinedInCurrentScope(String s) {
        return this.stStack.peek().findVariable(s);
    }

    public void addVariable(String s) {
        this.stStack.peek().addVariable(s);
    }
}

