/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyTypesUtil;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;

class ArrayPacker {
    private static final long[] utf8_limits = new long[]{0L, 128L, 2048L, 65536L, 0x200000L, 0x4000000L, Integer.MIN_VALUE};

    ArrayPacker() {
    }

    private static int uv_to_utf8(char[] buf, long uv) {
        if (uv <= 127L) {
            buf[0] = (char)uv;
            return 1;
        }
        if (uv <= 2047L) {
            buf[0] = (char)(uv >> 6 & 0xFFL | 0xC0L);
            buf[1] = (char)(uv & 0x3FL | 0x80L);
            return 2;
        }
        if (uv <= 65535L) {
            buf[0] = (char)(uv >> 12 & 0xFFL | 0xE0L);
            buf[1] = (char)(uv >> 6 & 0x3FL | 0x80L);
            buf[2] = (char)(uv & 0x3FL | 0x80L);
            return 3;
        }
        if (uv <= 0x1FFFFFL) {
            buf[0] = (char)(uv >> 18 & 0xFFL | 0xF0L);
            buf[1] = (char)(uv >> 12 & 0x3FL | 0x80L);
            buf[2] = (char)(uv >> 6 & 0x3FL | 0x80L);
            buf[3] = (char)(uv & 0x3FL | 0x80L);
            return 4;
        }
        if (uv <= 0x3FFFFFFL) {
            buf[0] = (char)(uv >> 24 & 0xFFL | 0xF8L);
            buf[1] = (char)(uv >> 18 & 0x3FL | 0x80L);
            buf[2] = (char)(uv >> 12 & 0x3FL | 0x80L);
            buf[3] = (char)(uv >> 6 & 0x3FL | 0x80L);
            buf[4] = (char)(uv & 0x3FL | 0x80L);
            return 5;
        }
        if (uv <= Integer.MAX_VALUE) {
            buf[0] = (char)(uv >> 30 & 0xFFL | 0xFCL);
            buf[1] = (char)(uv >> 24 & 0x3FL | 0x80L);
            buf[2] = (char)(uv >> 18 & 0x3FL | 0x80L);
            buf[3] = (char)(uv >> 12 & 0x3FL | 0x80L);
            buf[4] = (char)(uv >> 6 & 0x3FL | 0x80L);
            buf[5] = (char)(uv & 0x3FL | 0x80L);
            return 6;
        }
        throw new RubyException(RubyRuntime.RangeErrorClass, "pack(U): value out of range");
    }

    private static long[] utf8_to_uv(String str, int p2, long lenp) {
        long n;
        int c;
        long uv;
        if (0L == ((uv = (long)(c = str.charAt(p2++) & 0xFF)) & 0x80L)) {
            lenp = 1L;
            return new long[]{uv, lenp};
        }
        if (0L == (uv & 0x40L)) {
            lenp = 1L;
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "malformed UTF-8 character");
        }
        if (0L == (uv & 0x20L)) {
            n = 2L;
            uv &= 0x1FL;
        } else if (0L == (uv & 0x10L)) {
            n = 3L;
            uv &= 0xFL;
        } else if (0L == (uv & 8L)) {
            n = 4L;
            uv &= 7L;
        } else if (0L == (uv & 4L)) {
            n = 5L;
            uv &= 3L;
        } else if (0L == (uv & 2L)) {
            n = 6L;
            uv &= 1L;
        } else {
            lenp = 1L;
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "malformed UTF-8 character");
        }
        if (n > lenp) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "malformed UTF-8 character (expected " + n + " bytes, given " + lenp + "bytes)");
        }
        lenp = n--;
        if (n != 0L) {
            while (n-- != 0L) {
                if (((c = str.charAt(p2++) & 0xFF) & 0xC0) != 128) {
                    lenp -= n + 1L;
                    throw new RubyException(RubyRuntime.ArgumentErrorClass, "malformed UTF-8 character");
                }
                uv = uv << 6 | (long)(c &= 0x3F);
            }
        }
        if (uv < utf8_limits[(int)(n = lenp - 1L)]) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "redundant UTF-8 sequence");
        }
        return new long[]{uv, lenp};
    }

    private static String qpencode(String str, int len) {
        throw new RubyException("Not implemented");
    }

    private static String encodes(String str, int todo, char type) {
        throw new RubyException("Not implemented");
    }

    public static RubyArray unpack(String str, String format2) {
        int s = 0;
        int send = str.length();
        RubyArray ary = new RubyArray();
        int p2 = 0;
        while (p2 < format2.length()) {
            int len;
            char type;
            if ((type = format2.charAt(p2++)) == ' ') continue;
            if (format2.indexOf(p2) == 35) {
                while (p2 < format2.length() && format2.charAt(p2) != '\n') {
                    ++p2;
                }
                continue;
            }
            char t = p2 >= format2.length() ? (char)'\u0000' : format2.charAt(p2);
            if (t == '_' || t == '!') {
                String natstr = "sSiIlL";
                if ("sSiIlL".indexOf(type) >= 0) {
                    ++p2;
                } else {
                    throw new RubyException(RubyRuntime.ArgumentErrorClass, String.format("'%c' allowed only after types %s", Character.valueOf(type), "sSiIlL"));
                }
            }
            if (p2 > format2.length()) {
                len = 1;
            } else if (t == '*') {
                len = send - s;
                ++p2;
            } else if (Character.isDigit(t)) {
                int end;
                for (end = p2; end < format2.length() - 1 && Character.isDigit(format2.indexOf(end + 1)); ++end) {
                }
                len = Integer.parseInt(format2.substring(p2, end + 1), 10);
            } else {
                len = type != '@' ? 1 : 0;
            }
            switch (type) {
                case '%': {
                    throw new RubyException(RubyRuntime.ArgumentErrorClass, "%% is not supported");
                }
                case 'a': {
                    if (len > send - s) {
                        len = send - s;
                    }
                    ary.add(ObjectFactory.createString(str.substring(s, s + len)));
                    s += len;
                    break;
                }
                case 'c': {
                    while (len-- > 0) {
                        int c;
                        if ((c = str.charAt(s++)) > 127) {
                            c -= 256;
                        }
                        ary.add(ObjectFactory.createFixnum(c));
                    }
                    break;
                }
                case 'C': {
                    while (len-- > 0) {
                        char c = str.charAt(s++);
                        ary.add(ObjectFactory.createFixnum(c));
                    }
                    break;
                }
                case 's': {
                    int j;
                    while (len-- > 0) {
                        int tmp = 0;
                        for (j = 0; j < 2; ++j) {
                            char c = str.charAt(s++);
                            tmp = (short)(tmp + (c << j * 8));
                        }
                        ary.add(ObjectFactory.createFixnum(tmp));
                    }
                    break;
                }
                case 'i': 
                case 'l': {
                    int j;
                    while (len-- > 0) {
                        int tmp = 0;
                        for (j = 0; j < 4; ++j) {
                            char c = str.charAt(s++);
                            tmp += c << j * 8;
                        }
                        ary.add(ObjectFactory.createFixnum(tmp));
                    }
                    break;
                }
                case 'q': {
                    long c;
                    if (str.length() < 8) {
                        ary.add(RubyConstant.QNIL);
                        break;
                    }
                    long l = 0L;
                    for (int j = 0; j < 8; ++j) {
                        c = str.charAt(s++);
                        l += c << j * 8;
                    }
                    ary.add(ObjectFactory.createInteger(l));
                    break;
                }
                case 'x': {
                    if (len > send - s) {
                        throw new RubyException(RubyRuntime.ArgumentErrorClass, "x outside of string");
                    }
                    s += len;
                    break;
                }
                case 'D': 
                case 'd': {
                    long c;
                    while (len-- > 0) {
                        long tmp = 0L;
                        for (int j = 0; j < 8; ++j) {
                            c = str.charAt(s++);
                            tmp += c << j * 8;
                        }
                        ary.add(ObjectFactory.createFloat(Double.longBitsToDouble(tmp)));
                    }
                    break;
                }
                case 'U': {
                    if (len > send - s) {
                        len = send - s;
                    }
                    while (len > 0 && s < send) {
                        long alen = send - s;
                        long[] r = ArrayPacker.utf8_to_uv(str, s, alen);
                        long l = r[0];
                        alen = r[1];
                        s = (int)((long)s + alen);
                        --len;
                        ary.add(ObjectFactory.createInteger(l));
                    }
                    break;
                }
                case 'N': {
                    long c;
                    while (len-- > 0 && s < send) {
                        long tmp = 0L;
                        for (int j = 3; j >= 0; --j) {
                            c = str.charAt(s++);
                            tmp += c << j * 8;
                        }
                        ary.add(ObjectFactory.createInteger(tmp));
                    }
                    break;
                }
            }
        }
        return ary;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static StringBuilder pack(RubyArray array, String format2) {
        int len = 0;
        int items = array.size();
        int idx = 0;
        StringBuilder result = new StringBuilder();
        int p2 = 0;
        block33: while (true) {
            RubyValue from;
            block109: {
                int i;
                char type;
                if (p2 >= format2.length()) {
                    return result;
                }
                if ((type = format2.charAt(p2++)) == ' ') continue;
                if (format2.indexOf(p2) == 35) {
                    while (true) {
                        if (p2 >= format2.length() || format2.charAt(p2) == '\n') continue block33;
                        ++p2;
                    }
                }
                char t = p2 >= format2.length() ? (char)'\u0000' : format2.charAt(p2);
                if (t == '_' || t == '!') {
                    String natstr = "sSiIlL";
                    if ("sSiIlL".indexOf(type) < 0) {
                        throw new RubyException(RubyRuntime.ArgumentErrorClass, String.format("'%c' allowed only after types %s", Character.valueOf(type), "sSiIlL"));
                    }
                    ++p2;
                }
                if (t == '*') {
                    len = "@Xxu".indexOf(t) >= 0 ? 0 : items;
                    ++p2;
                } else if (Character.isDigit(t)) {
                    int end;
                    for (end = p2; end < format2.length() - 1 && Character.isDigit(format2.indexOf(end + 1)); ++end) {
                    }
                    len = Integer.parseInt(format2.substring(p2, end + 1), 10);
                } else {
                    len = 1;
                }
                switch (type) {
                    case 'A': 
                    case 'B': 
                    case 'H': 
                    case 'Z': 
                    case 'a': 
                    case 'b': 
                    case 'h': {
                        int plen;
                        String ptr;
                        if (items-- <= 0) {
                            throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                        }
                        if ((from = array.get(idx++)) == RubyConstant.QNIL) {
                            ptr = "";
                            plen = 0;
                        } else {
                            ptr = ((RubyString)from).toString();
                            plen = ptr.length();
                        }
                        if (format2.charAt(p2 - 1) == '*') {
                            len = plen;
                        }
                        switch (type) {
                            case 'A': 
                            case 'Z': 
                            case 'a': {
                                if (plen >= len) {
                                    result.append(ptr.substring(0, len));
                                    if (format2.charAt(p2 - 1) != '*' || type != 'Z') break;
                                    result.append('\u0000');
                                    continue block33;
                                }
                                result.append(ptr.substring(0, plen));
                                len -= plen;
                                while (len-- > 0) {
                                    result.append(' ');
                                }
                                break;
                            }
                            case 'b': {
                                char c;
                                int byte_ = 0;
                                int j = 0;
                                if (len > plen) {
                                    j = (len - plen + 1) / 2;
                                    len = plen;
                                }
                                int pos1 = 0;
                                int i2 = 0;
                                while (true) {
                                    if (i2++ >= len) continue block33;
                                    if ((ptr.charAt(pos1) & '\u0001') != 0) {
                                        byte_ |= 0x80;
                                    }
                                    if ((i2 & 7) != 0) {
                                        byte_ >>= 1;
                                    } else {
                                        c = (char)(byte_ & 0xFF);
                                        result.append(c);
                                        byte_ = 0;
                                    }
                                    if ((len & 7) != 0) {
                                        c = (char)((byte_ >>= 7 - (len & 7)) & 0xFF);
                                        result.append(c);
                                    }
                                    len = j;
                                    while (len-- > 0) {
                                        result.append('\u0000');
                                    }
                                    ++pos1;
                                }
                            }
                            case 'B': {
                                char c;
                                int byte_ = 0;
                                int j = 0;
                                if (len > plen) {
                                    j = (len - plen + 1) / 2;
                                    len = plen;
                                }
                                int pos1 = 0;
                                int i2 = 0;
                                while (i2++ < len) {
                                    byte_ |= ptr.charAt(pos1) & '\u0001';
                                    if ((i2 & 7) != 0) {
                                        byte_ <<= 1;
                                    } else {
                                        c = (char)(byte_ & 0xFF);
                                        result.append(c);
                                        byte_ = 0;
                                    }
                                    ++pos1;
                                }
                                if ((len & 7) != 0) {
                                    c = (char)((byte_ <<= 7 - (len & 7)) & 0xFF);
                                    result.append(c);
                                }
                                len = j;
                                while (true) {
                                    if (len-- <= 0) continue block33;
                                    result.append('\u0000');
                                }
                            }
                            case 'h': {
                                char c;
                                int byte_ = 0;
                                int j = 0;
                                if (len > plen) {
                                    j = (len - plen + 1) / 2;
                                    len = plen;
                                }
                                int pos1 = 0;
                                int i2 = 0;
                                while (i2++ < len) {
                                    byte_ = Character.isLetter(ptr.charAt(pos1)) ? (byte_ |= ((ptr.charAt(pos1) & 0xF) + 9 & 0xF) << 4) : (byte_ |= (ptr.charAt(pos1) & 0xF) << 4);
                                    if ((i2 & 1) != 0) {
                                        byte_ >>= 4;
                                    } else {
                                        c = (char)(byte_ & 0xFF);
                                        result.append(c);
                                        byte_ = 0;
                                    }
                                    ++pos1;
                                }
                                if ((len & 1) != 0) {
                                    c = (char)(byte_ & 0xFF);
                                    result.append(c);
                                }
                                len = j;
                                while (true) {
                                    if (len-- <= 0) continue block33;
                                    result.append('\u0000');
                                }
                            }
                            case 'H': {
                                char c;
                                int byte_ = 0;
                                int j = 0;
                                if (len > plen) {
                                    j = (len - plen + 1) / 2;
                                    len = plen;
                                }
                                int pos1 = 0;
                                int i2 = 0;
                                while (i2++ < len) {
                                    byte_ = Character.isLetter(ptr.charAt(pos1)) ? (byte_ |= (ptr.charAt(pos1) & 0xF) + 9 & 0xF) : (byte_ |= ptr.charAt(pos1) & 0xF);
                                    if ((i2 & 1) != 0) {
                                        byte_ <<= 4;
                                    } else {
                                        c = (char)(byte_ & 0xFF);
                                        result.append(c);
                                        byte_ = 0;
                                    }
                                    ++pos1;
                                }
                                if ((len & 1) != 0) {
                                    c = (char)(byte_ & 0xFF);
                                    result.append(c);
                                }
                                len = j;
                                while (len-- > 0) {
                                    result.append('\u0000');
                                }
                                break block26;
                            }
                        }
                        continue block33;
                    }
                    case 'C': 
                    case 'c': {
                        while (len-- > 0) {
                            if (items-- <= 0) {
                                throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                            }
                            from = array.get(idx++);
                            int i3 = from.toInt();
                            result.append((char)(i3 & 0xFF));
                        }
                        continue block33;
                    }
                    case 'S': 
                    case 's': {
                        int j;
                        while (len-- > 0) {
                            if (items-- <= 0) {
                                throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                            }
                            from = array.get(idx++);
                            int i4 = from.toInt();
                            for (j = 0; j < 2; ++j) {
                                result.append((char)(i4 >> j * 8 & 0xFF));
                            }
                        }
                        continue block33;
                    }
                    case 'I': 
                    case 'L': 
                    case 'i': 
                    case 'l': {
                        int j;
                        while (len-- > 0) {
                            if (items-- <= 0) {
                                throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                            }
                            from = array.get(idx++);
                            int i5 = from.toInt();
                            for (j = 0; j < 4; ++j) {
                                result.append((char)(i5 >> j * 8 & 0xFF));
                            }
                        }
                        continue block33;
                    }
                    case 'Q': 
                    case 'q': {
                        while (len-- > 0) {
                            if (items-- <= 0) {
                                throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                            }
                            from = array.get(idx++);
                            long l = RubyTypesUtil.convertToJavaLong(from);
                            for (i = 0; i < 8; ++i) {
                                result.append((char)(l >> i * 8 & 0xFFL));
                            }
                        }
                        continue block33;
                    }
                    case 'n': {
                        continue block33;
                    }
                    case 'N': {
                        while (len-- > 0) {
                            if (items-- <= 0) {
                                throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                            }
                            from = array.get(idx++);
                            long l = RubyTypesUtil.convertToJavaLong(from);
                            for (i = 3; i >= 0; --i) {
                                result.append((char)(l >> i * 8 & 0xFFL));
                            }
                        }
                        continue block33;
                    }
                    case 'v': {
                        continue block33;
                    }
                    case 'V': {
                        continue block33;
                    }
                    case 'F': 
                    case 'f': {
                        break;
                    }
                    case 'e': {
                        continue block33;
                    }
                    case 'E': {
                        continue block33;
                    }
                    case 'D': 
                    case 'd': {
                        while (len-- > 0) {
                            if (items-- <= 0) {
                                throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                            }
                            from = array.get(idx++);
                            double d = RubyTypesUtil.convertToJavaDouble(from);
                            long bits = Double.doubleToLongBits(d);
                            for (int i6 = 0; i6 < 8; ++i6) {
                                result.append((char)(bits >> i6 * 8 & 0xFFL));
                            }
                        }
                        continue block33;
                    }
                    case 'g': {
                        continue block33;
                    }
                    case 'G': {
                        continue block33;
                    }
                    case 'x': {
                        while (len-- > 0) {
                            result.append('\u0000');
                        }
                        continue block33;
                    }
                    case 'X': {
                        int plen = result.length();
                        if (plen < len) {
                            throw new RubyException(RubyRuntime.ArgumentErrorClass, "X outside of string");
                        }
                        result.delete(plen - len, plen);
                        continue block33;
                    }
                    case '@': {
                        if ((len -= result.length()) > 0) {
                            while (len-- > 0) {
                                result.append('\u0000');
                            }
                        }
                        if ((len = -len) <= 0) continue block33;
                        int plen = result.length();
                        if (plen < len) {
                            throw new RubyException(RubyRuntime.ArgumentErrorClass, "X outside of string");
                        }
                        result.delete(plen - len, plen);
                        continue block33;
                    }
                    case '%': {
                        throw new RubyException(RubyRuntime.ArgumentErrorClass, "% is not supported");
                    }
                    case 'U': {
                        break block109;
                    }
                    case 'm': 
                    case 'u': {
                        int todo;
                        int plen;
                        from = array.get(idx++);
                        String ptr = from.toString();
                        len = len <= 2 ? 45 : len / 3 * 3;
                        for (plen = ptr.length(); plen > 0; plen -= todo) {
                            todo = plen > len ? len : plen;
                            result.append(ArrayPacker.encodes(ptr, todo, type));
                            ptr = ptr + todo;
                        }
                        continue block33;
                    }
                    case 'M': {
                        String str = ((RubyString)array.get(idx++)).toString();
                        if (len <= 1) {
                            len = 72;
                        }
                        result.append(ArrayPacker.qpencode(str, len));
                        continue block33;
                    }
                    case 'P': 
                    case 'p': {
                        throw new RubyException("Not implemented");
                    }
                    case 'w': {
                        continue block33;
                    }
                    default: {
                        continue block33;
                    }
                }
                while (len-- > 0) {
                    float f;
                    if (items-- <= 0) {
                        throw new RubyException(RubyRuntime.RuntimeErrorClass, "too few for type " + type);
                    }
                    if ((from = array.get(idx++)) instanceof RubyFixnum) {
                        f = ((RubyFixnum)from).toInt() & 0xFFFFFFFF;
                    } else if (from instanceof RubyFloat) {
                        f = (long)((RubyFloat)from).toFloat() & 0xFFFFFFFFFFFFFFFFL;
                    } else {
                        if (!(from instanceof RubyBignum)) {
                            throw new RubyException(RubyRuntime.RuntimeErrorClass, String.format("can't convert %s into Integer", from.getRubyClass().getName()));
                        }
                        f = ((RubyBignum)from).getInternal().longValue() & 0xFFFFFFFFFFFFFFFFL;
                    }
                    int bits = Float.floatToIntBits(f);
                    for (i = 0; i < 4; ++i) {
                        result.append((char)(bits >> i * 8 & 0xFF));
                    }
                }
                continue;
            }
            while (len-- > 0) {
                long l;
                char[] buf = new char[8];
                if ((l = RubyTypesUtil.convertToJavaLong(from = array.get(idx++))) < 0L) {
                    throw new RubyException(RubyRuntime.RangeErrorClass, "pack(U): value (" + from + ") out of range");
                }
                int le = ArrayPacker.uv_to_utf8(buf, l);
                result.append(buf, 0, le);
            }
        }
    }
}

