/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFile;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyHash;
import com.xruby.runtime.builtin.RubyIO;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyMatchData;
import com.xruby.runtime.builtin.RubyMethodValue;
import com.xruby.runtime.builtin.RubyProc;
import com.xruby.runtime.builtin.RubyRange;
import com.xruby.runtime.builtin.RubyRegexp;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyThread;
import com.xruby.runtime.builtin.RubyTime;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import java.math.BigInteger;
import org.apache.oro.text.regex.MatchResult;

public class ObjectFactory {
    public static final RubyFixnum FIXNUM_NEGATIVE_ONE = new RubyFixnum(-1);
    public static final RubyFixnum FIXNUM0 = new RubyFixnum(0);
    public static final RubyFixnum FIXNUM1 = new RubyFixnum(1);
    public static final RubyFixnum FIXNUM2 = new RubyFixnum(2);
    public static final RubyFixnum FIXNUM3 = new RubyFixnum(3);
    public static final RubyFixnum FIXNUM4 = new RubyFixnum(4);
    public static final RubyFixnum FIXNUM5 = new RubyFixnum(5);
    public static final RubyFixnum FIXNUM6 = new RubyFixnum(6);
    public static final RubyFixnum FIXNUM7 = new RubyFixnum(7);
    public static final RubyFixnum FIXNUM8 = new RubyFixnum(8);
    public static final RubyFixnum FIXNUM9 = new RubyFixnum(9);
    public static final RubyFixnum FIXNUM10 = new RubyFixnum(10);
    private static final int CACHE_SIZE = 1024;

    public static RubyFixnum createFixnum(long value2) {
        if (value2 >= 0L && value2 < 1024L) {
            return FixnumCache.cache[(int)value2];
        }
        return new RubyFixnum(value2);
    }

    public static RubyFixnum createFixnum(int value2) {
        if (value2 >= 0 && value2 < 1024) {
            return FixnumCache.cache[value2];
        }
        return new RubyFixnum(value2);
    }

    public static RubyInteger createInteger(long value2) {
        return RubyBignum.bignorm(value2);
    }

    public static RubyString createString(String value2) {
        return new RubyString(value2);
    }

    public static RubyString createString() {
        return new RubyString("");
    }

    public static RubyString createString(StringBuilder value2) {
        return new RubyString(value2);
    }

    public static RubyString createString(RubyClass c, String s) {
        return new RubyString(c, s);
    }

    public static RubyRegexp createRegexp(String value2, String option) {
        return new RubyRegexp(value2, option);
    }

    public static RubyRegexp createRegexp() {
        return new RubyRegexp();
    }

    public static RubySymbol createSymbol(String value2) {
        RubyID id = RubyID.intern(value2);
        return id.toSymbol();
    }

    public static RubySymbol createSymbol(RubyID id) {
        return id.toSymbol();
    }

    public static RubyFloat createFloat(double value2) {
        return new RubyFloat(value2);
    }

    public static RubyArray createArray(int size2, RubyValue default_value) {
        return new RubyArray(size2, default_value);
    }

    public static RubyArray createArray(int size2, int rhs_size, boolean has_single_asterisk_or_lambda_call) {
        return new RubyArray(size2, rhs_size, has_single_asterisk_or_lambda_call);
    }

    public static RubyHash createHash() {
        return new RubyHash();
    }

    public static RubyIO createFile(String filename, String mode) {
        return new RubyFile(filename, mode);
    }

    public static RubyMethodValue createMethod(RubyValue r, String s, RubyMethod m) {
        return new RubyMethodValue(r, s, m);
    }

    public static RubyProc createProc(RubyBlock block) {
        return new RubyProc(block);
    }

    public static RubyTime createTime(long v) {
        return new RubyTime(v);
    }

    public static RubyTime createTime() {
        return new RubyTime();
    }

    public static RubyRange createRange() {
        return new RubyRange();
    }

    public static RubyRange createRange(RubyValue left, RubyValue right, boolean isExclusive) {
        RubyRange r = new RubyRange();
        r.setValue(left, right, isExclusive);
        return r;
    }

    public static RubyMatchData createMatchData(MatchResult m) {
        return new RubyMatchData(m);
    }

    public static RubyBignum createBignum(BigInteger value2) {
        return new RubyBignum(value2);
    }

    public static RubyBignum createBignum(String value2) {
        return new RubyBignum(new BigInteger(value2));
    }

    public static RubyValue createBoolean(boolean is_true) {
        return is_true ? RubyConstant.QTRUE : RubyConstant.QFALSE;
    }

    public static RubyThread createThread(RubyBlock block) {
        return new RubyThread(block);
    }

    private static class FixnumCache {
        static final RubyFixnum[] cache = new RubyFixnum[1024];

        private FixnumCache() {
        }

        static {
            for (int i = 0; i < 1024; ++i) {
                FixnumCache.cache[i] = new RubyFixnum(i);
            }
        }
    }
}

