/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ArrayPacker;
import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyRange;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@RubyLevelClass(name="Array", modules={"Enumerable"})
public class RubyArray
extends RubyBasic
implements Iterable<RubyValue> {
    private List<RubyValue> array_;
    private final int rhs_size_;
    private final boolean has_single_asterisk_or_lambda_call_;

    public RubyArray() {
        this(0);
    }

    public RubyArray(int size2) {
        this(size2, 0, false);
    }

    public RubyArray(RubyValue v) {
        this(1);
        this.array_.add(v);
    }

    public RubyArray(RubyValue value1, RubyValue value2) {
        this(2);
        this.array_.add(value1);
        this.array_.add(value2);
    }

    RubyArray(int size2, RubyValue default_value) {
        this(size2);
        for (int i = 0; i < size2; ++i) {
            this.array_.add(default_value);
        }
    }

    RubyArray(int size2, int rhs_size, boolean has_single_asterisk_or_lambda_call) {
        super(RubyRuntime.ArrayClass);
        this.array_ = new ArrayList<RubyValue>(size2);
        this.rhs_size_ = rhs_size;
        this.has_single_asterisk_or_lambda_call_ = has_single_asterisk_or_lambda_call;
    }

    private RubyArray(List<RubyValue> array) {
        super(RubyRuntime.ArrayClass);
        this.array_ = array;
        this.rhs_size_ = 0;
        this.has_single_asterisk_or_lambda_call_ = false;
    }

    @Override
    public RubyArray clone() {
        RubyArray v = (RubyArray)super.clone();
        v.array_ = new ArrayList<RubyValue>(this.array_);
        return v;
    }

    @Override
    public RubyArray toAry() {
        return this;
    }

    public boolean isSingleAsterisk() {
        return 0 == this.rhs_size_ && this.has_single_asterisk_or_lambda_call_;
    }

    public boolean isSingleRhs() {
        return this.rhs_size_ <= 1 && !this.has_single_asterisk_or_lambda_call_;
    }

    @RubyLevelMethod(name="[]")
    public static RubyValue create(RubyValue receiver) {
        RubyArray a = new RubyArray();
        a.setRubyClass((RubyClass)receiver);
        return a;
    }

    @RubyLevelMethod(name="[]")
    public static RubyValue create(RubyValue receiver, RubyArray args) {
        RubyArray a = args.copy();
        a.setRubyClass((RubyClass)receiver);
        return a;
    }

    public RubyArray add(RubyValue v) {
        this.array_.add(v);
        return this;
    }

    private RubyArray insert(int index2, RubyArray a) {
        for (int i = this.array_.size(); i < index2; ++i) {
            this.array_.add(RubyConstant.QNIL);
        }
        this.array_.addAll(index2, a.array_);
        return this;
    }

    public RubyArray insert(int index2, RubyValue v) {
        this.array_.add(index2, v);
        return this;
    }

    public int size() {
        return this.array_.size();
    }

    public RubyValue delete_at(int index2) {
        if (index2 >= this.size()) {
            return RubyConstant.QNIL;
        }
        if (index2 < 0) {
            index2 += this.size();
        }
        if (index2 < 0) {
            return RubyConstant.QNIL;
        }
        return this.array_.remove(index2);
    }

    private RubyArray delete_at(int begin, int length2) {
        int arraySize = this.array_.size();
        if (begin > arraySize) {
            return null;
        }
        if (length2 < 0) {
            return null;
        }
        if (begin < 0) {
            begin += arraySize;
        }
        if (begin + length2 > arraySize && (length2 = arraySize - begin) < 0) {
            length2 = 0;
        }
        while (length2 > 0) {
            this.array_.remove(begin);
            --length2;
        }
        return this;
    }

    private RubyArray plus(RubyArray v) {
        int size2 = this.array_.size() + v.size();
        RubyArray resultArray = new RubyArray(size2);
        resultArray.array_.addAll(this.array_);
        resultArray.array_.addAll(v.array_);
        return resultArray;
    }

    private RubyArray minus(RubyArray other) {
        RubyArray a = this.copy();
        for (RubyValue v : other) {
            a.remove(v);
        }
        return a;
    }

    private boolean remove(RubyValue v) {
        boolean r = false;
        while (this.array_.remove(v)) {
            r = true;
        }
        return r;
    }

    public RubyArray times(int times) {
        if (times < 0) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "negative argument");
        }
        int size2 = this.array_.size() * times;
        RubyArray resultArray = new RubyArray(size2);
        for (int i = 0; i < times; ++i) {
            resultArray.array_.addAll(this.array_);
        }
        return resultArray;
    }

    public RubyArray expand(RubyValue v) {
        if (v instanceof RubyArray) {
            this.array_.addAll(((RubyArray)v).array_);
        } else {
            this.array_.add(v);
        }
        return this;
    }

    public RubyValue collect(int index2) {
        assert (index2 >= 0);
        int size2 = this.array_.size() - index2;
        if (size2 < 0) {
            return new RubyArray();
        }
        RubyArray a = new RubyArray(size2);
        for (int i = index2; i < this.array_.size(); ++i) {
            a.add(this.array_.get(i));
        }
        return a;
    }

    @Override
    public Iterator<RubyValue> iterator() {
        return this.array_.iterator();
    }

    private int getRealIndex(int i) {
        int index2 = i;
        if (index2 < 0) {
            index2 = this.array_.size() + index2;
        }
        if (index2 < 0) {
            throw new RubyException(RubyRuntime.IndexErrorClass, "index " + i + " out of array");
        }
        return index2;
    }

    public RubyValue set(int start2, RubyValue value2) {
        int index2 = this.getRealIndex(start2);
        if (index2 < this.array_.size()) {
            this.array_.set(index2, value2);
        } else {
            for (int i = this.array_.size(); i < index2; ++i) {
                this.array_.add(RubyConstant.QNIL);
            }
            this.array_.add(value2);
        }
        return value2;
    }

    public RubyValue replace(int start2, int length2, RubyValue value2) {
        int index2 = this.getRealIndex(start2);
        if (value2 == RubyConstant.QNIL) {
            for (int i = 0; i < length2; ++i) {
                this.array_.remove(index2);
            }
            return value2;
        }
        if (length2 < 0) {
            throw new RubyException(RubyRuntime.IndexErrorClass, "negative length (" + length2 + ")");
        }
        if (0 == length2) {
            if (value2 instanceof RubyArray) {
                this.array_.addAll(index2, ((RubyArray)value2).array_);
            } else {
                this.array_.add(index2, value2);
            }
        } else {
            for (int i = 0; i < length2 - 1; ++i) {
                this.array_.remove(index2);
            }
            if (value2 instanceof RubyArray) {
                this.array_.remove(index2);
                this.array_.addAll(index2, ((RubyArray)value2).array_);
            } else {
                this.array_.set(index2, value2);
            }
        }
        return value2;
    }

    public RubyValue get(int index2) {
        if (index2 < 0) {
            index2 = this.array_.size() + index2;
        }
        if (index2 < 0 || index2 >= this.size()) {
            return RubyConstant.QNIL;
        }
        return this.array_.get(index2);
    }

    public RubyArray copy() {
        RubyArray resultArray = new RubyArray(this.array_.size());
        for (RubyValue v : this.array_) {
            resultArray.add(v);
        }
        return resultArray;
    }

    private RubyValue compare(RubyArray other_array) {
        int length2 = this.size() <= other_array.size() ? this.size() : other_array.size();
        for (int i = 0; i < length2; ++i) {
            RubyValue v = RubyAPI.callPublicOneArgMethod(this.get(i), other_array.get(i), null, RubyID.unequalID);
            if (RubyAPI.testEqual(v, ObjectFactory.FIXNUM0)) continue;
            return v;
        }
        if (this.size() == other_array.size()) {
            return ObjectFactory.FIXNUM0;
        }
        if (this.size() > other_array.size()) {
            return ObjectFactory.FIXNUM1;
        }
        return ObjectFactory.FIXNUM_NEGATIVE_ONE;
    }

    public RubyArray subarray(int begin, int length2) {
        int arraySize = this.array_.size();
        if (begin > arraySize) {
            return null;
        }
        if (length2 < 0) {
            return null;
        }
        if (begin < 0) {
            begin += arraySize;
        }
        if (begin + length2 > arraySize && (length2 = arraySize - begin) < 0) {
            length2 = 0;
        }
        if (length2 == 0) {
            return new RubyArray(0);
        }
        return new RubyArray(this.array_.subList(begin, begin + length2));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RubyArray) {
            RubyArray that = (RubyArray)o;
            int size2 = this.array_.size();
            if (size2 != that.size()) {
                return false;
            }
            for (int i = 0; i < size2; ++i) {
                if (this.get(i).equals(that.get(i))) continue;
                return false;
            }
            return true;
        }
        if (o instanceof RubyValue) {
            RubyValue v = (RubyValue)o;
            if (!v.respondTo(RubyID.toAryID)) {
                return false;
            }
            return v.equals(this);
        }
        return false;
    }

    private void sort() {
        Collections.sort(this.array_, new Comparator<RubyValue>(){

            @Override
            public int compare(RubyValue arg0, RubyValue arg1) {
                RubyValue v = RubyAPI.callPublicOneArgMethod(arg0, arg1, null, RubyID.unequalID);
                return ((RubyFixnum)v).toInt();
            }
        });
    }

    private void sort_with_block(final RubyBlock block) {
        final RubyArray self = this;
        Collections.sort(this.array_, new Comparator<RubyValue>(){

            @Override
            public int compare(RubyValue arg0, RubyValue arg1) {
                RubyValue v = block.invoke(self, arg0, arg1);
                return ((RubyFixnum)v).toInt();
            }
        });
    }

    private int getRealIndex(int size2, int i) {
        int index2 = i;
        if (index2 < 0) {
            index2 = size2 + index2;
        }
        if (index2 < 0) {
            throw new RubyException(RubyRuntime.IndexErrorClass, "index " + i + " out of array");
        }
        return index2;
    }

    private boolean recursiveAdd(RubyArray receiver, RubyArray array) {
        boolean modified = false;
        for (int i = 0; i < array.size(); ++i) {
            RubyValue val = array.get(i);
            if (val instanceof RubyArray) {
                modified = true;
                this.recursiveAdd(receiver, (RubyArray)val);
                continue;
            }
            receiver.add(val);
        }
        return modified;
    }

    @RubyLevelMethod(name="new", singleton=true)
    public static RubyValue newArray(RubyValue receiver, RubyBlock block) {
        RubyArray a = new RubyArray();
        a.setRubyClass((RubyClass)receiver);
        return a;
    }

    @RubyLevelMethod(name="new", singleton=true)
    public static RubyValue newArray(RubyValue receiver, RubyArray args, RubyBlock block) {
        RubyArray a;
        if (null == args) {
            a = new RubyArray();
        } else if (null == block) {
            if (args.get(0) instanceof RubyArray) {
                a = (RubyArray)args.get(0).clone();
            } else {
                RubyFixnum size2 = (RubyFixnum)args.get(0);
                RubyValue default_value = args.get(1);
                a = ObjectFactory.createArray(size2.toInt(), default_value);
            }
        } else {
            RubyFixnum size3 = (RubyFixnum)args.get(0);
            a = new RubyArray();
            int i = 0;
            while ((double)i < size3.toFloat()) {
                RubyValue return_value = block.invoke(receiver, ObjectFactory.createFixnum(i));
                a.add(return_value);
                ++i;
            }
        }
        a.setRubyClass((RubyClass)receiver);
        return a;
    }

    @RubyLevelMethod(name="empty?")
    public RubyValue empty_p() {
        return ObjectFactory.createBoolean(this.array_.isEmpty());
    }

    @RubyLevelMethod(name="to_s")
    public RubyValue to_s() {
        RubyString r = ObjectFactory.createString();
        for (RubyValue v : this.array_) {
            r.appendString(v);
        }
        return r;
    }

    @RubyLevelMethod(name="length")
    public RubyFixnum length() {
        return ObjectFactory.createFixnum(this.array_.size());
    }

    @RubyLevelMethod(name="clear")
    public RubyArray clear() {
        this.array_.clear();
        return this;
    }

    @RubyLevelMethod(name="[]", alias={"slice"})
    public RubyValue aref(RubyValue arg) {
        if (arg instanceof RubyFixnum) {
            return this.get(arg.toInt());
        }
        if (arg instanceof RubySymbol) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "Symbol as array index");
        }
        if (arg instanceof RubyRange) {
            RubyArray resultValue;
            RubyRange range = (RubyRange)arg;
            int begin = range.getLeft().toInt();
            int end = range.getRight().toInt();
            if (begin < 0) {
                begin = this.size() + begin;
            }
            if (end < 0) {
                end = this.size() + end;
            }
            if (!range.isExcludeEnd()) {
                ++end;
            }
            return null == (resultValue = this.subarray(begin, end - begin)) ? RubyConstant.QNIL : resultValue;
        }
        return this.get(arg.toInt());
    }

    @RubyLevelMethod(name="[]", alias={"slice"})
    public RubyValue aref(RubyValue begin, RubyValue length2) {
        if (begin instanceof RubySymbol) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "Symbol as array index");
        }
        RubyArray resultValue = this.subarray(begin.toInt(), length2.toInt());
        return null == resultValue ? RubyConstant.QNIL : resultValue;
    }

    @RubyLevelMethod(name="insert")
    public RubyArray insert(RubyArray ary) {
        int argc = ary.size();
        if (argc == 1) {
            return this;
        }
        if (argc < 1) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (at least 1)");
        }
        int pos2 = ary.get(0).toInt();
        if (pos2 < 0) {
            pos2 += this.array_.size() + 1;
        }
        return this.insert(pos2, ary.subarray(1, ary.size() - 1));
    }

    @RubyLevelMethod(name="first")
    public RubyValue first() {
        if (this.array_.size() == 0) {
            return RubyConstant.QNIL;
        }
        return this.array_.get(0);
    }

    @RubyLevelMethod(name="first")
    public RubyValue first(RubyValue v) {
        int size2;
        int n = v.toInt();
        if (n > (size2 = this.array_.size())) {
            n = size2;
        }
        return new RubyArray(this.array_.subList(0, n));
    }

    @RubyLevelMethod(name="last")
    public RubyValue last() {
        if (this.array_.size() == 0) {
            return RubyConstant.QNIL;
        }
        return this.array_.get(this.size() - 1);
    }

    @RubyLevelMethod(name="last")
    public RubyValue last(RubyValue v) {
        int size2;
        int n = v.toInt();
        if (n > (size2 = this.array_.size())) {
            n = size2;
        }
        return new RubyArray(this.array_.subList(size2 - n, size2));
    }

    @RubyLevelMethod(name="at")
    public RubyValue at(RubyValue value2) {
        return this.get(value2.toInt());
    }

    @RubyLevelMethod(name="<<")
    public RubyArray push(RubyValue v) {
        this.array_.add(v);
        return this;
    }

    @RubyLevelMethod(name="push")
    public RubyArray multiPush() {
        return this;
    }

    @RubyLevelMethod(name="push")
    public RubyArray multiPush(RubyValue v) {
        this.array_.add(v);
        return this;
    }

    @RubyLevelMethod(name="push")
    public RubyArray multiPush(RubyArray args) {
        for (RubyValue v : args) {
            this.array_.add(v);
        }
        return this;
    }

    @RubyLevelMethod(name="pop")
    public RubyValue pop() {
        int size2 = this.array_.size();
        if (0 == size2) {
            return RubyConstant.QNIL;
        }
        return this.array_.remove(size2 - 1);
    }

    @RubyLevelMethod(name="delete_at")
    public RubyValue deleteAt(RubyValue v) {
        return this.delete_at(v.toInt());
    }

    @RubyLevelMethod(name="shift")
    public RubyValue shift() {
        return this.array_.size() != 0 ? this.array_.remove(0) : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="delete_if")
    public RubyValue delete_if(RubyBlock block) {
        int i = 0;
        while (i < this.array_.size()) {
            RubyValue r = block.invoke((RubyValue)this, this.array_.get(i));
            if (r.isTrue()) {
                this.array_.remove(i);
                continue;
            }
            ++i;
        }
        return this;
    }

    @RubyLevelMethod(name="delete")
    public RubyValue delete(RubyValue item, RubyBlock block) {
        boolean found = false;
        while (this.array_.remove(item)) {
            found = true;
        }
        if (block != null && !found) {
            return block.invoke(item);
        }
        return found ? item : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="<=>")
    public RubyValue compare(RubyValue v) {
        return this.compare(v.toAry());
    }

    @RubyLevelMethod(name="==", alias={"eql?"})
    public RubyValue opEquals(RubyValue v) {
        return ObjectFactory.createBoolean(this.equals(v));
    }

    @RubyLevelMethod(name="concat")
    public RubyArray concat(RubyValue v) {
        RubyArray ary = v.toAry();
        this.array_.addAll(ary.array_);
        return this;
    }

    @RubyLevelMethod(name="+")
    public RubyArray plus(RubyValue v) {
        return this.plus(v.toAry());
    }

    @RubyLevelMethod(name="-")
    public RubyArray minus(RubyValue v) {
        return this.minus(v.toAry());
    }

    @RubyLevelMethod(name="include?")
    public RubyValue include(RubyValue v) {
        for (RubyValue value2 : this.array_) {
            if (!RubyAPI.testEqual(value2, v)) continue;
            return RubyConstant.QTRUE;
        }
        return RubyConstant.QFALSE;
    }

    @RubyLevelMethod(name="each")
    public RubyValue each(RubyBlock block) {
        for (RubyValue item : this.array_) {
            RubyValue v = block.invoke((RubyValue)this, item);
            if (!block.breakedOrReturned()) continue;
            return v;
        }
        return this;
    }

    @RubyLevelMethod(name="each_index")
    public RubyValue each_index(RubyBlock block) {
        for (int i = 0; i < this.size(); ++i) {
            RubyValue v = block.invoke((RubyValue)this, new RubyFixnum(i));
            if (!block.breakedOrReturned()) continue;
            return v;
        }
        return this;
    }

    @RubyLevelMethod(name="reverse_each")
    public RubyValue reverse_each(RubyBlock block) {
        ListIterator<RubyValue> ite = this.array_.listIterator(this.array_.size());
        while (ite.hasPrevious()) {
            RubyValue v = block.invoke((RubyValue)this, ite.previous());
            if (!block.breakedOrReturned()) continue;
            return v;
        }
        return this;
    }

    @RubyLevelMethod(name="unshift")
    public RubyArray unshift(RubyValue value2) {
        this.array_.add(0, value2);
        return this;
    }

    @RubyLevelMethod(name="unshift")
    public RubyArray unshift(RubyArray value2) {
        this.array_.addAll(0, value2.array_);
        return this;
    }

    public int hashCode() {
        int hash2 = 0;
        for (RubyValue v : this.array_) {
            hash2 += v.hashCode();
        }
        return hash2;
    }

    @RubyLevelMethod(name="hash")
    public RubyFixnum hash() {
        return ObjectFactory.createFixnum(this.hashCode());
    }

    @RubyLevelMethod(name="&")
    public RubyArray and(RubyValue value2) {
        RubyArray other = value2.toAry();
        RubyArray a = new RubyArray();
        for (RubyValue v : this.array_) {
            if (other.include(v) != RubyConstant.QTRUE || a.include(v) != RubyConstant.QFALSE) continue;
            a.add(v);
        }
        return a;
    }

    @RubyLevelMethod(name="|")
    public RubyArray or(RubyValue value2) {
        RubyArray other = value2.toAry();
        RubyArray a = new RubyArray();
        for (RubyValue v : this.array_) {
            if (a.include(v) != RubyConstant.QFALSE) continue;
            a.add(v);
        }
        for (RubyValue v : other) {
            if (a.include(v) != RubyConstant.QFALSE) continue;
            a.add(v);
        }
        return a;
    }

    @RubyLevelMethod(name="compact")
    public RubyValue compact() {
        return this.copy().compact_danger();
    }

    @RubyLevelMethod(name="compact!")
    public RubyValue compact_danger() {
        if (this.remove(RubyConstant.QNIL)) {
            return this;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="uniq")
    public RubyValue uniq() {
        return this.copy().uniq_danger();
    }

    @RubyLevelMethod(name="uniq!")
    public RubyValue uniq_danger() {
        boolean b = false;
        for (int i = 0; i < this.array_.size(); ++i) {
            int j = i + 1;
            while (j < this.array_.size()) {
                if (RubyAPI.testEqual(this.array_.get(i), this.array_.get(j))) {
                    this.array_.remove(j);
                    b = true;
                    continue;
                }
                ++j;
            }
        }
        return b ? this : RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="reverse")
    public RubyArray reverse() {
        RubyArray array = this.copy();
        Collections.reverse(array.array_);
        return array;
    }

    @RubyLevelMethod(name="reverse!")
    public RubyArray reverseBang() {
        Collections.reverse(this.array_);
        return this;
    }

    @RubyLevelMethod(name="index")
    public RubyValue index(RubyValue arg) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).equals(arg)) continue;
            return ObjectFactory.createFixnum(i);
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="rindex")
    public RubyValue rindex(RubyValue arg) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!this.get(i).equals(arg)) continue;
            return ObjectFactory.createFixnum(i);
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="replace")
    public RubyValue replace(RubyValue arg) {
        RubyArray anotherArray = (RubyArray)arg;
        if (this == anotherArray) {
            return this;
        }
        this.clear();
        for (int i = 0; i < anotherArray.size(); ++i) {
            this.add(anotherArray.get(i));
        }
        return this;
    }

    @RubyLevelMethod(name="indexes", alias={"indices"})
    public RubyValue indexes(RubyArray args) {
        RubyArray a = new RubyArray(args.size());
        for (int i = 0; i < this.size(); ++i) {
            RubyFixnum n = (RubyFixnum)args.get(i);
            a.add(this.get(n.toInt()));
        }
        return a;
    }

    @RubyLevelMethod(name="nitems")
    public RubyValue nitems() {
        int n = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == RubyConstant.QNIL) continue;
            ++n;
        }
        return ObjectFactory.createFixnum(n);
    }

    @RubyLevelMethod(name="flatten")
    public RubyValue flatten() {
        RubyArray a = new RubyArray();
        this.recursiveAdd(a, this);
        return a;
    }

    @RubyLevelMethod(name="flatten!")
    public RubyValue flatten_danger() {
        RubyArray copy = this.copy();
        this.clear();
        boolean hasModified = this.recursiveAdd(this, copy);
        if (hasModified) {
            return this;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="collect!")
    public RubyValue collect_danger(RubyBlock block) {
        RubyArray a = (RubyArray)RubyAPI.callPublicNoArgMethod(this, block, RubyID.intern("collect"));
        this.clear();
        for (int i = 0; i < a.size(); ++i) {
            this.add(a.get(i));
        }
        return this;
    }

    @RubyLevelMethod(name="assoc")
    public RubyValue assoc(RubyValue arg) {
        RubyValue val = null;
        for (int i = 0; i < this.size(); ++i) {
            RubyValue tmp;
            val = this.get(i);
            if (!(val instanceof RubyArray) || ((RubyArray)val).size() <= 0 || !arg.equals(tmp = ((RubyArray)val).get(0))) continue;
            return val;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="rassoc")
    public RubyValue rassoc(RubyValue arg) {
        int size2 = this.array_.size();
        for (int i = 0; i < size2; ++i) {
            RubyValue tmp;
            RubyValue val = this.get(i);
            if (!(val instanceof RubyArray) || ((RubyArray)val).size() <= 1 || !arg.equals(tmp = ((RubyArray)val).get(1))) continue;
            return val;
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="*")
    public RubyValue run(RubyValue arg, RubyBlock block) {
        if (arg instanceof RubyFixnum) {
            RubyFixnum times = (RubyFixnum)arg;
            return this.times(times.toInt());
        }
        if (arg instanceof RubyString) {
            return RubyAPI.callOneArgMethod(this, arg, block, RubyID.joinID);
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "no implicit conversion from " + arg + " to integer");
    }

    @RubyLevelMethod(name="sort")
    public RubyValue sort(RubyBlock block) {
        return this.copy().sort_danger(block);
    }

    @RubyLevelMethod(name="sort!")
    public RubyValue sort_danger(RubyBlock block) {
        if (null == block) {
            this.sort();
        } else {
            this.sort_with_block(block);
        }
        return this;
    }

    @RubyLevelMethod(name="[]=")
    public RubyValue aset() {
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (0 for 2)");
    }

    @RubyLevelMethod(name="[]=")
    public RubyValue aset(RubyValue arg) {
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (1 for 2)");
    }

    @RubyLevelMethod(name="[]=")
    public RubyValue aset(RubyValue arg0, RubyValue arg1) {
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            int left = range.getLeft().toInt();
            int right = range.getRight().toInt();
            int l_index = this.getRealIndex(this.size(), left);
            int r_index = this.getRealIndex(this.size(), right);
            int length2 = r_index - l_index + 1;
            return this.replace(l_index, length2, arg1);
        }
        return this.set(arg0.toInt(), arg1);
    }

    @RubyLevelMethod(name="[]=")
    public RubyValue aset(RubyArray args) {
        if (3 == args.size()) {
            int index2 = args.get(0).toInt();
            int length2 = args.get(1).toInt();
            return this.replace(index2, length2, args.get(2));
        }
        throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (" + args.size() + " for 2)");
    }

    @RubyLevelMethod(name="slice!")
    public RubyValue slice_danger(RubyArray args) {
        if (1 == args.size()) {
            RubyValue argValue = args.get(0);
            if (argValue instanceof RubyFixnum) {
                RubyFixnum index2 = (RubyFixnum)argValue;
                return this.delete_at(index2.toInt());
            }
            if (args.get(0) instanceof RubyRange) {
                RubyArray resultValue;
                int begin = ((RubyFixnum)((RubyRange)args.get(0)).getLeft()).toInt();
                int end = ((RubyFixnum)((RubyRange)args.get(0)).getRight()).toInt();
                if (begin < 0) {
                    begin = this.size() + begin;
                }
                if (end < 0) {
                    end = this.size() + end;
                }
                if (!((RubyRange)args.get(0)).isExcludeEnd()) {
                    ++end;
                }
                return null == (resultValue = this.delete_at(begin, end - begin)) ? RubyConstant.QNIL : resultValue;
            }
        } else if (2 == args.size()) {
            RubyValue arg0Value = args.get(0);
            RubyValue arg1Value = args.get(1);
            if (arg0Value instanceof RubyFixnum && arg1Value instanceof RubyFixnum) {
                int length2;
                int begin = ((RubyFixnum)arg0Value).toInt();
                RubyArray resultValue = this.delete_at(begin, length2 = ((RubyFixnum)arg1Value).toInt());
                return null == resultValue ? RubyConstant.QNIL : resultValue;
            }
        }
        throw new RubyException("not implemented");
    }

    @RubyLevelMethod(name="pack")
    public RubyValue pack(RubyValue arg) {
        String format2 = ((RubyString)arg).toString();
        return ObjectFactory.createString(ArrayPacker.pack(this, format2));
    }
}

