/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.math.BigInteger;

@RubyLevelClass(name="Fixnum", superclass="Integer")
public class RubyFixnum
extends RubyInteger {
    private final long value_;
    private static int BIT_SIZE = 32;

    RubyFixnum(int i) {
        this.value_ = i;
    }

    RubyFixnum(long i) {
        this.value_ = i;
    }

    @Override
    public void setRubyClass(RubyClass klass) {
        throw new RubyException(RubyRuntime.TypeErrorClass, this.getRubyClass().getName() + " can't be set class");
    }

    @Override
    public RubyClass getSingletonClass() {
        throw new RubyException(RubyRuntime.TypeErrorClass, this.getRubyClass().getName() + " can't define singleton");
    }

    @Override
    public RubyValue clone() {
        RubyFixnum cl = new RubyFixnum(this.value_);
        cl.doClone(this);
        return cl;
    }

    @Override
    public int toInt() {
        return (int)this.value_;
    }

    @Override
    public long toLong() {
        return this.value_;
    }

    @Override
    public double toFloat() {
        return this.value_;
    }

    @Override
    public RubyFloat toRubyFloat() {
        return ObjectFactory.createFloat(this.value_);
    }

    public RubyFixnum convertToInteger() {
        return this;
    }

    public int hashCode() {
        return (int)this.value_;
    }

    @Override
    public RubyClass getRubyClass() {
        return RubyRuntime.FixnumClass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RubyFixnum) {
            return this.value_ == ((RubyFixnum)o).value_;
        }
        return super.equals(o);
    }

    @Override
    public String toString() {
        return Long.toString(this.value_);
    }

    public String toString(int radix) {
        return Long.toString(this.value_, radix);
    }

    @Override
    @RubyLevelMethod(name="-@")
    public RubyValue uminus() {
        return ObjectFactory.createFixnum(-this.value_);
    }

    @RubyLevelMethod(name="+")
    public RubyValue opPlus(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.value_ + ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat((double)this.value_ + v.toFloat());
        }
        if (v instanceof RubyBignum) {
            BigInteger bigValue1 = BigInteger.valueOf(this.value_);
            BigInteger bigValue2 = ((RubyBignum)v).getInternal();
            return RubyBignum.bignorm(bigValue1.add(bigValue2));
        }
        return this.coerceBin(RubyID.plusID, v);
    }

    @RubyLevelMethod(name="-")
    public RubyValue opMinus(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.value_ - ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat((double)this.value_ - v.toFloat());
        }
        if (v instanceof RubyBignum) {
            BigInteger bigValue1 = BigInteger.valueOf(this.value_);
            BigInteger bigValue2 = ((RubyBignum)v).getInternal();
            return RubyBignum.bignorm(bigValue1.subtract(bigValue2));
        }
        return this.coerceBin(RubyID.subID, v);
    }

    @RubyLevelMethod(name="*")
    public RubyValue opMul(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.value_ * ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat((double)this.value_ * v.toFloat());
        }
        if (v instanceof RubyBignum) {
            BigInteger bigValue1 = BigInteger.valueOf(this.value_);
            BigInteger bigValue2 = ((RubyBignum)v).getInternal();
            return RubyBignum.bignorm(bigValue1.multiply(bigValue2));
        }
        return this.coerceBin(RubyID.mulID, v);
    }

    @RubyLevelMethod(name="/")
    public RubyValue opDiv(RubyValue v) {
        if (v instanceof RubyFixnum) {
            long div;
            long mod2;
            long intValue1 = this.value_;
            long intValue2 = ((RubyFixnum)v).value_;
            if (intValue2 == 0L) {
                this.zeroDiv();
            }
            if ((mod2 = intValue1 - (div = intValue1 / intValue2) * intValue2) != 0L && div < 0L) {
                --div;
            }
            return RubyBignum.bignorm(div);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat((double)this.value_ / v.toFloat());
        }
        if (v instanceof RubyBignum) {
            BigInteger bigValue1 = BigInteger.valueOf(this.value_);
            BigInteger bigValue2 = ((RubyBignum)v).getInternal();
            return RubyBignum.bignorm(bigValue1.divide(bigValue2));
        }
        return this.coerceBin(RubyID.divID, v);
    }

    @RubyLevelMethod(name="%")
    public RubyValue mod(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return RubyBignum.bignorm(this.value_ % ((RubyFixnum)v).value_);
        }
        return this.coerceBin(RubyID.modID, v);
    }

    @RubyLevelMethod(name="**")
    public RubyValue pow(RubyValue v) {
        if (v instanceof RubyFixnum) {
            long p2 = ((RubyFixnum)v).value_;
            if (p2 == 0L) {
                return ObjectFactory.FIXNUM1;
            }
            if (p2 == 1L) {
                return this;
            }
            if (p2 > 0L) {
                BigInteger b = BigInteger.valueOf(this.value_);
                return RubyBignum.bignorm(b.pow((int)p2));
            }
            return ObjectFactory.createFloat(Math.pow(this.value_, p2));
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createFloat(Math.pow(this.value_, v.toFloat()));
        }
        return this.coerceBin(RubyID.powID, v);
    }

    @RubyLevelMethod(name="~")
    public RubyValue opRev() {
        return RubyBignum.bignorm(this.value_ ^ 0xFFFFFFFFFFFFFFFFL);
    }

    @RubyLevelMethod(name="to_f")
    public RubyFloat convertToFloat() {
        return ObjectFactory.createFloat(this.value_);
    }

    @RubyLevelMethod(name="<<")
    public RubyValue lshift(RubyValue arg) {
        return this.lshift(arg.toInt());
    }

    @RubyLevelMethod(name=">>")
    public RubyValue rshift(RubyValue arg) {
        return this.rshift(arg.toInt());
    }

    private RubyValue lshift(int i) {
        if (i == 0) {
            return this;
        }
        if (i < 0) {
            return this.rshift(-i);
        }
        BigInteger bigValue1 = BigInteger.valueOf(this.value_);
        return RubyBignum.bignorm(bigValue1.shiftLeft(i));
    }

    private RubyValue rshift(int i) {
        if (i == 0) {
            return this;
        }
        if (i < 0) {
            return this.lshift(-i);
        }
        if (i >= BIT_SIZE - 1) {
            if (this.value_ < 0L) {
                return ObjectFactory.FIXNUM_NEGATIVE_ONE;
            }
            return ObjectFactory.FIXNUM0;
        }
        return ObjectFactory.createFixnum(this.value_ >> i);
    }

    @RubyLevelMethod(name="==")
    public RubyValue opEqual(RubyValue arg) {
        if (arg == this) {
            return RubyConstant.QTRUE;
        }
        if (arg instanceof RubyFixnum) {
            return ObjectFactory.createBoolean(this.value_ == ((RubyFixnum)arg).value_);
        }
        return RubyAPI.callOneArgMethod(arg, this, null, RubyID.equalID);
    }

    @RubyLevelMethod(name="<=")
    public RubyValue opLe(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createBoolean(this.value_ <= ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createBoolean((double)this.value_ <= v.toFloat());
        }
        return this.coerceRelop(RubyID.leID, v);
    }

    @RubyLevelMethod(name="<")
    public RubyValue opLt(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createBoolean(this.value_ < ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createBoolean((double)this.value_ < v.toFloat());
        }
        return this.coerceRelop(RubyID.ltID, v);
    }

    @RubyLevelMethod(name=">=")
    public RubyValue opGe(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createBoolean(this.value_ >= ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createBoolean((double)this.value_ >= v.toFloat());
        }
        return this.coerceRelop(RubyID.geID, v);
    }

    @RubyLevelMethod(name=">")
    public RubyValue opGt(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createBoolean(this.value_ > ((RubyFixnum)v).value_);
        }
        if (v instanceof RubyFloat) {
            return ObjectFactory.createBoolean((double)this.value_ > v.toFloat());
        }
        return this.coerceRelop(RubyID.gtID, v);
    }

    @RubyLevelMethod(name="<=>")
    public RubyValue opCmp(RubyValue v) {
        if (this == v) {
            return ObjectFactory.FIXNUM0;
        }
        if (v instanceof RubyFixnum) {
            long a = ((RubyFixnum)v).value_;
            if (this.value_ > a) {
                return ObjectFactory.FIXNUM1;
            }
            if (this.value_ == a) {
                return ObjectFactory.FIXNUM0;
            }
            return ObjectFactory.FIXNUM_NEGATIVE_ONE;
        }
        return this.coerceCmp(RubyID.unequalID, v);
    }

    @RubyLevelMethod(name="|")
    public RubyValue opOr(RubyValue v) {
        if (v instanceof RubyBignum) {
            return ((RubyBignum)v).op_bor(this);
        }
        return RubyBignum.bignorm(this.value_ | v.toLong());
    }

    @RubyLevelMethod(name="&")
    public RubyValue opAnd(RubyValue v) {
        if (v instanceof RubyBignum) {
            return ((RubyBignum)v).op_band(this);
        }
        return RubyBignum.bignorm(this.value_ & v.toLong());
    }

    @RubyLevelMethod(name="^")
    public RubyValue opXor(RubyValue v) {
        if (v instanceof RubyBignum) {
            return ((RubyBignum)v).op_bxor(this);
        }
        return RubyBignum.bignorm(this.value_ ^ v.toLong());
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        return ObjectFactory.createString(this.toString());
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s(RubyValue v) {
        int radix = v.toInt();
        if (radix < 2 || radix > 36) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "illegal radix " + radix);
        }
        return ObjectFactory.createString(this.toString(radix));
    }

    @RubyLevelMethod(name="quo")
    public RubyFloat quo(RubyValue v) {
        if (v instanceof RubyFixnum) {
            return ObjectFactory.createFloat(this.value_ / ((RubyFixnum)v).value_);
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, v.getRubyClass().getName() + " can't be coersed into Fixnum");
    }

    @RubyLevelMethod(name="[]")
    public RubyFixnum aref(RubyValue idx) {
        if (idx instanceof RubyBignum && !((idx = RubyBignum.bignorm(idx)) instanceof RubyFixnum)) {
            if (this.value_ > 0L || ((RubyBignum)idx).getInternal().compareTo(BigInteger.ZERO) > 0) {
                return ObjectFactory.FIXNUM0;
            }
            return ObjectFactory.FIXNUM1;
        }
        int i = idx.toInt();
        if (i < 0 || i > BIT_SIZE) {
            return ObjectFactory.FIXNUM0;
        }
        if ((this.value_ & 1L << i) > 0L) {
            return ObjectFactory.FIXNUM1;
        }
        return ObjectFactory.FIXNUM0;
    }

    @Override
    protected RubyValue doStep(RubyValue toArg, RubyValue stepArg, RubyBlock block) {
        if (toArg instanceof RubyFixnum && stepArg instanceof RubyFixnum) {
            long i;
            long end = ((RubyFixnum)toArg).value_;
            long diff = ((RubyFixnum)stepArg).value_;
            if (diff > 0L) {
                for (i = this.value_; i <= end; i += diff) {
                    RubyValue v = block.invoke((RubyValue)this, ObjectFactory.createFixnum(i));
                    if (!block.breakedOrReturned()) continue;
                    return v;
                }
            } else {
                while (i >= end) {
                    RubyValue v = block.invoke((RubyValue)this, ObjectFactory.createFixnum(i));
                    if (block.breakedOrReturned()) {
                        return v;
                    }
                    i += diff;
                }
            }
            return this;
        }
        return super.doStep(toArg, stepArg, block);
    }

    @Override
    public RubyValue times(RubyBlock block) {
        long value2 = this.value_;
        int i = 0;
        while ((long)i < value2) {
            RubyValue v = block.invoke((RubyValue)this, ObjectFactory.createFixnum(i));
            if (block.breakedOrReturned()) {
                return v;
            }
            ++i;
        }
        return this;
    }
}

