/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.util.HashMap;
import java.util.Iterator;

@RubyLevelClass(name="Hash", modules={"Enumerable"})
public class RubyHash
extends RubyBasic {
    private HashMap<RubyValue, RubyValue> map_ = new HashMap();
    private RubyValue default_value_ = RubyConstant.QNIL;
    private RubyBlock default_value_as_block_ = null;
    private static RubyID defaultID = RubyID.intern("default");

    RubyHash() {
        super(RubyRuntime.HashClass);
    }

    @Override
    public RubyHash clone() {
        RubyHash h = (RubyHash)super.clone();
        h.map_ = (HashMap)this.map_.clone();
        return h;
    }

    @RubyLevelMethod(name="default")
    public RubyValue getDefaultValue() {
        return this.default_value_;
    }

    @RubyLevelMethod(name="default")
    public RubyValue getDefaultValue(RubyValue value2) {
        return this.default_value_;
    }

    @RubyLevelMethod(name="default=")
    public RubyValue setDefaultValue(RubyValue defaultValue) {
        this.default_value_as_block_ = null;
        this.default_value_ = defaultValue;
        return this;
    }

    public RubyBlock getDefaultValueAsBlock() {
        return this.default_value_as_block_;
    }

    public void setDefaultValueAsBlock(RubyBlock b) {
        this.default_value_as_block_ = b;
    }

    public RubyHash add(RubyValue k, RubyValue v) {
        this.map_.put(k, v);
        return this;
    }

    @RubyLevelMethod(name="size", alias={"length"})
    public RubyFixnum size() {
        return ObjectFactory.createFixnum(this.map_.size());
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        RubyString r = ObjectFactory.createString();
        for (RubyValue key : this.map_.keySet()) {
            RubyValue value2 = this.map_.get(key);
            r.appendString(key.toString() + value2.toString());
        }
        return r;
    }

    public RubyValue get(RubyValue k) {
        RubyValue v = this.map_.get(k);
        if (null != v) {
            return v;
        }
        if (null != this.default_value_as_block_) {
            return this.default_value_as_block_.invoke((RubyValue)this, new RubyArray(this, k));
        }
        return RubyAPI.callOneArgMethod(this, k, null, defaultID);
    }

    @RubyLevelMethod(name="has_key?", alias={"include?", "key?", "member?"})
    public RubyValue has_key(RubyValue key) {
        return ObjectFactory.createBoolean(this.map_.containsKey(key));
    }

    @RubyLevelMethod(name="delete")
    public RubyValue delete(RubyValue k) {
        RubyValue v = this.map_.remove(k);
        return null != v ? v : RubyAPI.callOneArgMethod(this, k, null, defaultID);
    }

    @RubyLevelMethod(name="delete_if")
    public RubyValue delete_if(RubyBlock block) {
        Iterator<RubyValue> ite = this.map_.keySet().iterator();
        while (ite.hasNext()) {
            RubyValue value2;
            RubyValue key = ite.next();
            RubyValue r = block.invoke(this, key, value2 = this.map_.get(key));
            if (!r.isTrue()) continue;
            ite.remove();
        }
        return this;
    }

    @RubyLevelMethod(name="reject")
    public RubyValue reject(RubyBlock block) {
        RubyHash dup = this.clone();
        dup.delete_if(block);
        return dup;
    }

    @RubyLevelMethod(name="has_value?")
    public RubyValue has_value(RubyValue value2) {
        return ObjectFactory.createBoolean(this.map_.containsValue(value2));
    }

    @RubyLevelMethod(name="values_at")
    public RubyArray values_at() {
        return new RubyArray();
    }

    @RubyLevelMethod(name="values_at")
    public RubyArray values_at(RubyValue arg) {
        RubyArray a = new RubyArray();
        RubyValue v = this.map_.get(arg);
        a.add(null != v ? v : RubyConstant.QNIL);
        return a;
    }

    @RubyLevelMethod(name="values_at")
    public RubyArray values_at(RubyArray keys2) {
        RubyArray a = new RubyArray();
        for (RubyValue key : keys2) {
            RubyValue v = this.map_.get(key);
            a.add(null != v ? v : RubyConstant.QNIL);
        }
        return a;
    }

    @RubyLevelMethod(name="==")
    public RubyValue equal(RubyValue arg) {
        if (!(arg instanceof RubyHash)) {
            return RubyConstant.QFALSE;
        }
        return ObjectFactory.createBoolean(this.equals((RubyHash)arg));
    }

    public boolean equals(RubyHash that) {
        if (this.size() != that.size()) {
            return false;
        }
        for (RubyValue key : this.map_.keySet()) {
            RubyValue v1 = that.get(key);
            if (null == v1) {
                return false;
            }
            RubyValue v2 = this.get(key);
            if (RubyAPI.testEqual(v1, v2)) continue;
            return false;
        }
        return true;
    }

    @RubyLevelMethod(name="keys")
    public RubyArray keys() {
        RubyArray a = new RubyArray();
        for (RubyValue key : this.map_.keySet()) {
            a.add(key);
        }
        return a;
    }

    @RubyLevelMethod(name="values")
    public RubyArray values() {
        RubyArray a = new RubyArray();
        for (RubyValue value2 : this.map_.values()) {
            a.add(value2);
        }
        return a;
    }

    @RubyLevelMethod(name="shift")
    public RubyValue shift() {
        if (this.map_.isEmpty()) {
            return this.default_value_;
        }
        RubyValue k = this.map_.keySet().iterator().next();
        RubyValue v = this.map_.remove(k);
        RubyArray a = new RubyArray(2);
        a.add(k);
        a.add(v);
        return a;
    }

    @RubyLevelMethod(name="fetch")
    public RubyValue fetch(RubyArray args, RubyBlock block) {
        RubyValue key = args.get(0);
        if (args.size() >= 1) {
            RubyValue v = this.get(key);
            if (v != RubyConstant.QNIL) {
                return v;
            }
            if (args.size() >= 2) {
                return args.get(1);
            }
            if (null != block) {
                return block.invoke((RubyValue)this, key);
            }
            throw new RubyException(RubyRuntime.IndexErrorClass, "key not found");
        }
        throw new RubyException("not implemented");
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initialize(RubyArray args, RubyBlock block) {
        if (null != block && null != args) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments");
        }
        if (null != args) {
            RubyValue defaultValue = args.get(0);
            this.setDefaultValue(defaultValue);
        }
        if (null != block) {
            this.setDefaultValueAsBlock(block);
        }
        return this;
    }

    @RubyLevelMethod(name="[]")
    public RubyValue getValue(RubyValue arg) {
        return this.get(arg);
    }

    @RubyLevelMethod(name="[]=")
    public RubyValue setValue(RubyValue arg0, RubyValue arg1) {
        this.add(arg0, arg1);
        return arg1;
    }

    @RubyAllocMethod
    public static RubyValue alloc(RubyValue receiver) {
        RubyHash h = ObjectFactory.createHash();
        h.setRubyClass((RubyClass)receiver);
        return h;
    }
}

