/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFile;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyIOExecutor;
import com.xruby.runtime.builtin.RubyIOPipeSinkExecutor;
import com.xruby.runtime.builtin.RubyIOPipeSourceExecutor;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyTypesUtil;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.io.IOException;
import java.nio.channels.Pipe;

@RubyLevelClass(name="IO")
public class RubyIO
extends RubyBasic {
    public static RubyIO STDOUT;
    private static final RubyString DEFAULT_RS;
    private final RubyIOExecutor executor;
    private boolean is_closed_ = false;

    public RubyIO(RubyIOExecutor executor) {
        super(RubyRuntime.IOClass);
        this.executor = executor;
    }

    public RubyIO(RubyIOExecutor executor, RubyClass klass) {
        super(klass);
        this.executor = executor;
    }

    public void print(String s) {
        this.executor.print(s);
    }

    public String read() {
        return this.executor.read();
    }

    public String read(int length2, int offset) {
        return this.executor.read(length2, offset);
    }

    public String read(long length2) {
        return this.executor.read(length2);
    }

    public void truncate(int length2) {
        this.executor.truncate(length2);
    }

    @RubyLevelMethod(name="write")
    public RubyInteger write(RubyValue arg) {
        String value2 = arg.asString();
        if (this instanceof RubyFile) {
            if (value2.length() == 0) {
                return ObjectFactory.FIXNUM0;
            }
            this.executor.print(value2);
        } else {
            RubyAPI.callOneArgMethod(this, arg, null, RubyID.writeID);
        }
        return ObjectFactory.createInteger(value2.length());
    }

    public void writeInvocation(RubyValue value2) {
        RubyAPI.callOneArgMethod(this, value2, null, RubyID.writeID);
    }

    @RubyLevelMethod(name="puts")
    public RubyValue puts() {
        this.writeInvocation(DEFAULT_RS);
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="puts")
    public RubyValue puts(RubyArray args) {
        for (RubyValue arg : args) {
            String line = arg == RubyConstant.QNIL ? "nil" : arg.asString();
            this.writeInvocation(ObjectFactory.createString(line));
            int len = line.length();
            if (len != 0 && line.charAt(len - 1) == '\n') continue;
            this.writeInvocation(DEFAULT_RS);
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="print")
    public RubyValue print() {
        return this.print(new RubyArray(GlobalVariables.get("$_")));
    }

    @RubyLevelMethod(name="print")
    public RubyValue print(RubyValue arg) {
        if (arg == RubyConstant.QNIL) {
            this.writeInvocation(ObjectFactory.createString("nil"));
        } else {
            this.writeInvocation(arg);
        }
        if (GlobalVariables.OUTPUT_RS != RubyConstant.QNIL) {
            this.writeInvocation(GlobalVariables.OUTPUT_RS);
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="print")
    public RubyValue print(RubyArray args) {
        int size2 = args.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0 && GlobalVariables.OUTPUT_FS != RubyConstant.QNIL) {
                this.writeInvocation(GlobalVariables.OUTPUT_FS);
            }
            if (args.get(i) == RubyConstant.QNIL) {
                this.writeInvocation(ObjectFactory.createString("nil"));
                continue;
            }
            this.writeInvocation(args.get(i));
        }
        if (GlobalVariables.OUTPUT_RS != RubyConstant.QNIL) {
            this.writeInvocation(GlobalVariables.OUTPUT_RS);
        }
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="close")
    public RubyValue close() {
        this.executor.close();
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="flush")
    public RubyValue flush() {
        this.executor.flush();
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="seek")
    public RubyFixnum seek(RubyValue arg) {
        long pos2 = RubyTypesUtil.convertToJavaLong(arg);
        this.executor.seek(pos2);
        return ObjectFactory.FIXNUM0;
    }

    @RubyLevelMethod(name="closed?")
    public RubyValue closedP(RubyValue receiver) {
        return ObjectFactory.createBoolean(this.is_closed_);
    }

    @RubyLevelMethod(name="eof", alias={"eof?"})
    public RubyValue eof() {
        return ObjectFactory.createBoolean(this.executor.eof());
    }

    @RubyLevelMethod(name="read")
    public RubyValue read(RubyArray args) {
        RubyString buffer = null;
        if (null != args && args.size() > 1) {
            buffer = (RubyString)args.get(1);
        }
        if (null == args || RubyConstant.QNIL == args.get(0)) {
            return RubyIO.buildResult(this.executor.read(), buffer);
        }
        return RubyIO.buildResult(this.executor.read(args.get(0).toInt()), buffer);
    }

    @RubyLevelMethod(name="readpartial")
    public RubyValue readpartial(RubyArray args) {
        RubyValue v = this.read(args);
        if (this.executor.eof()) {
            throw new RubyException(RubyRuntime.EOFErrorClass, "end of file reached");
        }
        return v;
    }

    private static RubyValue buildResult(String s, RubyString buffer) {
        if (null == s) {
            if (null != buffer) {
                buffer.setString("");
            }
            return RubyConstant.QNIL;
        }
        if (null != buffer) {
            buffer.setString(s);
            return buffer;
        }
        return ObjectFactory.createString(s);
    }

    @RubyLevelMethod(name="gets")
    public RubyValue gets(RubyArray args) {
        RubyValue seperator = null == args ? GlobalVariables.get("$/") : args.get(0);
        String s = this.executor.gets(seperator);
        RubyBasic v = null == s ? RubyConstant.QNIL : ObjectFactory.createString(s);
        GlobalVariables.set(v, "$_");
        return GlobalVariables.get("$_");
    }

    @RubyLevelMethod(name="pipe")
    public static RubyValue pipeSingleton(RubyValue receiver, RubyBlock block) {
        RubyArray array = new RubyArray(2);
        try {
            Pipe pipe = Pipe.open();
            RubyIO r = new RubyIO(new RubyIOPipeSourceExecutor(pipe.source()));
            RubyIO w = new RubyIO(new RubyIOPipeSinkExecutor(pipe.sink()));
            array.add(r);
            array.add(w);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
        return array;
    }

    @RubyLevelMethod(name="read")
    public static RubyValue read(RubyValue receiver, RubyArray args, RubyBlock block) {
        RubyValue r;
        RubyString fileName = (RubyString)args.get(0);
        RubyIO io = ObjectFactory.createFile(fileName.toString(), "r");
        if (args.size() == 1) {
            r = RubyIO.buildResult(io.read(), null);
        } else {
            int length2 = ((RubyFixnum)args.get(1)).toInt();
            if (args.size() == 2) {
                r = RubyIO.buildResult(io.read(length2), null);
            } else {
                int offset = ((RubyFixnum)args.get(2)).toInt();
                r = RubyIO.buildResult(io.read(length2, offset), null);
            }
        }
        io.close();
        return r;
    }

    static {
        DEFAULT_RS = new RubyString("\n");
    }
}

