/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.RubyIOExecutor;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;

public class RubyIOPipeSinkExecutor
implements RubyIOExecutor {
    private final Pipe.SinkChannel sink;

    public RubyIOPipeSinkExecutor(Pipe.SinkChannel sink) {
        this.sink = sink;
    }

    @Override
    public void close() {
        try {
            this.sink.close();
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public boolean eof() {
        throw this.notAllowed();
    }

    private RubyException notAllowed() {
        return new RubyException(RubyRuntime.IOErrorClass, "not opened for reading");
    }

    @Override
    public void flush() {
    }

    @Override
    public String gets(RubyValue seperator) {
        throw this.notAllowed();
    }

    @Override
    public void print(String s) {
        ByteBuffer bytebuffer = ByteBuffer.wrap(s.getBytes());
        try {
            this.sink.write(bytebuffer);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public String read() {
        throw this.notAllowed();
    }

    @Override
    public String read(long length2) {
        throw this.notAllowed();
    }

    @Override
    public String read(int length2, int offset) {
        throw this.notAllowed();
    }

    @Override
    public int write(String s) {
        this.print(s);
        return s.length();
    }

    @Override
    public void truncate(int length2) {
        throw this.notAllowed();
    }

    @Override
    public void seek(long length2) {
        throw this.notAllowed();
    }
}

