/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.RubyIOExecutor;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;

public class RubyIOPipeSourceExecutor
implements RubyIOExecutor {
    private static final int BUFFER_SIZE = 1024;
    private final Pipe.SourceChannel source;
    private boolean avaliable = true;

    public RubyIOPipeSourceExecutor(Pipe.SourceChannel source2) {
        this.source = source2;
    }

    @Override
    public void close() {
        try {
            this.source.close();
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public boolean eof() {
        return !this.avaliable;
    }

    @Override
    public void flush() {
        throw this.notAllowed();
    }

    private RubyException notAllowed() {
        return new RubyException(RubyRuntime.IOErrorClass, "not opened for writing");
    }

    @Override
    public String gets(RubyValue separator2) {
        StringBuffer result = new StringBuffer();
        ByteBuffer buffer = RubyConstant.QNIL == separator2 ? ByteBuffer.allocate(1024) : ByteBuffer.allocate(1);
        try {
            while (this.avaliable = this.source.read(buffer) > 0) {
                String string2 = new String(buffer.array(), 0, buffer.position());
                result.append(string2);
                buffer.clear();
                if (RubyConstant.QNIL == separator2 || !result.toString().endsWith(separator2.toString())) continue;
                break;
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
    }

    @Override
    public void print(String s) {
        throw this.notAllowed();
    }

    @Override
    public String read() {
        return this.gets(RubyConstant.QNIL);
    }

    @Override
    public String read(long length2) {
        if (length2 == 0L) {
            if (this.avaliable) {
                return "";
            }
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)length2);
        int n = 0;
        try {
            n = this.source.read(buffer);
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
        boolean bl = this.avaliable = n > 0;
        if (!this.avaliable) {
            return null;
        }
        return new String(buffer.array(), 0, n);
    }

    @Override
    public String read(int length2, int offset) {
        ByteBuffer buffer = ByteBuffer.allocate(offset);
        try {
            this.avaliable = this.source.read(buffer) > 0;
        }
        catch (IOException e) {
            throw new RubyException(RubyRuntime.IOErrorClass, e.toString());
        }
        return this.read(length2);
    }

    @Override
    public int write(String s) {
        throw this.notAllowed();
    }

    @Override
    public void truncate(int length2) {
        throw this.notAllowed();
    }

    @Override
    public void seek(long length2) {
        throw this.notAllowed();
    }
}

