/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.lang.RubyBinding;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.RubyVarArgMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.lang.reflect.Field;

@RubyLevelClass(name="Proc")
public class RubyProc
extends RubyBinding {
    private final RubyBlock value_;

    RubyProc(RubyBlock v) {
        super(RubyRuntime.ProcClass);
        this.setSelf(RubyRuntime.TOP_LEVEL_SELF_VALUE);
        this.setScope(RubyRuntime.ObjectClass);
        this.value_ = v;
    }

    @RubyLevelMethod(name="new")
    public static RubyValue newProc(RubyValue receiver, RubyBlock block) {
        return ObjectFactory.createProc(block);
    }

    @RubyLevelMethod(name="arity")
    public RubyFixnum arity() {
        return ObjectFactory.createFixnum(this.value_.arity());
    }

    @RubyLevelMethod(name="==")
    public RubyValue equal(RubyValue v) {
        return ObjectFactory.createBoolean(this.equals(v));
    }

    @Override
    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof RubyProc) {
            return this.value_ == ((RubyProc)o).value_;
        }
        return false;
    }

    @Override
    public RubyBlock getBlock() {
        return this.value_;
    }

    public boolean isDefinedInAnotherBlock() {
        return this.value_.isDefinedInAnotherBlock();
    }

    private void setUpCallContext() {
        Field[] fields;
        for (Field f : fields = this.value_.getClass().getFields()) {
            RubyValue v;
            String name = f.getName();
            if ('$' != name.charAt(0) || null == (v = this.getVariable(name = name.substring(1)))) continue;
            try {
                f.set(this.value_, v);
            }
            catch (IllegalArgumentException e) {
                throw new Error(e);
            }
            catch (IllegalAccessException e) {
                throw new Error(e);
            }
        }
    }

    public RubyValue call(RubyArray args) {
        this.setUpCallContext();
        return this.value_.invoke(this.value_.getSelf(), args);
    }

    public RubyValue call() {
        this.setUpCallContext();
        return this.value_.invoke(this.value_.getSelf());
    }

    public RubyValue call(RubyValue arg) {
        this.setUpCallContext();
        return this.value_.invoke(this.value_.getSelf(), arg);
    }

    @RubyLevelMethod(name="call", alias={"[]"})
    public static class Invoke
    extends RubyVarArgMethod {
        @Override
        protected RubyValue run(RubyValue receiver, RubyArray args, RubyBlock block) {
            throw new Error("we overided invoke, so this method should never be called");
        }

        @Override
        public RubyValue invoke(RubyValue receiver, RubyArray args, RubyBlock block) {
            RubyValue v = ((RubyProc)receiver).call(args);
            RubyBlock anotherBlock = ((RubyProc)receiver).getBlock();
            if (null != anotherBlock) {
                v.setReturnedInBlock(anotherBlock.returned(), anotherBlock.breakedOrReturned(), !anotherBlock.createdByLambda());
            } else {
                v.setReturnedInBlock(false, false, false);
            }
            return v;
        }

        @Override
        public RubyValue invoke(RubyValue receiver, RubyBlock block) {
            RubyValue v = ((RubyProc)receiver).call();
            RubyBlock anotherBlock = ((RubyProc)receiver).getBlock();
            if (null != anotherBlock) {
                v.setReturnedInBlock(anotherBlock.returned(), anotherBlock.breakedOrReturned(), !anotherBlock.createdByLambda());
            } else {
                v.setReturnedInBlock(false, false, false);
            }
            return v;
        }

        @Override
        public RubyValue invoke(RubyValue receiver, RubyValue arg, RubyBlock block) {
            RubyBlock anotherBlock = ((RubyProc)receiver).getBlock();
            RubyArray args = ObjectFactory.createArray(1, 0, anotherBlock.createdByLambda());
            args.add(arg);
            return this.invoke(receiver, args, anotherBlock);
        }

        @Override
        public RubyValue invoke(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block) {
            RubyBlock anotherBlock = ((RubyProc)receiver).getBlock();
            RubyArray args = ObjectFactory.createArray(2, 0, anotherBlock.createdByLambda());
            args.add(arg0);
            args.add(arg1);
            return this.invoke(receiver, args, anotherBlock);
        }
    }
}

