/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import com.xruby.runtime.lang.annotation.RubyLevelModule;
import java.math.BigInteger;
import java.util.Random;

@RubyLevelModule(name="Kernel")
public class RubyRandom {
    private static long randomSeed;
    private static Random random;
    private static boolean first;
    private static RubyInteger saved_seed;

    private static RubyValue rand_init(RubyValue vseed) {
        RubyInteger seed = vseed.toRubyInteger();
        if (seed instanceof RubyFixnum) {
            randomSeed = seed.toInt();
        } else if (seed instanceof RubyBignum) {
            randomSeed = ((RubyBignum)seed).longValue();
        } else {
            throw new RubyException(RubyRuntime.TypeErrorClass, "failed to convert " + vseed.getRubyClass().getName() + " into Integer");
        }
        random.setSeed(randomSeed);
        first = false;
        RubyInteger old = saved_seed;
        saved_seed = seed;
        return old;
    }

    private static RubyValue random_seed() {
        long seed = System.nanoTime();
        return RubyBignum.bignorm(seed);
    }

    @RubyLevelMethod(name="srand")
    public static RubyValue srand(RubyValue receiver) {
        return RubyRandom.srand(receiver, RubyRandom.random_seed());
    }

    @RubyLevelMethod(name="srand")
    public static RubyValue srand(RubyValue receiver, RubyValue arg) {
        return RubyRandom.rand_init(arg);
    }

    @RubyLevelMethod(name="rand")
    public static RubyValue rand(RubyValue receiver) {
        if (first) {
            RubyRandom.rand_init(RubyRandom.random_seed());
        }
        return new RubyFloat(random.nextDouble());
    }

    @RubyLevelMethod(name="rand")
    public static RubyValue rand(RubyValue receiver, RubyValue arg) {
        long val;
        long max = 0L;
        if (first) {
            RubyRandom.rand_init(RubyRandom.random_seed());
        }
        if (arg instanceof RubyFloat) {
            RubyFloat vmax = (RubyFloat)arg;
            if (vmax.doubleValue() <= 9.223372036854776E18 && vmax.doubleValue() >= -9.223372036854776E18) {
                RubyInteger tmp = vmax.floor();
                if (tmp instanceof RubyFixnum) {
                    max = ((RubyFixnum)tmp).toInt();
                } else if (tmp instanceof RubyBignum) {
                    max = ((RubyBignum)tmp).longValue();
                }
            } else {
                arg = vmax.doubleValue() < 0.0 ? RubyBignum.bignorm((long)(-vmax.doubleValue())) : RubyBignum.bignorm((long)vmax.doubleValue());
            }
        } else if (arg == RubyConstant.QNIL) {
            max = 0L;
        } else if (arg instanceof RubyFixnum) {
            arg = arg.toRubyInteger();
            max = arg.toInt();
        }
        if (arg instanceof RubyBignum) {
            byte[] bytes = new byte[((RubyBignum)arg).getInternal().toByteArray().length - 1];
            random.nextBytes(bytes);
            return RubyBignum.bignorm(new BigInteger(1, bytes));
        }
        if (max == 0L) {
            return new RubyFloat(random.nextDouble());
        }
        if (max < 0L) {
            max = -max;
        }
        if ((val = (long)random.nextInt((int)max)) >= Integer.MIN_VALUE && val <= Integer.MAX_VALUE) {
            return new RubyFixnum((int)val);
        }
        return RubyBignum.bignorm(val);
    }

    static {
        random = new Random();
        first = true;
        saved_seed = new RubyFixnum(0);
    }
}

