/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyMatchData;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Substitution;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

@RubyLevelClass(name="Regexp")
public class RubyRegexp
extends RubyBasic {
    private Pattern pattern_;
    private static final int RE_OPTION_IGNORECASE = 1;

    RubyRegexp(String v) {
        super(RubyRuntime.RegexpClass);
        this.setValue(v, 8);
    }

    RubyRegexp(String v, String option) {
        super(RubyRuntime.RegexpClass);
        int mode = 0;
        mode = option.indexOf(109) > -1 ? (mode |= 0x10) : (mode |= 8);
        if (option.indexOf(105) > -1) {
            mode |= 1;
        }
        if (option.indexOf(120) > -1) {
            mode |= 0x20;
        }
        this.setValue(v, mode);
    }

    RubyRegexp() {
        super(RubyRuntime.RegexpClass);
    }

    private void setValue(String v, int mode) {
        Perl5Compiler compiler = new Perl5Compiler();
        v = v.replace("\\z", "\\Z");
        try {
            this.pattern_ = compiler.compile(v, mode);
        }
        catch (MalformedPatternException e) {
            throw new Error(e);
        }
    }

    @RubyAllocMethod
    public static RubyRegexp alloc(RubyValue receiver) {
        return ObjectFactory.createRegexp();
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initialize(RubyValue arg) {
        RubyValue pattern = arg;
        if (pattern instanceof RubyRegexp) {
            this.pattern_ = ((RubyRegexp)pattern).pattern_;
        } else {
            this.setValue(pattern.toStr(), 8);
        }
        return this;
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initialize(RubyValue pattern, RubyValue mode) {
        if (pattern instanceof RubyRegexp) {
            this.pattern_ = ((RubyRegexp)pattern).pattern_;
        } else {
            this.setValue(pattern.toStr(), this.getFlag(mode));
        }
        return this;
    }

    @RubyLevelMethod(name="initialize")
    public RubyValue initialize(RubyArray args) {
        return this.initialize(args.get(0), args.get(1));
    }

    private int getFlag(RubyValue mode) {
        if (mode instanceof RubyFixnum) {
            return mode.toInt();
        }
        return mode.isTrue() ? 1 : 0;
    }

    @RubyLevelMethod(name="===")
    public RubyValue caseEqual(RubyValue arg) {
        if (!(arg instanceof RubyString)) {
            return RubyConstant.QFALSE;
        }
        if (this.caseEqual(arg.toStr())) {
            return RubyConstant.QTRUE;
        }
        return RubyConstant.QFALSE;
    }

    @RubyLevelMethod(name="match")
    public RubyValue match(RubyValue arg) {
        if (!(arg instanceof RubyString)) {
            return RubyConstant.QFALSE;
        }
        RubyMatchData m = this.match(arg.toStr());
        if (null == m) {
            return RubyConstant.QNIL;
        }
        return m;
    }

    @RubyLevelMethod(name="=~")
    public RubyValue opMatch(RubyValue arg) {
        if (!(arg instanceof RubyString)) {
            return RubyConstant.QFALSE;
        }
        int p2 = this.matchPosition(arg.toStr());
        if (p2 < 0) {
            return RubyConstant.QNIL;
        }
        return ObjectFactory.createFixnum(p2);
    }

    @RubyLevelMethod(name="escape", alias={"quote"})
    public static RubyString quote(RubyValue receiver, RubyValue arg) {
        String input = arg.toStr();
        StringBuilder result = new StringBuilder(input.length() * 2);
        block8: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            switch (c) {
                case ' ': 
                case '#': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    result.append('\\');
                    result.append(c);
                    continue block8;
                }
                case '\n': {
                    result.append("\\n");
                    continue block8;
                }
                case '\t': {
                    result.append("\\t");
                    continue block8;
                }
                case '\r': {
                    result.append("\\r");
                    continue block8;
                }
                case '\f': {
                    result.append("\\f");
                    continue block8;
                }
                case '\u000b': {
                    result.append("\\v");
                    continue block8;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return new RubyString(result);
    }

    boolean caseEqual(String v) {
        return this.match(v) != null;
    }

    public RubyMatchData match(String input) {
        Perl5Matcher m = new Perl5Matcher();
        if (m.contains(input, this.pattern_)) {
            MatchResult r = m.getMatch();
            this.updateGlobalVariables(r);
            return ObjectFactory.createMatchData(r);
        }
        this.clearGlobalVariables();
        return null;
    }

    public RubyArray scan(String str) {
        RubyArray a = new RubyArray();
        PatternMatcherInput input = new PatternMatcherInput(str);
        Perl5Matcher m = new Perl5Matcher();
        while (m.contains(input, this.pattern_)) {
            MatchResult r = m.getMatch();
            this.updateGlobalVariables(r);
            if (r.groups() == 1) {
                a.add(ObjectFactory.createString(r.group(0)));
                continue;
            }
            RubyArray subarray = new RubyArray();
            for (int i = 1; i < r.groups(); ++i) {
                String s = r.group(i);
                subarray.add(null == s ? RubyConstant.QNIL : ObjectFactory.createString(s));
            }
            a.add(subarray);
        }
        return a;
    }

    public void scan(String str, RubyBlock block) {
        PatternMatcherInput input = new PatternMatcherInput(str);
        Perl5Matcher m = new Perl5Matcher();
        while (m.contains(input, this.pattern_)) {
            MatchResult r = m.getMatch();
            this.updateGlobalVariables(r);
            if (r.groups() == 1) {
                block.invoke((RubyValue)this, ObjectFactory.createString(r.group(0)));
                continue;
            }
            RubyArray subarray = new RubyArray();
            for (int i = 1; i < r.groups(); ++i) {
                subarray.add(ObjectFactory.createString(r.group(i)));
            }
            block.invoke((RubyValue)this, subarray);
        }
    }

    int matchPosition(String input) {
        Perl5Matcher m = new Perl5Matcher();
        if (m.contains(input, this.pattern_)) {
            MatchResult r = m.getMatch();
            this.updateGlobalVariables(r);
            return r.beginOffset(0);
        }
        this.clearGlobalVariables();
        return -1;
    }

    private String getReplaceString(String replace_string) {
        replace_string = replace_string.replace("\\&", "$0");
        for (int i = 1; i < 10; ++i) {
            replace_string = replace_string.replace("\\\\" + i, "$" + i);
            replace_string = replace_string.replace("\\" + i, "$" + i);
        }
        return replace_string;
    }

    public RubyString sub(RubyString input, RubyBlock block) {
        return this.sub(input, block, 0);
    }

    public RubyString gsub(RubyString input, RubyBlock block) {
        return this.sub(input, block, -1);
    }

    private RubyString sub(RubyString str, RubyBlock block, int limit) {
        RubyString result = new RubyString("");
        PatternMatcherInput input = new PatternMatcherInput(str.toString());
        Perl5Matcher matcher = new Perl5Matcher();
        int end = 0;
        boolean matched = false;
        while (matcher.contains(input, this.pattern_)) {
            matched = true;
            MatchResult r = matcher.getMatch();
            this.updateGlobalVariables(r);
            int begin = r.beginOffset(0);
            if (begin > end) {
                result.appendString(str.toString().substring(end, begin));
            }
            end = r.endOffset(0);
            RubyString match2 = new RubyString(r.group(0));
            RubyValue v = block.invoke((RubyValue)this, match2);
            result.appendString(v.toString());
            if (0 != limit) continue;
            break;
        }
        if (!matched) {
            return str;
        }
        if (end < str.length()) {
            result.appendString(str.toString().substring(end, str.length()));
        }
        return result;
    }

    public RubyString gsub(RubyString input, RubyString sub) {
        return this.sub(input, this.getReplaceString(sub.toString()), -1);
    }

    public RubyString sub(RubyString input, RubyString sub) {
        return this.sub(input, this.getReplaceString(sub.toString()), 1);
    }

    private RubyString sub(RubyString input, String sub, int limit) {
        StringBuffer result = new StringBuffer();
        int nmatch = Util.substitute(result, (PatternMatcher)new Perl5Matcher(), this.pattern_, (Substitution)new Perl5Substitution(sub, 0){

            @Override
            public void appendSubstitution(StringBuffer appendBuffer, MatchResult match2, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
                super.appendSubstitution(appendBuffer, match2, substitutionCount, originalInput, matcher, pattern);
                RubyRegexp.this.updateGlobalVariables(match2);
            }
        }, input.toString(), limit);
        if (nmatch > 0) {
            return ObjectFactory.createString(result.toString());
        }
        return input;
    }

    public Collection<String> split(String input, int limit) {
        Perl5Util util = new Perl5Util();
        ArrayList<String> result = new ArrayList<String>();
        String regx = "/" + this.pattern_.getPattern() + "/";
        util.split(result, regx, input, limit);
        return result;
    }

    @RubyLevelMethod(name="to_s")
    public RubyString to_s() {
        return ObjectFactory.createString(this.pattern_.getPattern());
    }

    @RubyLevelMethod(name="source")
    public RubyString source() {
        return ObjectFactory.createString(this.pattern_.getPattern());
    }

    private void updateGlobalVariables(MatchResult r) {
        GlobalVariables.set(ObjectFactory.createString(r.group(0)), "$&");
        for (int i = 1; i < r.groups(); ++i) {
            String s = r.group(i);
            GlobalVariables.set(null == s ? RubyConstant.QNIL : ObjectFactory.createString(s), "$" + i);
        }
    }

    private void clearGlobalVariables() {
        GlobalVariables.set(RubyConstant.QNIL, "$&");
        GlobalVariables.set(RubyConstant.QNIL, "$1");
    }
}

