/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.AttrReader;
import com.xruby.runtime.builtin.AttrWriter;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyNoArgMethod;
import com.xruby.runtime.lang.RubyObject;
import com.xruby.runtime.lang.RubyOneArgMethod;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyTwoArgMethod;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.RubyVarArgMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;

@RubyLevelClass(name="Struct")
public class RubyStruct {
    @RubyLevelMethod(name="new", singleton=true)
    public static RubyValue alloc(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (!(args.get(0) instanceof RubyString)) {
            RubyClass c = RubyRuntime.ObjectClass.defineClass(null, RubyRuntime.ObjectClass);
            RubyStruct.addMethods(c, args, 0);
            return c;
        }
        RubyClass c = RubyRuntime.StructClass.defineClass(args.get(0).toString(), RubyRuntime.ObjectClass);
        RubyStruct.addMethods(c, args, 1);
        return c;
    }

    private static void addMethods(RubyClass c, final RubyArray super_args, final int offset) {
        for (int i = offset; i < super_args.size(); ++i) {
            String s = super_args.get(i).toStr();
            c.defineMethod(s, (RubyMethod)new AttrReader(s));
            c.defineMethod(s + "=", (RubyMethod)new AttrWriter(s));
        }
        c.getSingletonClass().defineMethod("new", (RubyMethod)new RubyVarArgMethod(super_args.size() - offset, false, 0){

            @Override
            protected RubyValue run(RubyValue receiver, RubyArray args, RubyBlock block) {
                RubyObject v = new RubyObject((RubyClass)receiver);
                for (int i = 0; i < args.size(); ++i) {
                    RubyID id = RubyID.intern("@" + super_args.get(i + offset).toStr());
                    ((RubyValue)v).setInstanceVariable(args.get(i), id);
                }
                return v;
            }
        });
        c.defineMethod("[]", (RubyMethod)new RubyOneArgMethod(){

            @Override
            protected RubyValue run(RubyValue receiver, RubyValue arg, RubyBlock block) {
                String name;
                if (arg instanceof RubyString) {
                    name = arg.toString();
                } else if (arg instanceof RubySymbol) {
                    name = arg.toString();
                } else if (arg instanceof RubyFixnum) {
                    int i = ((RubyFixnum)arg).toInt();
                    name = super_args.get(i + 1).toStr();
                } else {
                    throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into Integer");
                }
                return receiver.getInstanceVariable(RubyID.intern("@" + name));
            }
        });
        c.defineMethod("[]=", (RubyMethod)new RubyTwoArgMethod(){

            @Override
            protected RubyValue run(RubyValue receiver, RubyValue arg1, RubyValue arg2, RubyBlock block) {
                String name;
                if (arg1 instanceof RubyString) {
                    name = arg1.toString();
                } else if (arg1 instanceof RubySymbol) {
                    name = arg1.toString();
                } else if (arg1 instanceof RubyFixnum) {
                    int i = ((RubyFixnum)arg1).toInt();
                    name = super_args.get(i + 1).toStr();
                } else {
                    throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg1.getRubyClass().getName() + " into Integer");
                }
                return receiver.setInstanceVariable(arg2, RubyID.intern("@" + name));
            }
        });
        c.defineMethod("to_a", (RubyMethod)new RubyNoArgMethod(){

            @Override
            protected RubyValue run(RubyValue receiver, RubyBlock block) {
                RubyArray a = new RubyArray(super_args.size() - 1);
                for (int i = 1; i < super_args.size(); ++i) {
                    String name = super_args.get(i).toStr();
                    a.add(receiver.getInstanceVariable(RubyID.intern("@" + name)));
                }
                return a;
            }
        });
    }
}

