/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyThreadGroup;
import com.xruby.runtime.builtin.RubyTypesUtil;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

@RubyLevelClass(name="Thread")
public class RubyThread
extends RubyBasic {
    private final Thread thread_;
    private ThreadLocal<HashMap<String, RubyValue>> thread_local_variables_ = new ThreadLocal<HashMap<String, RubyValue>>(){

        @Override
        protected synchronized HashMap<String, RubyValue> initialValue() {
            return new HashMap<String, RubyValue>();
        }
    };
    private RubyThreadGroup threadGroup;
    private static List<RubyThread> activeThreads = new Vector<RubyThread>();
    private static Map<Thread, RubyThread> threadMapper = new HashMap<Thread, RubyThread>();
    private static RubyThread mainThread;
    private ReentrantLock lock = new ReentrantLock();
    private volatile boolean killed = false;
    private static volatile boolean stoped;
    private static final Object stopLock;
    private static final ReentrantLock criticalLock;
    private RubyValue result = RubyConstant.QNIL;

    RubyThread(final RubyBlock block) {
        super(RubyRuntime.ThreadClass);
        this.thread_ = new Thread(new Runnable(){

            @Override
            public void run() {
                RubyThreadGroup.defaultThreadGroup.add(RubyThread.this);
                activeThreads.add(RubyThread.this);
                RubyThread.this.result = block.invoke(RubyConstant.QNIL);
                activeThreads.remove(RubyThread.this);
                RubyThreadGroup.defaultThreadGroup.add(RubyThread.this);
                threadMapper.remove(RubyThread.this.thread_);
            }
        });
        this.thread_.setDaemon(true);
        this.thread_.start();
        threadMapper.put(this.thread_, this);
    }

    private RubyThread(Thread thread) {
        super(RubyRuntime.ThreadClass);
        this.thread_ = thread;
        threadMapper.put(this.thread_, this);
    }

    public static void init() {
        mainThread = new RubyThread(Thread.currentThread());
        activeThreads.add(mainThread);
        RubyThreadGroup.defaultThreadGroup.add(mainThread);
    }

    @RubyLevelMethod(name="==")
    public RubyValue equal(RubyValue arg) {
        return ObjectFactory.createBoolean(this.equals(arg));
    }

    @RubyLevelMethod(name="priority")
    public RubyValue priority() {
        return ObjectFactory.createFixnum(this.thread_.getPriority());
    }

    @RubyLevelMethod(name="priority=")
    public RubyValue set_priority(RubyValue arg) {
        int val = arg.toInt();
        if (val < 1) {
            val = 1;
        } else if (val > 10) {
            val = 10;
        }
        this.thread_.setPriority(val);
        return this;
    }

    @RubyLevelMethod(name="alive?")
    public RubyValue alive() {
        return ObjectFactory.createBoolean(this.thread_.isAlive());
    }

    @RubyLevelMethod(name="join")
    public RubyValue join(RubyArray args, RubyBlock block) {
        long timeout = 0L;
        if (args != null && args.size() == 1) {
            timeout = RubyTypesUtil.convertToJavaLong(args.get(0)) * 1000L;
        }
        if (this.isCurrentThread()) {
            throw new RubyException(RubyRuntime.ThreadErrorClass, "Thread tried to join itself!");
        }
        if (criticalLock.isHeldByCurrentThread()) {
            this.thread_.interrupt();
        }
        this.join(timeout);
        return this;
    }

    @RubyLevelMethod(name="current", singleton=true)
    public static RubyThread current(RubyValue receiver) {
        return threadMapper.get(Thread.currentThread());
    }

    @RubyLevelMethod(name="new", alias={"fork", "start"}, singleton=true)
    public static RubyValue newThread(RubyValue receiver, RubyArray args, RubyBlock block) {
        return ObjectFactory.createThread(block);
    }

    @RubyLevelMethod(name="[]")
    public RubyValue getVariable(RubyValue name) {
        RubyValue v = this.thread_local_variables_.get().get(name.toStr());
        if (null == v) {
            return RubyConstant.QNIL;
        }
        return v;
    }

    @RubyLevelMethod(name="[]=")
    public RubyValue setVariable(RubyValue arg1, RubyValue arg2) {
        this.thread_local_variables_.get().put(arg1.toStr(), arg2);
        return arg2;
    }

    @RubyLevelMethod(name="inspect")
    public RubyValue rubyInspect() {
        StringBuffer sb = new StringBuffer();
        sb.append("#<");
        sb.append(this.getRubyClass().getRealClass().getName());
        sb.append(":0x");
        int hash2 = this.hashCode();
        sb.append(Integer.toHexString(hash2));
        sb.append(" ");
        if (this.thread_.isAlive()) {
            if (this.getKilled()) {
                sb.append("dead");
            } else {
                sb.append("run");
            }
        } else {
            sb.append("dead");
        }
        sb.append(">");
        return ObjectFactory.createString(sb.toString());
    }

    @RubyLevelMethod(name="group")
    public RubyValue getThreadGroup() {
        if (this.threadGroup == null) {
            return RubyConstant.QNIL;
        }
        return this.threadGroup;
    }

    @RubyLevelMethod(name="kill", alias={"exit"})
    public RubyValue kill() {
        this.setKilled();
        this.thread_.interrupt();
        try {
            this.thread_.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return this;
    }

    @RubyLevelMethod(name="pass", singleton=true)
    public static RubyValue pass(RubyValue receiver) {
        boolean critical2 = criticalLock.isHeldByCurrentThread();
        RubyThread.setCritical(false);
        Thread.yield();
        RubyThread.setCritical(critical2);
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="main", singleton=true)
    public static RubyValue getMainThread(RubyValue receiver) {
        return mainThread;
    }

    @RubyLevelMethod(name="stop?")
    public RubyValue getStoped() {
        return ObjectFactory.createBoolean(stoped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RubyLevelMethod(name="run")
    public RubyValue run() {
        Object object = stopLock;
        synchronized (object) {
            RubyThread.setStoped(false);
            stopLock.notifyAll();
        }
        return this;
    }

    @RubyLevelMethod(name="status")
    public RubyValue status() {
        if (this.getStoped() == RubyConstant.QTRUE) {
            return ObjectFactory.createString("sleep");
        }
        if (this.getKilled()) {
            return RubyConstant.QFALSE;
        }
        return ObjectFactory.createString("run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RubyLevelMethod(name="wakup")
    public RubyValue wakup() {
        Object object = stopLock;
        synchronized (object) {
            RubyThread.setStoped(false);
            stopLock.notifyAll();
        }
        return this;
    }

    @RubyLevelMethod(name="value")
    public RubyValue value() {
        this.join(0L);
        return this.getResult();
    }

    @RubyLevelMethod(name="key?")
    public RubyValue is_key(RubyValue arg) {
        String key = arg.toStr();
        return ObjectFactory.createBoolean(this.getVariables().contains(key));
    }

    @RubyLevelMethod(name="keys")
    public RubyValue keys() {
        Set set = this.getVariables();
        Iterator iter = set.iterator();
        RubyArray result = new RubyArray(set.size());
        while (iter.hasNext()) {
            result.add(ObjectFactory.createString((String)iter.next()));
        }
        return result;
    }

    @RubyLevelMethod(name="list", singleton=true)
    public static RubyValue list(RubyValue receiver) {
        List list2 = RubyThread.getThreadList();
        Iterator iter = list2.iterator();
        RubyArray result = new RubyArray(0);
        while (iter.hasNext()) {
            RubyThread rt = (RubyThread)iter.next();
            if (!rt.thread_.isAlive()) continue;
            result.add(rt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RubyLevelMethod(name="stop", singleton=true)
    public static RubyValue stop(RubyValue receiver) {
        Object object = stopLock;
        synchronized (object) {
            RubyThread.setStoped(true);
            try {
                RubyThread.setCritical(false);
                stopLock.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        RubyThread.setStoped(false);
        return RubyConstant.QNIL;
    }

    @RubyLevelMethod(name="critical", singleton=true)
    public static RubyValue critical(RubyValue receiver, RubyValue arg) {
        return ObjectFactory.createBoolean(criticalLock.isHeldByCurrentThread());
    }

    @RubyLevelMethod(name="critical=", singleton=true)
    public static RubyValue set_critical(RubyValue receiver, RubyValue arg) {
        boolean critical2 = false;
        if (arg == RubyConstant.QTRUE) {
            critical2 = true;
        }
        RubyThread.setCritical(critical2);
        return arg;
    }

    public void setThreadGroup(RubyThreadGroup group) {
        this.threadGroup = group;
    }

    private static List getThreadList() {
        return activeThreads;
    }

    private static void setCritical(boolean critical2) {
        if (criticalLock.isHeldByCurrentThread()) {
            if (!critical2) {
                criticalLock.unlock();
            }
        } else if (critical2) {
            criticalLock.lock();
        }
    }

    @Override
    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o instanceof RubyThread) {
            return this.thread_ == ((RubyThread)o).thread_;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sleep(long milliseconds) {
        Object object = stopLock;
        synchronized (object) {
            stoped = true;
            try {
                stopLock.wait(milliseconds);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                stoped = false;
            }
        }
    }

    private Set getVariables() {
        return this.thread_local_variables_.get().keySet();
    }

    private RubyValue getResult() {
        return this.result;
    }

    private void join(long timeout) {
        try {
            this.thread_.join(timeout);
        }
        catch (InterruptedException e) {
            throw new Error(e);
        }
    }

    private boolean isCurrentThread() {
        return this.thread_ == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setKilled() {
        this.lock.lock();
        try {
            this.killed = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean getKilled() {
        return this.killed;
    }

    private static void setStoped(boolean value2) {
        stoped = value2;
    }

    static {
        stoped = false;
        stopLock = new Object();
        criticalLock = new ReentrantLock();
    }
}

