/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.builtin;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.builtin.RubyTime;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;

public class RubyTypesUtil {
    public static RubyTime convertToTime(RubyValue arg) {
        if (arg instanceof RubyTime) {
            return (RubyTime)arg;
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into Time");
    }

    public static RubySymbol convertToSymbol(RubyValue arg) {
        if (arg instanceof RubySymbol) {
            return (RubySymbol)arg;
        }
        if (arg instanceof RubyString) {
            return ObjectFactory.createSymbol(arg.toString());
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into Symbol");
    }

    public static String convertToJavaString(RubyValue arg) {
        if (arg instanceof RubyString) {
            return ((RubyString)arg).toString();
        }
        if (arg instanceof RubySymbol) {
            return ((RubySymbol)arg).toString();
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into String");
    }

    public static long convertToJavaLong(RubyValue arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).toInt();
        }
        if (arg instanceof RubyBignum) {
            return ((RubyBignum)arg).getInternal().longValue();
        }
        if (arg instanceof RubyFloat) {
            return (long)((RubyFloat)arg).doubleValue();
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into Integer");
    }

    public static double convertToJavaDouble(RubyValue arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).toInt();
        }
        if (arg instanceof RubyBignum) {
            return ((RubyBignum)arg).getInternal().longValue();
        }
        if (arg instanceof RubyFloat) {
            return ((RubyFloat)arg).doubleValue();
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into Float");
    }

    public static float convertToJavaFloat(RubyValue arg) {
        if (arg instanceof RubyFixnum) {
            return ((RubyFixnum)arg).toInt();
        }
        if (arg instanceof RubyBignum) {
            return ((RubyBignum)arg).getInternal().longValue();
        }
        if (arg instanceof RubyFloat) {
            return (float)((RubyFloat)arg).doubleValue();
        }
        throw new RubyException(RubyRuntime.TypeErrorClass, "can't convert " + arg.getRubyClass().getName() + " into Float");
    }
}

