/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.javasupport;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.javasupport.JavaMethod;
import com.xruby.runtime.javasupport.JavaUtil;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySingletonClass;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.RubyVarArgMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaClass
extends RubyClass {
    private static final String NEW_METHOD = "new";
    private Map<String, List<Method>> methodMap = new HashMap<String, List<Method>>();
    private Map<Integer, List<Constructor>> initMap = new HashMap<Integer, List<Constructor>>();
    private Map<Method, JavaMethod> javaMethods = new HashMap<Method, JavaMethod>();
    private Map<Constructor, JavaMethod> initMethods = new HashMap<Constructor, JavaMethod>();
    private Map<String, Field> fieldNames = new HashMap<String, Field>();
    private static List<String> packageNames = new ArrayList<String>();
    private Class orginJavaClass;

    private JavaClass(Class clazz, RubyClass superclass2) {
        super(clazz.getName(), superclass2, null);
        this.orginJavaClass = clazz;
        if (!clazz.isInterface()) {
            this.initConstructors(clazz);
            this.initMethods(clazz);
            this.initFields(clazz);
        }
        this.setRubyClass(this);
    }

    private static JavaClass newJavaClass(Class clazz, RubyClass parent) {
        JavaClass jClass = new JavaClass(clazz, parent);
        if (clazz.isInterface()) {
            jClass.setRubyClass(RubyRuntime.ClassClass);
            new RubySingletonClass(jClass, parent.getRubyClass(), null);
        }
        String fullName = clazz.getName();
        RubyAPI.setTopLevelConstant(jClass, fullName);
        String name = fullName.substring(fullName.lastIndexOf(46) + 1);
        RubyValue value2 = RubyRuntime.ObjectClass.getConstant(name);
        if (value2 == null) {
            RubyAPI.setTopLevelConstant(jClass, name);
        }
        RubyAPI.setTopLevelConstant(jClass, "J" + name);
        return jClass;
    }

    public static JavaClass createJavaClass(Class clazz) {
        Class superClass = clazz.getSuperclass();
        if (superClass != null) {
            JavaClass parentClass = JavaClass.createJavaClass(superClass);
            return JavaClass.newJavaClass(clazz, parentClass);
        }
        return JavaClass.newJavaClass(clazz, RubyRuntime.ObjectClass);
    }

    private void initMethods(Class clazz) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (!Modifier.isPublic(modifiers)) continue;
            this.categoryByName(method);
        }
    }

    private void initConstructors(Class clazz) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            int modifiers = constructor.getModifiers();
            if (!Modifier.isPublic(modifiers)) continue;
            this.categoryByParams(constructor);
        }
    }

    private void initFields(Class clazz) {
        Field[] fields;
        for (Field f : fields = clazz.getDeclaredFields()) {
            String name = f.getName();
            int modifiers = f.getModifiers();
            this.fieldNames.put(name, f);
            if (!Modifier.isFinal(modifiers)) {
                String setterName = name + "=";
                this.fieldNames.put(setterName, f);
            }
            if (!Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers) || !Modifier.isFinal(modifiers)) continue;
            try {
                this.setConstant(name, JavaUtil.convertToRubyValue(f.get(null)));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private void categoryByName(Method method) {
        String name = method.getName();
        List<Method> list2 = this.methodMap.get(name);
        if (null == list2) {
            list2 = new ArrayList<Method>();
            list2.add(method);
            this.methodMap.put(name, list2);
        } else {
            list2.add(method);
        }
    }

    private void categoryByParams(Constructor constructor) {
        Class<?>[] types = constructor.getParameterTypes();
        int size2 = types.length;
        List<Constructor> list2 = this.initMap.get(size2);
        if (null == list2) {
            list2 = new ArrayList<Constructor>();
            list2.add(constructor);
            this.initMap.put(size2, list2);
        } else {
            list2.add(constructor);
        }
    }

    @Override
    public RubyMethod findOwnPublicMethod(RubyID mid) {
        String methodName = mid.toString();
        if (methodName == null) {
            return null;
        }
        if (methodName.equals(NEW_METHOD)) {
            return new FakeInitMethod();
        }
        for (RubyClass klass = this; klass != null; klass = klass.getSuperClass()) {
            if (klass instanceof JavaClass) {
                if (klass.methodMap.containsKey(methodName)) {
                    return new FakeMethod(methodName);
                }
                if (!klass.fieldNames.keySet().contains(methodName)) continue;
                return new FakeInstanceVarMethod(methodName);
            }
            return ((RubyClass)klass).findOwnPublicMethod(mid);
        }
        return null;
    }

    private JavaMethod getJavaMethod(Method method) {
        JavaMethod jMethod = this.javaMethods.get(method);
        if (null == jMethod) {
            jMethod = new JavaMethod(method);
            this.javaMethods.put(method, jMethod);
        }
        return jMethod;
    }

    JavaMethod findJavaMethod(String methodName, RubyArray args) {
        int size2 = args == null ? 0 : args.size();
        List<Method> list2 = null;
        for (RubyClass klass = this; klass != null && null == (list2 = klass.methodMap.get(methodName)); klass = klass.getSuperClass()) {
        }
        if (null == list2) {
            return null;
        }
        if (list2.size() == 1) {
            Method method = list2.get(0);
            Class<?>[] params = method.getParameterTypes();
            if (size2 != params.length) {
                throw new RubyException("Illegal arguments");
            }
            return this.getJavaMethod(method);
        }
        ArrayList<Method> tmpList = new ArrayList<Method>();
        for (Method method : list2) {
            if (method.getParameterTypes().length != size2) continue;
            tmpList.add(method);
        }
        if (tmpList.size() == 1) {
            return this.getJavaMethod((Method)tmpList.get(0));
        }
        return this.getJavaMethod(JavaUtil.matchMethod(tmpList, args));
    }

    JavaMethod getJavaConstructor(Constructor constructor) {
        JavaMethod jMethod = this.initMethods.get(constructor);
        if (null == jMethod) {
            jMethod = new JavaMethod(constructor);
            this.initMethods.put(constructor, jMethod);
        }
        return jMethod;
    }

    JavaMethod findInitMethod(RubyArray args) {
        int size2 = args == null ? 0 : args.size();
        List<Constructor> list2 = this.initMap.get(size2);
        if (null == list2) {
            return null;
        }
        if (list2.size() == 1) {
            Constructor constructor = list2.get(0);
            return this.getJavaConstructor(constructor);
        }
        return this.getJavaConstructor(JavaUtil.matchInitMethod(list2, args));
    }

    public static Object getter(Field f, Object obj) {
        try {
            return f.get(obj);
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e2) {
            String name = f.getName();
            StringBuffer sb = new StringBuffer();
            sb.append("get");
            sb.append(Character.toUpperCase(name.charAt(0)));
            sb.append(name.substring(1));
            String methodName = sb.toString();
            try {
                Method[] ms;
                for (Method m : ms = obj.getClass().getMethods()) {
                    if (!m.getName().equals(methodName)) continue;
                    return m.invoke(obj, new Object[0]);
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        throw new RubyException("The Instance variable " + f.getName() + "doesn't exists or can't be accessed!");
    }

    public static void setter(Field f, Object obj, Object val) {
        try {
            f.set(obj, val);
            return;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
            String name = f.getName();
            StringBuffer sb = new StringBuffer();
            sb.append("set");
            sb.append(Character.toUpperCase(name.charAt(0)));
            sb.append(name.substring(1));
            String methodName = sb.toString();
            try {
                Method[] ms;
                for (Method m : ms = obj.getClass().getMethods()) {
                    if (!m.getName().equals(methodName)) continue;
                    m.invoke(obj, val);
                    return;
                }
            }
            catch (Exception e1) {
                // empty catch block
            }
        }
        throw new RubyException("The Instance variable " + f.getName() + "doesn't exists or can't be accessed!");
    }

    public static void addPackage(String name) {
        packageNames.add(name);
    }

    public static String[] getPackeageList() {
        String[] tmp = new String[packageNames.size()];
        Iterator<String> iter = packageNames.iterator();
        int count2 = 0;
        while (iter.hasNext()) {
            tmp[count2] = iter.next();
            ++count2;
        }
        return tmp;
    }

    public Class getOriginJavaClass() {
        return this.orginJavaClass;
    }

    private class FakeInstanceVarMethod
    extends RubyVarArgMethod {
        private String instanceVarName;

        public FakeInstanceVarMethod(String name) {
            this.instanceVarName = name;
        }

        @Override
        protected RubyValue run(RubyValue receiver, RubyArray args, RubyBlock block) {
            JavaClass clazz = null;
            clazz = receiver instanceof JavaClass ? (JavaClass)receiver : (JavaClass)receiver.getRubyClass();
            JavaMethod method = null;
            boolean flag = false;
            do {
                if (!clazz.fieldNames.keySet().contains(this.instanceVarName)) continue;
                Method m = null;
                boolean isGetter = true;
                try {
                    if (this.instanceVarName.endsWith("=")) {
                        isGetter = false;
                        m = JavaClass.class.getDeclaredMethod("setter", Field.class, Object.class, Object.class);
                    } else {
                        m = JavaClass.class.getDeclaredMethod("getter", Field.class, Object.class);
                    }
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                method = new JavaMethod(m, (Field)clazz.fieldNames.get(this.instanceVarName), isGetter);
                break;
            } while (!(flag = (clazz = (JavaClass)clazz.getSuperClass()).getName().equals("Object")));
            if (flag) {
                throw new RubyException("The Instance variable " + this.instanceVarName + "doesn't exists or can't be accessed!");
            }
            return method.run(receiver, args, block);
        }
    }

    private class FakeInitMethod
    extends RubyVarArgMethod {
        private FakeInitMethod() {
        }

        @Override
        protected RubyValue run(RubyValue receiver, RubyArray args, RubyBlock block) {
            JavaClass clazz = (JavaClass)receiver;
            JavaMethod method = clazz.findInitMethod(args);
            if (null == method) {
                throw new RubyException("Signature is illegal");
            }
            return method.run(receiver, args, block);
        }
    }

    private class FakeMethod
    extends RubyVarArgMethod {
        private String methodName;

        public FakeMethod(String methodName) {
            this.methodName = methodName;
        }

        @Override
        protected RubyValue run(RubyValue receiver, RubyArray args, RubyBlock block) {
            JavaClass clazz = null;
            clazz = receiver instanceof JavaClass ? (JavaClass)receiver : (JavaClass)receiver.getRubyClass();
            JavaMethod method = clazz.findJavaMethod(this.methodName, args);
            if (null == method) {
                throw new RubyException("Signature of method " + this.methodName + " is illegal");
            }
            return method.run(receiver, args, block);
        }
    }
}

