/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.javasupport;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyData;
import com.xruby.runtime.javasupport.JavaClass;
import com.xruby.runtime.javasupport.JavaUtil;
import com.xruby.runtime.javasupport.RubyJavaObject;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyExceptionValue;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.RubyVarArgMethod;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class JavaMethod
extends RubyVarArgMethod {
    private Method method;
    private Field field;
    private Constructor constructor;
    private boolean isConstructor;
    private boolean isField;
    private boolean isGetter;

    public JavaMethod(Method method) {
        this.method = method;
    }

    public JavaMethod(Constructor constructor) {
        this.constructor = constructor;
        this.isConstructor = true;
    }

    public JavaMethod(Method method, Field field, boolean isGetter) {
        this.method = method;
        this.field = field;
        this.isField = true;
        this.isGetter = isGetter;
    }

    @Override
    protected RubyValue run(RubyValue receiver, RubyArray args, RubyBlock block) {
        Object[] arguments = JavaUtil.convertToJavaValues(args);
        try {
            if (!this.isConstructor) {
                Throwable object = null;
                if (!(receiver instanceof JavaClass)) {
                    object = receiver instanceof RubyExceptionValue ? ((RubyExceptionValue)receiver).getThrowable() : ((RubyData)receiver).getData();
                }
                Object retValue = null;
                if (this.isField) {
                    if (!Modifier.isStatic(this.field.getModifiers()) && object == null) {
                        throw new RubyException("The Instance variable " + this.field.getName() + "doesn't exists or can't be accessed!");
                    }
                    if (this.isGetter) {
                        retValue = this.method.invoke(null, this.field, object);
                    } else {
                        this.method.invoke(null, this.field, object, arguments[0]);
                    }
                } else {
                    if (!Modifier.isStatic(this.method.getModifiers()) && object == null) {
                        throw new RubyException(RubyRuntime.NoMethodErrorClass, "undefined method '" + this.method.getName() + "' for " + ((RubyClass)receiver).getName());
                    }
                    retValue = this.method.invoke((Object)object, arguments);
                }
                return JavaUtil.convertToRubyValue(retValue);
            }
            Object instance = this.constructor.newInstance(arguments);
            RubyJavaObject value2 = new RubyJavaObject((JavaClass)receiver, instance);
            return value2;
        }
        catch (IllegalArgumentException e) {
            throw new RubyException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new RubyException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new RubyException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t != null) {
                RubyExceptionValue exp2 = new RubyExceptionValue((RubyClass)RubyRuntime.ObjectClass.getConstant(t.getClass().getName()), t.getLocalizedMessage(), t);
                throw new RubyException(exp2);
            }
            throw new RubyException(e.getMessage());
        }
    }
}

