/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.lang.ObjectSpace;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySingletonClass;
import com.xruby.runtime.lang.RubyValue;

class ClassFactory {
    public static RubyClass defineClass(String name, RubyClass superclass2) {
        RubyValue value2;
        if (superclass2 == null) {
            superclass2 = RubyRuntime.ObjectClass;
        }
        if ((value2 = RubyRuntime.ObjectClass.getConstant(name)) != null) {
            if (!(value2 instanceof RubyClass)) {
                throw new RubyException(RubyRuntime.TypeErrorClass, name + " is not a class");
            }
            RubyClass klass = (RubyClass)value2;
            if (klass.getSuperClass().getRealClass() != superclass2) {
                throw new RubyException(RubyRuntime.NameErrorClass, name + " is already defined");
            }
            klass.setAccessPublic();
            ObjectSpace.add(klass);
            return klass;
        }
        RubyClass klass = ClassFactory.makeRubyClass(superclass2);
        klass.setName(name);
        RubyRuntime.ObjectClass.setConstant(name, klass);
        ClassFactory.inheritedClass(superclass2, klass);
        ObjectSpace.add(klass);
        return klass;
    }

    public static RubyModule defineModule(String name) {
        RubyValue value2 = RubyRuntime.ObjectClass.getConstant(name);
        if (value2 != null) {
            RubyModule module;
            if (value2 instanceof RubyModule && (module = (RubyModule)value2).isRealModule()) {
                return module;
            }
            throw new RubyException(RubyRuntime.TypeErrorClass, name + " is not a module");
        }
        RubyModule module = ClassFactory.createRubyModule(name);
        RubyRuntime.ObjectClass.setConstant(name, module);
        ObjectSpace.add(module);
        return module;
    }

    static RubyClass defineBootClass(String name, RubyClass superclass2) {
        RubyClass klass = ClassFactory.createBootClass(superclass2);
        klass.setName(name);
        RubyClass constObj = RubyRuntime.ObjectClass != null ? RubyRuntime.ObjectClass : klass;
        constObj.setConstant(name, klass);
        return klass;
    }

    private static RubyClass createRubyClass(RubyClass superclass2) {
        if (superclass2 == RubyRuntime.ClassClass) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "can't make subclass of Class");
        }
        if (!superclass2.isRealClass()) {
            throw new RubyException(RubyRuntime.TypeErrorClass, "can't make subclass of virtual class");
        }
        return ClassFactory.createBootClass(superclass2);
    }

    static RubyClass makeRubyClass(RubyClass superclass2) {
        if (superclass2 == null) {
            superclass2 = RubyRuntime.ObjectClass;
        }
        RubyClass klass = ClassFactory.createRubyClass(superclass2);
        new RubySingletonClass(klass, superclass2.getRubyClass(), null);
        return klass;
    }

    public static RubyClass createBootClass(RubyClass superclass2) {
        RubyClass klass = new RubyClass(null, superclass2, null);
        klass.setRubyClass(RubyRuntime.ClassClass);
        return klass;
    }

    private static RubyModule createRubyModule(String name) {
        RubyModule module = new RubyModule(name, null);
        module.setName(name);
        module.setRubyClass(RubyRuntime.ModuleClass);
        return module;
    }

    static void inheritedClass(RubyClass superclass2, RubyClass klass) {
        if (RubyRuntime.running) {
            if (superclass2 == null) {
                superclass2 = RubyRuntime.ObjectClass;
            }
            superclass2.setInherited(klass);
        }
    }

    private ClassFactory() {
    }
}

