/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyIO;
import com.xruby.runtime.builtin.RubyProc;
import com.xruby.runtime.lang.DefaultGlobalVariable;
import com.xruby.runtime.lang.GlobalVariable;
import com.xruby.runtime.lang.MultipleMap;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalVariables {
    public static RubyValue OUTPUT_FS = RubyConstant.QNIL;
    public static RubyValue OUTPUT_RS = RubyConstant.QNIL;
    private static ConcurrentHashMap<String, GlobalVariable> values_ = new ConcurrentHashMap();
    private static MultipleMap<RubyProc> traces_procs_ = new MultipleMap();
    private static boolean in_tracing_ = false;

    public static void initialize() {
        values_.put("$,", new GlobalVariable(){

            @Override
            public RubyValue get() {
                return OUTPUT_FS;
            }

            @Override
            public void set(RubyValue v) {
                OUTPUT_FS = v;
            }
        });
        values_.put("$\\", new GlobalVariable(){

            @Override
            public RubyValue get() {
                return OUTPUT_RS;
            }

            @Override
            public void set(RubyValue v) {
                OUTPUT_RS = v;
            }
        });
        values_.put("$stdout", new GlobalVariable(){

            @Override
            public RubyValue get() {
                return RubyIO.STDOUT;
            }

            @Override
            public void set(RubyValue v) {
                RubyIO.STDOUT = (RubyIO)v;
            }
        });
        values_.put("$/", new DefaultGlobalVariable(ObjectFactory.createString("\n")));
        values_.put("$$", new DefaultGlobalVariable(ObjectFactory.FIXNUM0));
    }

    public static void importValuesFromCommandLine(String[] values2) {
        for (String s : values2) {
            int i = s.indexOf(61);
            if (0 == i) {
                throw new Error("bad format!");
            }
            if (i < 0) {
                values_.put("$" + s, new DefaultGlobalVariable(RubyConstant.QTRUE));
                continue;
            }
            String name = "$" + s.substring(0, i);
            String value2 = s.substring(i + 1);
            values_.put(name, new DefaultGlobalVariable(ObjectFactory.createString(value2)));
        }
    }

    public static RubyValue get(String name) {
        assert ('$' == name.charAt(0));
        GlobalVariable v = values_.get(name);
        if (null != v) {
            return v.get();
        }
        return RubyConstant.QNIL;
    }

    public static boolean isReadOnly(String name) {
        return name.equals("$$");
    }

    public static void throwNameError(String name) {
        throw new RubyException(RubyRuntime.NameErrorClass, name + " is a read-only variable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyValue set(RubyValue value2, String name) {
        assert ('$' == name.charAt(0));
        GlobalVariable gv = values_.get(name);
        if (gv == null) {
            values_.put(name, new DefaultGlobalVariable(value2));
        } else {
            gv.set(value2);
        }
        if (!in_tracing_) {
            in_tracing_ = true;
            try {
                List<RubyProc> set = traces_procs_.get(name);
                if (null != set) {
                    for (RubyProc p2 : set) {
                        p2.getBlock().invoke(value2, value2);
                    }
                }
            }
            finally {
                in_tracing_ = false;
            }
        }
        return value2;
    }

    public static void alias(String newName, String oldName) {
        assert ('$' == newName.charAt(0));
        assert ('$' == oldName.charAt(0));
        GlobalVariable v = values_.get(oldName);
        if (null != v) {
            values_.put(newName, v);
        }
    }

    private static boolean isDefined(String name) {
        return values_.get(name) != null;
    }

    public static void addTraceProc(String name, RubyProc proc) {
        traces_procs_.put(name, proc);
    }

    public static void removeTraceProc(String name, RubyProc proc) {
        if (!GlobalVariables.isDefined(name)) {
            throw new RubyException(RubyRuntime.NameErrorClass, "undefined global variable " + name);
        }
        traces_procs_.remove(name, proc);
    }

    public static void removeAllTraceProc(String name) {
        if (!GlobalVariables.isDefined(name)) {
            throw new RubyException(RubyRuntime.NameErrorClass, "undefined global variable " + name);
        }
        traces_procs_.removeAll(name);
    }

    public static void setProgramName(String filename) {
        GlobalVariables.set(ObjectFactory.createString(filename), "$0");
    }
}

