/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyHash;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import java.math.BigInteger;

class MarshalDumper {
    MarshalDumper() {
    }

    private static void packInteger(RubyFixnum v, StringBuilder sb) {
        sb.append('i');
        MarshalDumper.packInteger(v.toInt(), sb);
    }

    private static void packInteger(int v, StringBuilder sb) {
        if (0 == v) {
            sb.append('\u0000');
        } else {
            sb.append((char)(v + 5));
        }
    }

    private static void packString(RubyString v, StringBuilder sb) {
        sb.append('\"');
        MarshalDumper.packInteger(v.length(), sb);
        sb.append(v);
    }

    private static void packSymbol(RubySymbol v, StringBuilder sb) {
        sb.append(':');
        MarshalDumper.packInteger(v.toString().length(), sb);
        sb.append(v.toString());
    }

    private static void packArray(RubyArray v, StringBuilder sb) {
        sb.append('[');
        MarshalDumper.packInteger(v.size(), sb);
        for (RubyValue a : v) {
            MarshalDumper.packValue(a, sb);
        }
    }

    private static void packHash(RubyHash v, StringBuilder sb) {
        sb.append('{');
        MarshalDumper.packInteger(v.size().toInt(), sb);
        RubyArray keys2 = v.keys();
        for (RubyValue a : keys2) {
            MarshalDumper.packValue(a, sb);
            MarshalDumper.packValue(v.get(a), sb);
        }
    }

    private static void packFloat(RubyFloat v, StringBuilder sb) {
        sb.append('f');
        String s = Double.toString(v.doubleValue());
        MarshalDumper.packInteger(s.length(), sb);
        sb.append(s);
    }

    private static void packBignum(RubyBignum v, StringBuilder sb) {
        sb.append('l');
        BigInteger biginteger = v.getInternal();
        if (biginteger.compareTo(BigInteger.ZERO) > 0) {
            sb.append('+');
        } else {
            sb.append('-');
        }
        int size2 = v.size();
        sb.append((char)size2);
        byte[] bytes = new byte[size2];
        byte[] orig = biginteger.toByteArray();
        System.arraycopy(orig, 0, bytes, size2 - orig.length, orig.length);
        for (int i = size2 - 1; i >= 0; --i) {
            byte c = bytes[i];
            sb.append((char)(c & 0xFF));
        }
    }

    private static void packObject(RubyValue v, StringBuilder sb) {
        sb.append("C:");
        String s = v.getRubyClass().getName();
        MarshalDumper.packInteger(s.length(), sb);
        sb.append(s);
        if (!(v instanceof RubyString)) {
            throw new RubyException("not implemented");
        }
        MarshalDumper.packString((RubyString)v, sb);
    }

    private static void packValue(RubyValue v, StringBuilder sb) {
        if (v == RubyConstant.QNIL) {
            sb.append('\u0000');
        } else if (v == RubyConstant.QTRUE) {
            sb.append('T');
        } else if (v == RubyConstant.QFALSE) {
            sb.append('F');
        } else {
            RubyClass klass = v.getRubyClass().getRealClass();
            if (klass == RubyRuntime.StringClass) {
                MarshalDumper.packString((RubyString)v, sb);
            } else if (klass == RubyRuntime.SymbolClass) {
                MarshalDumper.packSymbol((RubySymbol)v, sb);
            } else if (klass == RubyRuntime.FixnumClass) {
                MarshalDumper.packInteger((RubyFixnum)v, sb);
            } else if (klass == RubyRuntime.ArrayClass) {
                MarshalDumper.packArray((RubyArray)v, sb);
            } else if (klass == RubyRuntime.HashClass) {
                MarshalDumper.packHash((RubyHash)v, sb);
            } else if (klass == RubyRuntime.FloatClass) {
                MarshalDumper.packFloat((RubyFloat)v, sb);
            } else if (klass == RubyRuntime.BignumClass) {
                MarshalDumper.packBignum((RubyBignum)v, sb);
            } else {
                MarshalDumper.packObject(v, sb);
            }
        }
    }

    public static RubyString dump(RubyValue v) {
        StringBuilder sb = new StringBuilder();
        sb.append('\u0004');
        sb.append('\b');
        MarshalDumper.packValue(v, sb);
        return ObjectFactory.createString(sb);
    }
}

