/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyBignum;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyHash;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySymbol;
import com.xruby.runtime.lang.RubyValue;
import java.math.BigInteger;

class MarshalLoader {
    private int current_index_ = 0;

    MarshalLoader() {
    }

    private int loadInteger(String v) {
        char c = v.charAt(this.current_index_);
        ++this.current_index_;
        if ('\u0000' == c) {
            return c;
        }
        return c - 5;
    }

    private RubyFloat loadFloat(String v) {
        int length2 = this.loadInteger(v);
        String s = v.substring(this.current_index_, this.current_index_ + length2);
        double d = Double.parseDouble(s);
        this.current_index_ += length2;
        return ObjectFactory.createFloat(d);
    }

    private RubySymbol loadSymbol(String v) {
        return ObjectFactory.createSymbol(this._loadString(v));
    }

    private RubyString loadString(String v) {
        return ObjectFactory.createString(this._loadString(v));
    }

    private String _loadString(String v) {
        int length2 = this.loadInteger(v);
        String s = v.substring(this.current_index_, this.current_index_ + length2);
        this.current_index_ += length2;
        return s;
    }

    private RubyArray loadArray(String v) {
        int length2 = this.loadInteger(v);
        RubyArray a = new RubyArray(length2);
        for (int i = 0; i < length2; ++i) {
            RubyValue value2 = this.loadValue(v);
            a.add(value2);
        }
        return a;
    }

    private RubyHash loadHash(String v) {
        int length2 = this.loadInteger(v);
        RubyHash h = ObjectFactory.createHash();
        for (int i = 0; i < length2; ++i) {
            RubyValue k = this.loadValue(v);
            RubyValue value2 = this.loadValue(v);
            h.add(k, value2);
        }
        return h;
    }

    private RubyBignum loadBignum(String v) {
        char sign = v.charAt(this.current_index_++);
        int length2 = v.charAt(this.current_index_++);
        BigInteger biginteger = BigInteger.valueOf(0L);
        for (int i = 0; i < length2; ++i) {
            BigInteger tmp = BigInteger.valueOf(v.charAt(this.current_index_ + i));
            tmp = tmp.shiftLeft(i * 8);
            biginteger = biginteger.add(tmp);
        }
        this.current_index_ += length2;
        return ObjectFactory.createBignum(biginteger);
    }

    private RubyValue loadObject(String v) {
        ++this.current_index_;
        String class_name = this._loadString(v);
        RubyValue r = this.loadValue(v);
        r.setRubyClass((RubyClass)RubyAPI.getConstant(RubyRuntime.ObjectClass, class_name));
        return r;
    }

    private RubyValue loadValue(String v) {
        char c = v.charAt(this.current_index_);
        ++this.current_index_;
        switch (c) {
            case '\u0000': {
                return RubyConstant.QNIL;
            }
            case 'T': {
                return RubyConstant.QTRUE;
            }
            case 'F': {
                return RubyConstant.QFALSE;
            }
            case 'i': {
                return ObjectFactory.createFixnum(this.loadInteger(v));
            }
            case '\"': {
                return this.loadString(v);
            }
            case ':': {
                return this.loadSymbol(v);
            }
            case '[': {
                return this.loadArray(v);
            }
            case '{': {
                return this.loadHash(v);
            }
            case 'f': {
                return this.loadFloat(v);
            }
            case 'l': {
                return this.loadBignum(v);
            }
            case 'C': {
                return this.loadObject(v);
            }
        }
        throw new RubyException("not implemented " + c);
    }

    public RubyValue load(RubyString s) {
        String v = s.toString();
        if (v.length() <= 2) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "marshal data too short");
        }
        if (v.charAt(0) != '\u0004' && v.charAt(1) != '\b') {
            throw new RubyException(RubyRuntime.TypeErrorClass, "incompatible marshal file format (can't be read)");
        }
        this.current_index_ += 2;
        return this.loadValue(v);
    }
}

