/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.lang.MethodBlockBase;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;

public abstract class RubyBlock
extends MethodBlockBase {
    protected boolean __break__ = false;
    protected boolean __return__ = false;
    protected boolean __retry__ = false;
    protected RubyValue selfOfCurrentMethod_;
    protected RubyArray argsOfCurrentMethod_;
    protected final RubyValue argOfCurrentMethod_;
    protected final RubyBlock blockOfCurrentMethod_;
    private final boolean definedInAnotherBlock_;
    private boolean createdByLambda_ = false;
    private RubyMethod currentMethod_;

    public RubyBlock(int argc, boolean has_asterisk_parameter, int default_argc, RubyValue self, RubyValue arg, RubyArray args, RubyBlock block, RubyModule scope, RubyMethod currentMethod, boolean definedInAnotherBlock) {
        super(argc, has_asterisk_parameter, default_argc);
        this.selfOfCurrentMethod_ = self;
        this.argOfCurrentMethod_ = arg;
        this.argsOfCurrentMethod_ = args;
        this.blockOfCurrentMethod_ = block;
        this.setScope(scope);
        this.currentMethod_ = currentMethod;
        this.definedInAnotherBlock_ = definedInAnotherBlock;
    }

    public void setArgsOfCurrentMethod(RubyArray args) {
        this.argsOfCurrentMethod_ = args;
    }

    public void setCurrentMethod(RubyMethod m) {
        this.currentMethod_ = m;
    }

    public RubyMethod getCurrentMethod() {
        return this.currentMethod_;
    }

    @Override
    public RubyID getID() {
        return this.currentMethod_.getID();
    }

    public void setSelf(RubyValue v) {
        this.selfOfCurrentMethod_ = v;
    }

    public RubyValue getSelf() {
        return this.selfOfCurrentMethod_;
    }

    public boolean isDefinedInAnotherBlock() {
        return this.definedInAnotherBlock_;
    }

    public boolean breakedOrReturned() {
        return this.__break__ || this.__return__;
    }

    public boolean returned() {
        return this.createdByLambda_ ? false : this.__return__;
    }

    public boolean shouldRetry() {
        return this.__retry__;
    }

    public void setCreatedByLambda() {
        this.createdByLambda_ = true;
    }

    public boolean createdByLambda() {
        return this.createdByLambda_;
    }

    private void validateParameterForProcCall(int actual_args_length) {
        int required_args_length;
        if (this.argc_ >= 0 && !this.has_asterisk_parameter_ && actual_args_length != (required_args_length = this.argc_ - this.default_argc_)) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "wrong number of arguments (" + actual_args_length + " for " + required_args_length + ")");
        }
    }

    public RubyValue invoke(RubyValue receiver, RubyArray args) {
        if (this.createdByLambda_) {
            this.validateParameterForProcCall(null == args ? 0 : args.size());
        }
        this.__break__ = false;
        this.__return__ = false;
        this.__retry__ = false;
        RubyValue v = this.run(receiver, null != args ? args : new RubyArray(0));
        if (v.returnedInBlock()) {
            this.__return__ = true;
        }
        return v;
    }

    protected abstract RubyValue run(RubyValue var1, RubyArray var2);

    public RubyValue invoke(RubyValue receiver) {
        if (this.createdByLambda_) {
            this.validateParameterForProcCall(0);
        }
        this.__break__ = false;
        this.__return__ = false;
        this.__retry__ = false;
        RubyValue v = this.run(receiver);
        if (v.returnedInBlock()) {
            this.__return__ = true;
        }
        return v;
    }

    protected RubyValue run(RubyValue receiver) {
        return this.run(receiver, new RubyArray(0));
    }

    public RubyValue invoke(RubyValue receiver, RubyValue arg) {
        if (this.createdByLambda_) {
            this.validateParameterForProcCall(1);
        }
        this.__break__ = false;
        this.__return__ = false;
        this.__retry__ = false;
        RubyValue v = this.run(receiver, arg);
        if (v.returnedInBlock()) {
            this.__return__ = true;
        }
        return v;
    }

    protected RubyValue run(RubyValue receiver, RubyValue arg) {
        return this.run(receiver, new RubyArray(arg));
    }

    public RubyValue invoke(RubyValue receiver, RubyValue arg1, RubyValue arg2) {
        if (this.createdByLambda_) {
            this.validateParameterForProcCall(2);
        }
        this.__break__ = false;
        this.__return__ = false;
        this.__retry__ = false;
        RubyValue v = this.run(receiver, arg1, arg2);
        if (v.returnedInBlock()) {
            this.__return__ = true;
        }
        return v;
    }

    protected RubyValue run(RubyValue receiver, RubyValue arg0, RubyValue arg1) {
        return this.run(receiver, new RubyArray(arg0, arg1));
    }
}

