/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;

@RubyLevelClass(name="Exception")
public class RubyExceptionValue
extends RubyBasic {
    private RubyException exception_;
    private String message_;
    private Throwable throwable_;

    public RubyExceptionValue(RubyClass c) {
        super(c);
        GlobalVariables.set(this, "$!");
    }

    public RubyExceptionValue(RubyClass c, String message) {
        super(c);
        this.message_ = message;
        GlobalVariables.set(this, "$!");
    }

    public RubyExceptionValue(RubyClass c, String message, Throwable t) {
        super(c);
        this.message_ = message;
        this.throwable_ = t;
        GlobalVariables.set(this, "$!");
    }

    public void setMessage(String message) {
        this.message_ = message;
    }

    void setException(RubyException exception) {
        this.exception_ = exception;
    }

    @RubyAllocMethod
    public static RubyExceptionValue alloc(RubyValue receiver) {
        return new RubyExceptionValue((RubyClass)receiver);
    }

    @RubyLevelMethod(name="initialize")
    public RubyExceptionValue initialize() {
        this.setMessage("");
        return this;
    }

    @RubyLevelMethod(name="initialize")
    public RubyExceptionValue initialize(RubyValue v) {
        this.setMessage(v.toStr());
        return this;
    }

    @RubyLevelMethod(name="to_s", alias={"message", "to_str"})
    public RubyString to_s() {
        return ObjectFactory.createString(this.message_);
    }

    @Override
    public String toString() {
        return this.message_;
    }

    @RubyLevelMethod(name="backtrace")
    public RubyArray backtrace() {
        StackTraceElement[] trace;
        RubyArray a = new RubyArray();
        for (StackTraceElement e : trace = this.exception_.getStackTrace()) {
            String s = e.getClassName();
            if (s.startsWith("com.xruby") && !s.startsWith("com.xruby.runtime.builtin")) continue;
            a.add(ObjectFactory.createString(s));
        }
        return a;
    }

    public Throwable getThrowable() {
        return this.throwable_;
    }
}

