/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.ObjectFactory;
import com.xruby.runtime.builtin.RubyFixnum;
import com.xruby.runtime.lang.RubySymbol;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class RubyID {
    private static Map<String, RubyID> symbolMap = new HashMap<String, RubyID>();
    private static AtomicLong lastId = new AtomicLong(2L);
    public static RubyID ID_ALLOCATOR = new RubyID(1L);
    private long id;
    private String name;
    private RubySymbol symbol;
    static final RubyID attachedID = RubyID.intern("__attached__");
    static final RubyID classidID = RubyID.intern("__classid__");
    public static final RubyID ltID = RubyID.intern("<");
    public static final RubyID leID = RubyID.intern("<=");
    public static final RubyID gtID = RubyID.intern(">");
    public static final RubyID geID = RubyID.intern(">=");
    public static final RubyID unequalID = RubyID.intern("<=>");
    public static final RubyID longEqualID = RubyID.intern("===");
    public static final RubyID equalID = RubyID.intern("==");
    public static final RubyID matchID = RubyID.intern("=~");
    public static final RubyID subID = RubyID.intern("-");
    public static final RubyID plusID = RubyID.intern("+");
    public static final RubyID mulID = RubyID.intern("*");
    public static final RubyID divID = RubyID.intern("/");
    public static final RubyID modID = RubyID.intern("%");
    public static final RubyID powID = RubyID.intern("**");
    public static final RubyID quoID = RubyID.intern("quo");
    public static final RubyID toFID = RubyID.intern("to_f");
    public static final RubyID toIID = RubyID.intern("to_i");
    public static final RubyID toSID = RubyID.intern("to_s");
    public static final RubyID toStrID = RubyID.intern("to_str");
    public static final RubyID toIntID = RubyID.intern("to_int");
    public static final RubyID toAryID = RubyID.intern("to_ary");
    public static final RubyID methodAddedID = RubyID.intern("method_added");
    public static final RubyID methodMissingId = RubyID.intern("method_missing");
    public static final RubyID extendObjectID = RubyID.intern("extend_object");
    public static final RubyID RESPOND_TO_P = RubyID.intern("respond_to?");
    public static final RubyID writeID = RubyID.intern("write");
    public static final RubyID lengthID = RubyID.intern("length");
    public static final RubyID eachID = RubyID.intern("each");
    public static final RubyID inspectID = RubyID.intern("inspect");
    public static final RubyID initializeId = RubyID.intern("initialize");
    public static final RubyID inheritedID = RubyID.intern("inherited");
    public static final RubyID coerceID = RubyID.intern("coerce");
    public static final RubyID succID = RubyID.intern("succ");
    public static final RubyID hashID = RubyID.intern("hash");
    public static final RubyID joinID = RubyID.intern("join");
    public static final RubyID append_featuresID = RubyID.intern("append_features");
    public static final RubyID includedID = RubyID.intern("included");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyID intern(String name) {
        RubyID id = symbolMap.get(name);
        if (id != null) {
            return id;
        }
        id = RubyID.nextId(name);
        Map<String, RubyID> map = symbolMap;
        synchronized (map) {
            if (symbolMap.get(name) == null) {
                symbolMap.put(name, id);
            }
        }
        return id;
    }

    public static RubyID nextId(String name) {
        return new RubyID(lastId.getAndIncrement(), name);
    }

    private RubyID(long id) {
        this(id, null);
    }

    private RubyID(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public long getId() {
        return this.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String toString() {
        return this.name;
    }

    public RubySymbol toSymbol() {
        if (this.symbol == null) {
            this.symbol = new RubySymbol(this);
        }
        return this.symbol;
    }

    public RubyFixnum toFixnum() {
        return ObjectFactory.createFixnum((int)this.id);
    }

    static String name2Field(String name) {
        if (name.equals("+")) {
            return "plusID";
        }
        if (name.equals("-")) {
            return "subID";
        }
        return null;
    }
}

