/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.lang.MethodBlockBase;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;

public abstract class RubyMethod
extends MethodBlockBase
implements Cloneable {
    private int access_ = 0;
    private RubyID id_;
    public static final int PUBLIC = 0;
    public static final int PROTECTED = 1;
    public static final int PRIVATE = 2;
    public static final int NON_PRIVATE = 3;
    public static final int ALL = 4;

    protected RubyMethod(int argc, boolean has_asterisk_parameter, int default_argc) {
        super(argc, has_asterisk_parameter, default_argc);
    }

    public RubyMethod clone() {
        RubyMethod cl = null;
        try {
            cl = (RubyMethod)this.getClass().newInstance();
            cl.doClone(this);
        }
        catch (Exception e) {
            throw new RubyException(RubyRuntime.ExceptionClass, e.toString());
        }
        return cl;
    }

    protected void doClone(RubyMethod orig) {
        this.access_ = orig.access_;
        this.id_ = orig.id_;
        super.doClone(orig);
    }

    void setID(RubyID id) {
        this.id_ = id;
    }

    @Override
    public RubyID getID() {
        return this.id_;
    }

    public RubyBlock convertToRubyBolck(RubyValue self) {
        final RubyMethod m = this;
        return new RubyBlock(this.argc_, this.has_asterisk_parameter_, this.default_argc_, self, null, null, null, this.getScope(), this, false){

            @Override
            protected RubyValue run(RubyValue receiver, RubyArray args) {
                return m.invoke(receiver, args, null);
            }
        };
    }

    int getAccess() {
        return this.access_;
    }

    public void setAccess(int access) {
        this.access_ = access;
    }

    private void validateArgSize(int args_length) {
        if (0 == this.default_argc_ && !this.has_asterisk_parameter_ && args_length != this.argc_ || 0 != this.default_argc_ && !this.has_asterisk_parameter_ && args_length > this.argc_) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `" + this.id_.toString() + "': wrong number of arguments (" + args_length + " for " + this.argc_ + ")");
        }
        if (args_length < this.argc_ - this.default_argc_) {
            throw new RubyException(RubyRuntime.ArgumentErrorClass, "in `" + this.id_.toString() + "': wrong number of arguments (" + args_length + " for " + (this.argc_ - this.default_argc_) + ")");
        }
    }

    public RubyValue invoke(RubyValue receiver, RubyArray args, RubyBlock block) {
        if (this.argc_ >= 0) {
            int args_length = null != args ? args.size() : 0;
            this.validateArgSize(args_length);
        }
        RubyValue v = this.run(receiver, args, block);
        if (null != block) {
            v.setReturnedInBlock(block.returned(), block.breakedOrReturned(), false);
        } else {
            v.setReturnedInBlock(false, false, false);
        }
        return v;
    }

    protected abstract RubyValue run(RubyValue var1, RubyArray var2, RubyBlock var3);

    public RubyValue invoke(RubyValue receiver, RubyBlock block) {
        if (this.argc_ >= 0) {
            this.validateArgSize(0);
        }
        RubyValue v = this.run(receiver, block);
        if (null != block) {
            v.setReturnedInBlock(block.returned(), block.breakedOrReturned(), false);
        } else {
            v.setReturnedInBlock(false, false, false);
        }
        return v;
    }

    protected RubyValue run(RubyValue receiver, RubyBlock block) {
        return this.run(receiver, (RubyArray)null, block);
    }

    public RubyValue invoke(RubyValue receiver, RubyValue arg, RubyBlock block) {
        if (this.argc_ >= 0) {
            this.validateArgSize(1);
        }
        RubyValue v = this.run(receiver, arg, block);
        if (null != block) {
            v.setReturnedInBlock(block.returned(), block.breakedOrReturned(), false);
        } else {
            v.setReturnedInBlock(false, false, false);
        }
        return v;
    }

    protected RubyValue run(RubyValue receiver, RubyValue arg, RubyBlock block) {
        return this.run(receiver, new RubyArray(arg), block);
    }

    public RubyValue invoke(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block) {
        if (this.argc_ >= 0) {
            this.validateArgSize(2);
        }
        RubyValue v = this.run(receiver, arg0, arg1, block);
        if (null != block) {
            v.setReturnedInBlock(block.returned(), block.breakedOrReturned(), false);
        } else {
            v.setReturnedInBlock(false, false, false);
        }
        return v;
    }

    protected RubyValue run(RubyValue receiver, RubyValue arg0, RubyValue arg1, RubyBlock block) {
        return this.run(receiver, new RubyArray(arg0, arg1), block);
    }
}

