/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyBasic;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelClass;
import java.util.HashMap;
import java.util.Map;

@RubyLevelClass(name="Object", superclass="", modules={"Kernel"})
public class RubyObject
extends RubyBasic {
    private Map<RubyID, RubyValue> instance_varibles_ = null;

    public RubyObject(RubyClass c) {
        super(c);
    }

    public RubyObject() {
    }

    @Override
    public RubyValue clone() {
        RubyObject cl = null;
        try {
            cl = (RubyObject)this.getClass().newInstance();
            cl.doClone(this);
        }
        catch (Exception e) {
            throw new RubyException(RubyRuntime.ExceptionClass, e.toString());
        }
        return cl;
    }

    protected void doClone(RubyObject orig) {
        this.instance_varibles_ = new HashMap<RubyID, RubyValue>(orig.instance_varibles_);
        super.doClone(orig);
    }

    @RubyAllocMethod
    public static RubyValue alloc(RubyValue receiver) {
        return new RubyObject((RubyClass)receiver);
    }

    @Override
    public RubyValue getInstanceVariable(RubyID id) {
        RubyValue v;
        if (this.instance_varibles_ != null && (v = this.instance_varibles_.get(id)) != null) {
            return v;
        }
        return RubyConstant.QNIL;
    }

    @Override
    public RubyValue setInstanceVariable(RubyValue value2, RubyID id) {
        if (null == this.instance_varibles_) {
            this.instance_varibles_ = new HashMap<RubyID, RubyValue>();
        }
        this.instance_varibles_.put(id, value2);
        return value2;
    }

    @Override
    public String inspect() {
        StringBuffer sb = new StringBuffer();
        sb.append("#<");
        sb.append(this.getRubyClass().getRealClass().getName());
        sb.append(":0x");
        sb.append(Integer.toHexString(this.hashCode()));
        String sep = "";
        Map<RubyID, RubyValue> vars = this.instance_varibles_;
        if (vars != null) {
            for (RubyID id : vars.keySet()) {
                sb.append(sep);
                sb.append(" ");
                sb.append(id.toString());
                sb.append("=");
                RubyValue inspectValue = RubyAPI.callPublicNoArgMethod(vars.get(id), null, RubyID.inspectID);
                sb.append(inspectValue.toStr());
                sep = ",";
            }
        }
        sb.append(">");
        return sb.toString();
    }
}

