/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang;

import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.builtin.RubyFloat;
import com.xruby.runtime.builtin.RubyInteger;
import com.xruby.runtime.builtin.RubyString;
import com.xruby.runtime.lang.BlockCallStatus;
import com.xruby.runtime.lang.RubyAPI;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyConstant;
import com.xruby.runtime.lang.RubyException;
import com.xruby.runtime.lang.RubyID;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyRuntime;
import com.xruby.runtime.lang.RubySingletonClass;
import java.util.HashMap;
import java.util.Map;

public abstract class RubyValue
extends BlockCallStatus
implements Cloneable {
    private boolean frozen_ = false;
    private boolean taint_ = false;
    private static Map<RubyValue, Map<RubyID, RubyValue>> genericIvTbl;

    public abstract void setRubyClass(RubyClass var1);

    public abstract RubyClass getRubyClass();

    public RubyValue clone() {
        RubyValue v;
        try {
            v = (RubyValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RubyException(RubyRuntime.ExceptionClass, e.toString());
        }
        return v;
    }

    protected void doClone(RubyValue orig) {
        this.frozen_ = orig.frozen_;
        this.taint_ = orig.taint_;
        super.doClone(orig);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RubyValue) {
            return RubyAPI.callPublicOneArgMethod(this, (RubyValue)o, null, RubyID.equalID).isTrue();
        }
        return false;
    }

    public boolean frozen() {
        return this.frozen_;
    }

    public void freeze() {
        this.frozen_ = true;
    }

    public boolean tainted() {
        return this.taint_;
    }

    public void taint() {
        this.taint_ = true;
    }

    public RubyValue getInstanceVariable(RubyID id) {
        RubyValue v;
        Map<RubyID, RubyValue> table;
        if (genericIvTbl != null && (table = genericIvTbl.get(this)) != null && (v = table.get(id)) != null) {
            return v;
        }
        return RubyConstant.QNIL;
    }

    public RubyValue setInstanceVariable(RubyValue value2, RubyID id) {
        Map<RubyID, RubyValue> table;
        if (genericIvTbl == null) {
            genericIvTbl = new HashMap<RubyValue, Map<RubyID, RubyValue>>();
        }
        if ((table = genericIvTbl.get(this)) == null) {
            table = new HashMap<RubyID, RubyValue>();
            genericIvTbl.put(this, table);
        }
        table.put(id, value2);
        return value2;
    }

    public RubyClass getSingletonClass() {
        return this.getSingletonClass(null);
    }

    public RubyClass getSingletonClass(RubyModule scope) {
        RubyClass klass = this.getRubyClass();
        if (klass.isSingleton() && klass.getInstanceVariable(RubyID.attachedID) == this) {
            klass.setScope(scope);
            klass.setAccessPublic();
            return klass;
        }
        return new RubySingletonClass(this, this.getRubyClass(), scope);
    }

    public boolean respondTo(RubyID id) {
        RubyClass klass = this.getRubyClass();
        if (klass.findMethod(RubyID.RESPOND_TO_P) == RubyRuntime.getRespondMethod()) {
            return klass.isMethodBound(id, false);
        }
        return RubyAPI.callOneArgMethod(this, id.toSymbol(), null, RubyID.RESPOND_TO_P).isTrue();
    }

    public boolean isTrue() {
        return true;
    }

    public boolean isKindOf(RubyModule m) {
        return m.isKindOf(this.getRubyClass());
    }

    public String toString() {
        return this.getRubyClass().getName() + super.toString();
    }

    public String inspect() {
        return RubyAPI.callNoArgMethod(this, null, RubyID.toSID).toStr();
    }

    public RubyID toID() {
        throw new RubyException(RubyRuntime.TypeErrorClass, this.inspect() + " is not a symbol");
    }

    public int toInt() {
        return this.convertToInteger().toInt();
    }

    public long toLong() {
        return this.convertToInteger().toLong();
    }

    public RubyArray toAry() {
        return this.contertToArray().toAry();
    }

    public double toFloat() {
        return this.convertToFloat().toFloat();
    }

    public String toStr() {
        return this.convertToString().toStr();
    }

    public String asString() {
        RubyValue value2 = RubyAPI.callPublicNoArgMethod(this, null, RubyID.toSID);
        if (value2 instanceof RubyString) {
            return value2.toStr();
        }
        return "#<" + this.getRubyClass().getName() + ":0x" + Integer.toHexString(this.hashCode()) + "x>";
    }

    public RubyInteger toRubyInteger() {
        return this.convertToInteger().toRubyInteger();
    }

    public RubyFloat toRubyFloat() {
        return this.convertToFloat().toRubyFloat();
    }

    public RubyString toRubyString() {
        return this.convertToString().toRubyString();
    }

    private RubyValue convertToInteger() {
        return this.convertToType(RubyRuntime.IntegerClass, RubyID.toIntID);
    }

    private RubyValue contertToArray() {
        return this.convertToType(RubyRuntime.ArrayClass, RubyID.toAryID);
    }

    private RubyValue convertToFloat() {
        return this.convertToType(RubyRuntime.FloatClass, RubyID.toFID);
    }

    private RubyValue convertToString() {
        return this.convertToType(RubyRuntime.StringClass, RubyID.toStrID);
    }

    private RubyValue convertToType(RubyClass klass, RubyID id) {
        if (this.isKindOf(klass)) {
            return this;
        }
        if (!this.respondTo(id)) {
            throw new RubyException("can't convert " + this.getRubyClass().getName() + " into " + klass.getName());
        }
        RubyValue v = RubyAPI.callNoArgMethod(this, null, id);
        if (!v.isKindOf(klass)) {
            throw new RubyException(this.getRubyClass().getName() + "#" + id.toString() + " should return " + klass.getName());
        }
        return v;
    }

    public RubyMethod findPublicMethod(RubyID mid) {
        return this.getRubyClass().findOwnPublicMethod(mid);
    }

    public RubyMethod findMethod(RubyID mid) {
        return this.getRubyClass().findOwnMethod(mid);
    }
}

