/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.runtime.lang.util;

import com.xruby.compiler.XRubyClassLoader;
import com.xruby.compiler.codegen.CgUtil;
import com.xruby.compiler.codegen.ClassDumper;
import com.xruby.compiler.codegen.Types;
import com.xruby.runtime.builtin.RubyArray;
import com.xruby.runtime.lang.RubyBlock;
import com.xruby.runtime.lang.RubyClass;
import com.xruby.runtime.lang.RubyMethod;
import com.xruby.runtime.lang.RubyModule;
import com.xruby.runtime.lang.RubyObject;
import com.xruby.runtime.lang.RubyValue;
import com.xruby.runtime.lang.annotation.RubyAllocMethod;
import com.xruby.runtime.lang.annotation.RubyLevelConstant;
import com.xruby.runtime.lang.annotation.RubyLevelMethod;
import com.xruby.runtime.lang.util.CgMethodItem;
import com.xruby.runtime.lang.util.MethodFactory;
import com.xruby.runtime.lang.util.MethodType;
import com.xruby.runtime.lang.util.RubyClassBuilder;
import com.xruby.runtime.lang.util.RubyClassFactory;
import com.xruby.runtime.lang.util.RubyModuleBuilder;
import com.xruby.runtime.lang.util.RubyModuleFactory;
import com.xruby.runtime.lang.util.RubyObjectBuilder;
import com.xruby.runtime.lang.util.RubyObjectFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.util.CheckClassAdapter;

public abstract class RubyTypeFactory {
    private static final Type methodFactoryType = Type.getType(MethodFactory.class);
    private static final XRubyClassLoader cl = new XRubyClassLoader();
    private static ClassDumper dupmer = new ClassDumper();
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    private Class klass;
    private ClassWriter cw;
    private ClassVisitor cv;
    private static final Method RubyModuleDefinePrivateMethodMethod = CgUtil.getMethod("definePrivateMethod", Types.RUBY_VALUE_TYPE, Type.getType(String.class), Types.RUBY_METHOD_TYPE);
    private static final Method RubyModuleDefineMethodMethod = CgUtil.getMethod("defineMethod", Types.RUBY_VALUE_TYPE, Type.getType(String.class), Types.RUBY_METHOD_TYPE);
    private static final Method RubyModuleDefineModuleMethodMethod = CgUtil.getMethod("defineModuleMethod", Type.VOID_TYPE, Type.getType(String.class), Types.RUBY_METHOD_TYPE);
    private static final Method RubyValueGetSingletonClass = CgUtil.getMethod("getSingletonClass", Types.RUBY_CLASS_TYPE);
    private static final Method RubyModuleAliasMethod = CgUtil.getMethod("aliasMethod", Type.VOID_TYPE, Type.getType(String.class), Type.getType(String.class));
    private static final Method MethodFactoryGetMethodMethod = CgUtil.getMethod("getMethod", Types.RUBY_METHOD_TYPE, Type.getType(String.class), Type.getType(MethodType.class), Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE);
    private static final Method MethodFactoryCreateMethodFactory = CgUtil.getMethod("createMethodFactory", methodFactoryType, Type.getType(Class.class), Type.BOOLEAN_TYPE);

    public static RubyClass getClass(Class klass) {
        Class loadClass = new RubyClassFactory(klass).loadClass();
        if (loadClass == null) {
            return null;
        }
        return RubyTypeFactory.loadRubyClassBuilder(loadClass).createRubyClass();
    }

    private static RubyClassBuilder loadRubyClassBuilder(Class loadClass) {
        try {
            return (RubyClassBuilder)loadClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("fail to create Ruby class", ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("fail to create Ruby class", iae);
        }
    }

    public static RubyModule getModule(Class klass) {
        Class loadClass = new RubyModuleFactory(klass).loadClass();
        if (loadClass == null) {
            return null;
        }
        return RubyTypeFactory.loadRubyModuleBuilder(loadClass).createRubyModule();
    }

    private static RubyModuleBuilder loadRubyModuleBuilder(Class loadClass) {
        try {
            return (RubyModuleBuilder)loadClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("fail to create Ruby module", ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("fail to create Ruby module", iae);
        }
    }

    public static RubyObject getObject(Class klass) {
        Class loadClass = new RubyObjectFactory(klass).loadClass();
        if (loadClass == null) {
            return null;
        }
        return RubyTypeFactory.loadRubyObjectBuilder(loadClass).createRubyObject();
    }

    private static RubyObjectBuilder loadRubyObjectBuilder(Class loadClass) {
        try {
            return (RubyObjectBuilder)loadClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new RuntimeException("fail to create Ruby object", ie);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("fail to create Ruby object", iae);
        }
    }

    protected static void loadRubyClass(GeneratorAdapter mg, String superclass2) {
        if (superclass2 == null || superclass2.length() == 0) {
            mg.push((String)null);
        }
        if (Types.isBuiltinClass(superclass2)) {
            mg.getStatic(Types.RUBY_RUNTIME_TYPE, superclass2 + "Class", Types.RUBY_CLASS_TYPE);
        }
    }

    Class loadClass() {
        String name = this.getBuilderName(this.klass);
        Class klass = this.tryClass(name);
        if (klass == null) {
            return this.createClass(name);
        }
        return klass;
    }

    private Class createClass(String name) {
        Object annotation = this.klass.getAnnotation(this.getTypeAnnotationClass());
        if (annotation == null) {
            throw new RuntimeException("no annotation class:" + this.klass);
        }
        this.startBuilder(name);
        this.createBuilderMethod((Annotation)annotation);
        this.endClassBuilder();
        return this.loadBuidlerClass(name);
    }

    private Class loadBuidlerClass(String name) {
        byte[] content = this.cw.toByteArray();
        dupmer.dump(name, content);
        return cl.load(name, content);
    }

    private Class tryClass(String name) {
        try {
            return cl.load(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    RubyTypeFactory(Class klass) {
        this.klass = klass;
        this.cw = new ClassWriter(1);
        this.cv = new CheckClassAdapter(this.cw);
    }

    protected abstract Class getTypeAnnotationClass();

    protected abstract String getBuilderName(Class var1);

    protected abstract Type getInterface();

    protected abstract Method getBuilderMethod();

    protected abstract int createRubyType(GeneratorAdapter var1, Annotation var2);

    protected abstract boolean isModule();

    private void startBuilder(String name) {
        this.cv.visit(49, 1, name, null, OBJECT_TYPE.getInternalName(), new String[]{this.getInterface().getInternalName()});
        CgUtil.createImplicitConstructor(this.cv, OBJECT_TYPE);
    }

    private GeneratorAdapter startBuilderMethod() {
        GeneratorAdapter mg = new GeneratorAdapter(1, this.getBuilderMethod(), null, null, this.cv);
        mg.visitCode();
        return mg;
    }

    private void endClassBuilder() {
        this.cv.visitEnd();
    }

    private void createBuilderMethod(Annotation annotation) {
        GeneratorAdapter mg = this.startBuilderMethod();
        int rubyTypeIdx = this.createRubyType(mg, annotation);
        this.generateMethod(mg, rubyTypeIdx);
        this.generateConstant(mg, rubyTypeIdx);
        mg.loadLocal(rubyTypeIdx);
        mg.returnValue();
        mg.endMethod();
    }

    private void generateConstant(GeneratorAdapter mg, int rubyTypeIdx) {
        for (Field field : this.klass.getFields()) {
            RubyLevelConstant rawFieldAnnotation;
            int modifier = field.getModifiers();
            if (!Modifier.isStatic(modifier) && !Modifier.isPublic(modifier) || (rawFieldAnnotation = field.getAnnotation(RubyLevelConstant.class)) == null) continue;
            this.defineRubyConstant(mg, field, rawFieldAnnotation, rubyTypeIdx);
        }
    }

    private void defineRubyConstant(GeneratorAdapter mg, Field field, RubyLevelConstant constant, int rubyTypeIdx) {
        mg.loadLocal(rubyTypeIdx);
        mg.push(constant.name());
        mg.getStatic(Type.getType(this.klass), field.getName(), Type.getType(field.getType()));
        mg.invokeVirtual(Types.RUBY_MODULE_TYPE, CgUtil.getMethod("setConstant", Types.RUBY_VALUE_TYPE, Type.getType(String.class), Types.RUBY_VALUE_TYPE));
    }

    private void generateMethod(GeneratorAdapter mg, int rubyTypeIdx) {
        RubyLevelMethod rawMethodAnnotation;
        int factoryIdx = this.createLocalMethodFactory(mg);
        HashMap<String, CgMethodItem> methodMap = new HashMap<String, CgMethodItem>();
        CgMethodItem allocItem = null;
        for (java.lang.reflect.Method method : this.klass.getMethods()) {
            CgMethodItem item;
            if (method.getDeclaringClass() != this.klass) continue;
            rawMethodAnnotation = method.getAnnotation(RubyLevelMethod.class);
            if (rawMethodAnnotation != null) {
                CgMethodItem newItem = this.createMethodItem(rawMethodAnnotation, method);
                item = (CgMethodItem)methodMap.get(this.getItemName(newItem));
                if (item != null) {
                    item.type = MethodType.valueOf(item.type.value() | newItem.type.value());
                    continue;
                }
                methodMap.put(this.getItemName(newItem), newItem);
                continue;
            }
            RubyAllocMethod allocMethodAnnotation = method.getAnnotation(RubyAllocMethod.class);
            if (allocMethodAnnotation == null) continue;
            item = this.createAllocItem(allocMethodAnnotation, method);
            if (allocItem != null) {
                allocItem.type = MethodType.valueOf(allocItem.type.value() | item.type.value());
                continue;
            }
            allocItem = this.createAllocItem(allocMethodAnnotation, method);
        }
        for (CgMethodItem item : methodMap.values()) {
            this.defineRubyMethod(mg, rubyTypeIdx, factoryIdx, item);
        }
        if (allocItem != null) {
            this.defineAllocMethod(mg, rubyTypeIdx, factoryIdx, allocItem);
        }
        for (GenericDeclaration genericDeclaration : this.klass.getClasses()) {
            rawMethodAnnotation = ((Class)genericDeclaration).getAnnotation(RubyLevelMethod.class);
            if (rawMethodAnnotation == null) continue;
            if (!RubyMethod.class.isAssignableFrom((Class<?>)genericDeclaration)) {
                throw new RuntimeException(((Class)genericDeclaration).getName() + " should be subclasss of RubyMethod");
            }
            CgMethodItem item = this.createMethodItem(rawMethodAnnotation, (Class)genericDeclaration);
            this.defineRubyMethodWithClass(mg, rubyTypeIdx, factoryIdx, (Class)genericDeclaration, item);
        }
    }

    private void defineRubyMethodWithClass(GeneratorAdapter mg, int rubyTypeIdx, int factoryIdx, Class innerClass, CgMethodItem item) {
        this.loadRubyType(mg, rubyTypeIdx, item);
        mg.push(item.name);
        Type type = Type.getType(innerClass);
        mg.newInstance(type);
        mg.dup();
        mg.invokeConstructor(type, CgUtil.CONSTRUCTOR);
        this.defineMethod(mg, item);
        this.defineAlias(mg, factoryIdx, rubyTypeIdx, item);
    }

    private String getItemName(CgMethodItem item) {
        return item.singleton ? item.name + "Single" : item.name;
    }

    private CgMethodItem createMethodItem(RubyLevelMethod annotation, Class klass) {
        CgMethodItem item = new CgMethodItem();
        item.javaName = klass.getName();
        this.makeGenneralItem(annotation, item);
        return item;
    }

    private CgMethodItem createMethodItem(RubyLevelMethod annotation, java.lang.reflect.Method method) {
        CgMethodItem item = this.makeMethodItemPros(method);
        item.javaName = method.getName();
        this.makeGenneralItem(annotation, item);
        return item;
    }

    private void makeGenneralItem(RubyLevelMethod annotation, CgMethodItem item) {
        item.name = annotation.name();
        item.alias = annotation.alias();
        if (annotation.singleton()) {
            item.singleton = true;
        }
        if (annotation.module()) {
            item.moduleMethod = true;
        }
        if (annotation.privateMethod()) {
            item.privateMethod = true;
        }
    }

    private CgMethodItem createAllocItem(RubyAllocMethod annotation, java.lang.reflect.Method method) {
        CgMethodItem item = this.makeMethodItemPros(method);
        item.name = null;
        item.javaName = method.getName();
        item.alias = null;
        return item;
    }

    private CgMethodItem makeMethodItemPros(java.lang.reflect.Method method) {
        CgMethodItem item = new CgMethodItem();
        item.singleton = false;
        Class[] paramTypes = method.getParameterTypes();
        int start2 = 0;
        int end = paramTypes.length - 1;
        if (Modifier.isStatic(method.getModifiers())) {
            if (paramTypes[0] != RubyValue.class) {
                throw new IllegalArgumentException("unknown Ruby method specification:" + method);
            }
            if (!this.isModule()) {
                item.singleton = true;
            }
            ++start2;
        }
        item.block = false;
        if (paramTypes.length > 0 && paramTypes[paramTypes.length - 1] == RubyBlock.class) {
            item.block = true;
            --end;
        }
        item.type = this.getMethodType(paramTypes, start2, end);
        if (item.type == MethodType.UNKNOWN) {
            throw new IllegalArgumentException("unknown Ruby method specification:" + method);
        }
        return item;
    }

    private MethodType getMethodType(Class[] paramTypes, int start2, int end) {
        int argSize = end - start2;
        if (argSize < 0) {
            return MethodType.NO_ARG;
        }
        if (argSize == 0) {
            if (paramTypes[start2] == RubyValue.class) {
                return MethodType.ONE_ARG;
            }
            if (paramTypes[start2] == RubyArray.class) {
                return MethodType.VAR_ARG;
            }
        } else if (argSize == 1 && paramTypes[start2] == RubyValue.class && paramTypes[end] == RubyValue.class) {
            return MethodType.TWO_ARG;
        }
        return MethodType.UNKNOWN;
    }

    private void defineAllocMethod(GeneratorAdapter mg, int rubyTypeIdx, int factoryIdx, CgMethodItem item) {
        mg.loadLocal(rubyTypeIdx);
        mg.loadLocal(factoryIdx);
        this.getMethod(mg, item.javaName, item.type, true, item.block);
        mg.invokeVirtual(Types.RUBY_CLASS_TYPE, CgUtil.getMethod("defineAllocMethod", Type.VOID_TYPE, Types.RUBY_METHOD_TYPE));
    }

    private int createLocalMethodFactory(GeneratorAdapter mg) {
        this.createMehtodFactory(mg, this.klass);
        int factoryIdx = mg.newLocal(methodFactoryType);
        mg.storeLocal(factoryIdx);
        return factoryIdx;
    }

    private void loadRubyType(GeneratorAdapter mg, int rubyTypeIdx, CgMethodItem item) {
        mg.loadLocal(rubyTypeIdx);
        if (item.singleton) {
            mg.invokeVirtual(Types.RUBY_VALUE_TYPE, CgUtil.getMethod("getSingletonClass", Types.RUBY_CLASS_TYPE));
        }
    }

    private void defineRubyMethod(GeneratorAdapter mg, int rubyTypeIdx, int factoryIdx, CgMethodItem item) {
        this.loadRubyType(mg, rubyTypeIdx, item);
        String rubyName = item.name;
        this.defineMethod(mg, factoryIdx, rubyName, item);
        this.defineAlias(mg, factoryIdx, rubyTypeIdx, item);
    }

    private void defineMethod(GeneratorAdapter mg, int factoryIdx, String rubyName, CgMethodItem item) {
        mg.push(rubyName);
        mg.loadLocal(factoryIdx);
        this.getMethod(mg, item);
        this.defineMethod(mg, item);
    }

    private void defineMethod(GeneratorAdapter mg, CgMethodItem item) {
        if (item.moduleMethod) {
            mg.invokeVirtual(Types.RUBY_MODULE_TYPE, RubyModuleDefineModuleMethodMethod);
        } else if (item.privateMethod) {
            mg.invokeVirtual(Types.RUBY_MODULE_TYPE, RubyModuleDefinePrivateMethodMethod);
        } else {
            mg.invokeVirtual(Types.RUBY_MODULE_TYPE, RubyModuleDefineMethodMethod);
        }
    }

    private void defineAlias(GeneratorAdapter mg, int factoryIdx, int rubyTypeIdx, CgMethodItem item) {
        String oldName = item.name;
        String[] aliases = item.alias;
        boolean singleton = item.singleton;
        for (String alias : aliases) {
            mg.loadLocal(rubyTypeIdx);
            if (singleton) {
                mg.invokeVirtual(Types.RUBY_MODULE_TYPE, RubyValueGetSingletonClass);
            }
            if (item.moduleMethod) {
                this.defineMethod(mg, factoryIdx, alias, item);
                continue;
            }
            mg.push(alias);
            mg.push(oldName);
            mg.invokeVirtual(Types.RUBY_MODULE_TYPE, RubyModuleAliasMethod);
        }
    }

    private void getMethod(GeneratorAdapter mg, CgMethodItem item) {
        this.getMethod(mg, item.javaName, item.type, item.singleton, item.block);
    }

    private void getMethod(GeneratorAdapter mg, String methodName, MethodType type, boolean singleton, boolean block) {
        mg.push(methodName);
        type.generateMethodType(mg);
        mg.push(singleton);
        mg.push(block);
        mg.invokeVirtual(methodFactoryType, MethodFactoryGetMethodMethod);
    }

    private void createMehtodFactory(GeneratorAdapter mg, Class klass) {
        mg.push(Type.getType(klass));
        mg.push(this.isModule());
        mg.invokeStatic(methodFactoryType, MethodFactoryCreateMethodFactory);
    }
}

