/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceFieldVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.objectweb.asm.util.TraceSignatureVisitor;

public class TraceClassVisitor
extends TraceAbstractVisitor
implements ClassVisitor {
    protected final ClassVisitor cv;
    protected final PrintWriter pw;

    public static void main(String[] stringArray) throws Exception {
        int n = 0;
        int n2 = 2;
        boolean bl = true;
        if (stringArray.length < 1 || stringArray.length > 2) {
            bl = false;
        }
        if (bl && stringArray[0].equals("-debug")) {
            n = 1;
            n2 = 0;
            if (stringArray.length != 2) {
                bl = false;
            }
        }
        if (!bl) {
            System.err.println("Prints a disassembled view of the given class.");
            System.err.println("Usage: TraceClassVisitor [-debug] <fully qualified class name or class file name>");
            return;
        }
        ClassReader classReader = stringArray[n].endsWith(".class") || stringArray[n].indexOf(92) > -1 || stringArray[n].indexOf(47) > -1 ? new ClassReader(new FileInputStream(stringArray[n])) : new ClassReader(stringArray[n]);
        classReader.accept(new TraceClassVisitor(new PrintWriter(System.out)), TraceClassVisitor.getDefaultAttributes(), n2);
    }

    public TraceClassVisitor(PrintWriter printWriter) {
        this(null, printWriter);
    }

    public TraceClassVisitor(ClassVisitor classVisitor, PrintWriter printWriter) {
        this.cv = classVisitor;
        this.pw = printWriter;
    }

    public void visit(int n, int n2, String string2, String string3, String string4, String[] stringArray) {
        int n3 = n & 0xFFFF;
        int n4 = n >>> 16;
        this.buf.setLength(0);
        this.buf.append("// class version ").append(n3).append('.').append(n4).append(" (").append(n).append(")\n");
        if ((n2 & 0x20000) != 0) {
            this.buf.append("// DEPRECATED\n");
        }
        this.buf.append("// access flags ").append(n2).append('\n');
        this.appendDescriptor(5, string3);
        if (string3 != null) {
            TraceSignatureVisitor traceSignatureVisitor = new TraceSignatureVisitor(n2);
            SignatureReader signatureReader = new SignatureReader(string3);
            signatureReader.accept(traceSignatureVisitor);
            this.buf.append("// declaration: ").append(string2).append(traceSignatureVisitor.getDeclaration()).append('\n');
        }
        this.appendAccess(n2 & 0xFFFFFFDF);
        if ((n2 & 0x2000) != 0) {
            this.buf.append("@interface ");
        } else if ((n2 & 0x200) != 0) {
            this.buf.append("interface ");
        } else if ((n2 & 0x4000) == 0) {
            this.buf.append("class ");
        }
        this.appendDescriptor(0, string2);
        if (string4 != null && !string4.equals("java/lang/Object")) {
            this.buf.append(" extends ");
            this.appendDescriptor(0, string4);
            this.buf.append(' ');
        }
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" implements ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendDescriptor(0, stringArray[i]);
                this.buf.append(' ');
            }
        }
        this.buf.append(" {\n\n");
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visit(n, n2, string2, string3, string4, stringArray);
        }
    }

    public void visitSource(String string2, String string3) {
        this.buf.setLength(0);
        if (string2 != null) {
            this.buf.append(this.tab).append("// compiled from: ").append(string2).append('\n');
        }
        if (string3 != null) {
            this.buf.append(this.tab).append("// debug info: ").append(string3).append('\n');
        }
        if (this.buf.length() > 0) {
            this.text.add(this.buf.toString());
        }
        if (this.cv != null) {
            this.cv.visitSource(string2, string3);
        }
    }

    public void visitOuterClass(String string2, String string3, String string4) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("OUTERCLASS ");
        this.appendDescriptor(0, string2);
        this.buf.append(' ');
        if (string3 != null) {
            this.buf.append(string3).append(' ');
        }
        this.appendDescriptor(3, string4);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitOuterClass(string2, string3, string4);
        }
    }

    public AnnotationVisitor visitAnnotation(String string2, boolean bl) {
        this.text.add("\n");
        AnnotationVisitor annotationVisitor = super.visitAnnotation(string2, bl);
        if (this.cv != null) {
            ((TraceAnnotationVisitor)annotationVisitor).av = this.cv.visitAnnotation(string2, bl);
        }
        return annotationVisitor;
    }

    public void visitAttribute(Attribute attribute) {
        this.text.add("\n");
        super.visitAttribute(attribute);
        if (this.cv != null) {
            this.cv.visitAttribute(attribute);
        }
    }

    public void visitInnerClass(String string2, String string3, String string4, int n) {
        this.buf.setLength(0);
        this.buf.append(this.tab).append("// access flags ");
        this.buf.append(n & 0xFFFFFFDF).append('\n');
        this.buf.append(this.tab);
        this.appendAccess(n);
        this.buf.append("INNERCLASS ");
        this.appendDescriptor(0, string2);
        this.buf.append(' ');
        this.appendDescriptor(0, string3);
        this.buf.append(' ');
        this.appendDescriptor(0, string4);
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        if (this.cv != null) {
            this.cv.visitInnerClass(string2, string3, string4, n);
        }
    }

    public FieldVisitor visitField(int n, String string2, String string3, String string4, Object object) {
        Object object2;
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags ").append(n).append('\n');
        if (string4 != null) {
            this.buf.append(this.tab);
            this.appendDescriptor(2, string4);
            object2 = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string4);
            signatureReader.acceptType((SignatureVisitor)object2);
            this.buf.append(this.tab).append("// declaration: ").append(((TraceSignatureVisitor)object2).getDeclaration()).append('\n');
        }
        this.buf.append(this.tab);
        this.appendAccess(n);
        this.appendDescriptor(1, string3);
        this.buf.append(' ').append(string2);
        if (object != null) {
            this.buf.append(" = ");
            if (object instanceof String) {
                this.buf.append("\"").append(object).append("\"");
            } else {
                this.buf.append(object);
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        object2 = this.createTraceFieldVisitor();
        this.text.add(((AbstractVisitor)object2).getText());
        if (this.cv != null) {
            ((TraceFieldVisitor)object2).fv = this.cv.visitField(n, string2, string3, string4, object);
        }
        return object2;
    }

    public MethodVisitor visitMethod(int n, String string2, String string3, String string4, String[] stringArray) {
        Object object;
        this.buf.setLength(0);
        this.buf.append('\n');
        if ((n & 0x20000) != 0) {
            this.buf.append(this.tab).append("// DEPRECATED\n");
        }
        this.buf.append(this.tab).append("// access flags ").append(n).append('\n');
        if (string4 != null) {
            this.buf.append(this.tab);
            this.appendDescriptor(4, string4);
            object = new TraceSignatureVisitor(0);
            SignatureReader signatureReader = new SignatureReader(string4);
            signatureReader.accept((SignatureVisitor)object);
            String string5 = ((TraceSignatureVisitor)object).getDeclaration();
            String string6 = ((TraceSignatureVisitor)object).getReturnType();
            String string7 = ((TraceSignatureVisitor)object).getExceptions();
            this.buf.append(this.tab).append("// declaration: ").append(string6).append(' ').append(string2).append(string5);
            if (string7 != null) {
                this.buf.append(" throws ").append(string7);
            }
            this.buf.append('\n');
        }
        this.buf.append(this.tab);
        this.appendAccess(n);
        if ((n & 0x100) != 0) {
            this.buf.append("native ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("varargs ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("bridge ");
        }
        this.buf.append(string2);
        this.appendDescriptor(3, string3);
        if (stringArray != null && stringArray.length > 0) {
            this.buf.append(" throws ");
            for (int i = 0; i < stringArray.length; ++i) {
                this.appendDescriptor(0, stringArray[i]);
                this.buf.append(' ');
            }
        }
        this.buf.append('\n');
        this.text.add(this.buf.toString());
        object = this.createTraceMethodVisitor();
        this.text.add(((AbstractVisitor)object).getText());
        if (this.cv != null) {
            ((TraceMethodVisitor)object).mv = this.cv.visitMethod(n, string2, string3, string4, stringArray);
        }
        return object;
    }

    public void visitEnd() {
        this.text.add("}\n");
        this.print(this.pw);
        this.pw.flush();
        if (this.cv != null) {
            this.cv.visitEnd();
        }
    }

    protected TraceFieldVisitor createTraceFieldVisitor() {
        return new TraceFieldVisitor();
    }

    protected TraceMethodVisitor createTraceMethodVisitor() {
        return new TraceMethodVisitor();
    }

    private void appendAccess(int n) {
        if ((n & 1) != 0) {
            this.buf.append("public ");
        }
        if ((n & 2) != 0) {
            this.buf.append("private ");
        }
        if ((n & 4) != 0) {
            this.buf.append("protected ");
        }
        if ((n & 0x10) != 0) {
            this.buf.append("final ");
        }
        if ((n & 8) != 0) {
            this.buf.append("static ");
        }
        if ((n & 0x20) != 0) {
            this.buf.append("synchronized ");
        }
        if ((n & 0x40) != 0) {
            this.buf.append("volatile ");
        }
        if ((n & 0x80) != 0) {
            this.buf.append("transient ");
        }
        if ((n & 0x400) != 0) {
            this.buf.append("abstract ");
        }
        if ((n & 0x800) != 0) {
            this.buf.append("strictfp ");
        }
        if ((n & 0x4000) != 0) {
            this.buf.append("enum ");
        }
    }
}

