/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DepHandler;
import com.tonicsystems.jarjar.DependencyVisitor;
import com.tonicsystems.jarjar.PathClass;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.asm.commons.EmptyVisitor;
import com.tonicsystems.jarjar.ext_util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.zip.ZipFile;

class DepFindVisitor
extends DependencyVisitor {
    private Map classes;
    private String source;
    private DepHandler handler;
    private PathClass curPathClass;

    public DepFindVisitor(Map classes, Object source, DepHandler handler) throws IOException {
        super(new EmptyVisitor());
        this.classes = classes;
        this.source = this.getSourceName(source);
        this.handler = handler;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.curPathClass = new PathClass(this.source, name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    protected String fixDesc(String desc) {
        int index = desc.indexOf(76);
        if (index >= 0) {
            this.fixName(desc.substring(index + 1, desc.length() - 1));
        }
        return desc;
    }

    protected String fixMethodDesc(String desc) {
        this.fixDesc(Type.getReturnType(desc).getDescriptor());
        Type[] args = Type.getArgumentTypes(desc);
        for (int i = 0; i < args.length; ++i) {
            this.fixDesc(args[i].getDescriptor());
        }
        return desc;
    }

    protected String fixName(String name) {
        try {
            String otherSource;
            if (this.classes.containsKey(name) && !this.source.equals(otherSource = this.getSourceName(this.classes.get(name)))) {
                this.handler.handle(this.curPathClass, new PathClass(otherSource, name));
            }
            return name;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private String getSourceName(Object source) throws IOException {
        if (source instanceof ZipFile) {
            return ((ZipFile)source).getName();
        }
        return ((File)source).getCanonicalPath();
    }

    protected String fixString(String className, String value) {
        return value;
    }

    protected Attribute fixAttribute(Attribute attrs) {
        return attrs;
    }
}

