/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhoconnect;

import com.rhomobile.rhoconnect.RhoConnectNotify;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RhomModel {
    public static final int MODEL_TYPE_PROPERTY_BAG = 0;
    public static final int MODEL_TYPE_FIXED_SCHEMA = 1;
    public static final int SYNC_TYPE_NONE = 0;
    public static final int SYNC_TYPE_INCREMENTAL = 1;
    public static final int SYNC_TYPE_BULK_ONLY = 2;
    private String mName;
    private int mModelType;
    private int mSyncType;
    private int mSyncPriority;
    private String mPartition;
    private Map<String, Boolean> mBlobAttribs = new TreeMap<String, Boolean>();
    private Map<String, String> mAssociations = new TreeMap<String, String>();

    private native void init();

    private static native RhoConnectNotify syncByName(String var0);

    private static native Map<String, String> findByName(String var0, String var1);

    private static native Map<String, String> findFirstByName(String var0, String[] var1, String[] var2);

    private static native Collection<Map<String, String>> findAllByName(String var0, String[] var1, String[] var2);

    private static native Collection<Map<String, String>> findBySqlByName(String var0, String var1, String[] var2);

    private static native Map<String, String> createByName(String var0, String[] var1, String[] var2);

    private static native void saveByName(String var0, String[] var1, String[] var2);

    private static native void destroyByName(String var0, String[] var1, String[] var2);

    private static native void startBulkUpdateByName(String var0);

    private static native void stopBulkUpdateByName(String var0);

    public RhomModel(String string, int n) {
        this.init();
        this.mName = string;
        this.mSyncType = n;
    }

    public String getName() {
        return this.mName;
    }

    public int getModelType() {
        return this.mModelType;
    }

    public void setModelType(int n) {
        this.mModelType = n;
    }

    public int getSyncType() {
        return this.mSyncType;
    }

    public void setSyncType(int n) {
        this.mSyncType = n;
    }

    public int getSyncPriority() {
        return this.mSyncPriority;
    }

    public void setSyncPriority(int n) {
        this.mSyncPriority = n;
    }

    public String getPartition() {
        return this.mPartition;
    }

    public void setPartition(String string) {
        this.mPartition = string;
    }

    public Map<String, Boolean> getBlobAttribs() {
        return this.mBlobAttribs;
    }

    public String getBlobAttribsAsString() {
        Set<Map.Entry<String, Boolean>> set = this.mBlobAttribs.entrySet();
        Iterator<Map.Entry<String, Boolean>> iterator = set.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<String, Boolean> entry = iterator.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(entry.getKey()).append(',').append(entry.getValue() != false ? (char)'1' : '0');
        }
        return stringBuilder.toString();
    }

    public Map<String, String> getAssociations() {
        return this.mAssociations;
    }

    public RhoConnectNotify sync() {
        return RhomModel.syncByName(this.mName);
    }

    private void mapToArrays(Map<String, String> map, String[] stringArray, String[] stringArray2) {
        int n = 0;
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            stringArray[n] = string = iterator.next();
            stringArray2[n] = map.get(string);
            ++n;
        }
    }

    public Map<String, String> find(String string) {
        return RhomModel.findByName(this.mName, string);
    }

    public Map<String, String> findFirst(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        String[] stringArray2 = new String[map.size()];
        this.mapToArrays(map, stringArray, stringArray2);
        return RhomModel.findFirstByName(this.mName, stringArray, stringArray2);
    }

    public Collection<Map<String, String>> findAll(Map<String, String> map) {
        String[] stringArray;
        String[] stringArray2;
        if (map != null) {
            stringArray2 = new String[map.size()];
            stringArray = new String[map.size()];
            this.mapToArrays(map, stringArray2, stringArray);
        } else {
            stringArray = new String[]{};
            stringArray2 = stringArray;
        }
        return RhomModel.findAllByName(this.mName, stringArray2, stringArray);
    }

    public Collection<Map<String, String>> findBySql(String string, List<String> list) {
        String[] stringArray = null;
        if (list != null) {
            stringArray = new String[list.size()];
            list.toArray(stringArray);
        }
        return RhomModel.findBySqlByName(this.mName, string, stringArray);
    }

    public void create(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        String[] stringArray2 = new String[map.size()];
        this.mapToArrays(map, stringArray, stringArray2);
        Map<String, String> map2 = RhomModel.createByName(this.mName, stringArray, stringArray2);
        if (map2 != null) {
            map.clear();
            map.putAll(map2);
        }
    }

    public void save(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        String[] stringArray2 = new String[map.size()];
        this.mapToArrays(map, stringArray, stringArray2);
        RhomModel.saveByName(this.mName, stringArray, stringArray2);
    }

    public void destroy(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        String[] stringArray2 = new String[map.size()];
        this.mapToArrays(map, stringArray, stringArray2);
        RhomModel.destroyByName(this.mName, stringArray, stringArray2);
    }

    public void startBulkUpdate() {
        RhomModel.startBulkUpdateByName(this.mName);
    }

    public void stopBulkUpdate() {
        RhomModel.stopBulkUpdateByName(this.mName);
    }
}

