/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhodes;

import android.app.ActivityManager;
import android.content.Context;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class MemoryInfoCollector {
    private static Context mContext = null;

    public static void setContext(Context context) {
        mContext = context;
    }

    public static String collect() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Memory usage:\n");
        stringBuilder.append("Contents of /proc/meminfo:\n");
        stringBuilder.append(MemoryInfoCollector.getProcMeminfoContents());
        stringBuilder.append("\n");
        stringBuilder.append("MemoryInfo from ActivityService:\n");
        stringBuilder.append(MemoryInfoCollector.getActivitiManagerMemInfo());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    private static String getProcMeminfoContents() {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/proc/meminfo"));
            String string = null;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("line.separator");
            int n = 0;
            while ((string = bufferedReader.readLine()) != null && n++ < 5) {
                stringBuilder.append(string);
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return "Can't get contents of /proc/meminfo";
        }
    }

    private static String getActivitiManagerMemInfo() {
        if (null == mContext) {
            return "Can't get memory info from ActivityManager";
        }
        try {
            Context context = mContext;
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("memoryInfo.availMem ").append(memoryInfo.availMem).append("\n");
            stringBuilder.append("memoryInfo.lowMemory ").append(memoryInfo.lowMemory).append("\n");
            stringBuilder.append("memoryInfo.threshold ").append(memoryInfo.threshold).append("\n");
            return stringBuilder.toString();
        }
        catch (IllegalStateException illegalStateException) {
            return "Can't get memory info from ActivityManager";
        }
    }
}

