/*
 * Decompiled with CFR 0.152.
 */
package com.rhomobile.rhodes.socket;

import com.rhomobile.rhodes.Logger;
import com.rhomobile.rhodes.socket.RhoSockAddr;
import com.rhomobile.rhodes.socket.RhoSocket;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SSLImpl {
    private static final String TAG = "SSLImplJava";
    private static SSLSocketFactory factory = null;
    private SSLSocket sock;
    private int sockfd;
    private InputStream is;
    private OutputStream os;

    public native RhoSockAddr getRemoteSockAddr(int var1);

    private static void reportFail(String string, Exception exception) {
        Logger.E(TAG, "Call of \"" + string + "\" failed: " + exception.getClass().getSimpleName() + ": " + exception.getMessage());
    }

    private static SSLSocketFactory getFactory(boolean bl) throws NoSuchAlgorithmException, KeyManagementException {
        if (bl) {
            return (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        if (factory == null) {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagerArray = new TrustManager[]{new MyTrustManager()};
            sSLContext.init(null, trustManagerArray, new SecureRandom());
            factory = sSLContext.getSocketFactory();
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connect(int n, boolean bl) {
        try {
            RhoSockAddr rhoSockAddr = this.getRemoteSockAddr(n);
            RhoSocket rhoSocket = new RhoSocket(n, rhoSockAddr);
            SSLSocketFactory sSLSocketFactory = SSLImpl.getFactory(bl);
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(rhoSocket, rhoSockAddr.host.toString(), rhoSockAddr.port, true);
            sSLSocket.setUseClientMode(true);
            SSLImpl sSLImpl = this;
            synchronized (sSLImpl) {
                this.sock = sSLSocket;
                this.os = this.sock.getOutputStream();
                this.is = this.sock.getInputStream();
                this.sockfd = n;
            }
            return true;
        }
        catch (Exception exception) {
            SSLImpl.reportFail("connect", exception);
            exception.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        block6: {
            try {
                if (this.sock == null) break block6;
                SSLImpl sSLImpl = this;
                synchronized (sSLImpl) {
                    if (this.sock != null) {
                        this.sock.close();
                        this.sock = null;
                        this.os = null;
                        this.is = null;
                        this.sockfd = -1;
                    }
                }
            }
            catch (Exception exception) {
                SSLImpl.reportFail("shutdown", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean send(byte[] byArray) {
        block7: {
            try {
                if (this.os == null) break block7;
                OutputStream outputStream = null;
                SSLImpl sSLImpl = this;
                synchronized (sSLImpl) {
                    if (this.os != null) {
                        outputStream = this.os;
                    }
                }
                if (outputStream != null) {
                    outputStream.write(byArray);
                    return true;
                }
            }
            catch (Exception exception) {
                SSLImpl.reportFail("send", exception);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int recv(byte[] byArray) {
        block7: {
            try {
                if (this.is == null) break block7;
                InputStream inputStream = null;
                SSLImpl sSLImpl = this;
                synchronized (sSLImpl) {
                    if (this.is != null) {
                        inputStream = this.is;
                    }
                }
                if (inputStream != null) {
                    int n = byArray.length;
                    int n2 = this.is.read(byArray, 0, n);
                    return n2;
                }
            }
            catch (Exception exception) {
                SSLImpl.reportFail("recv", exception);
            }
        }
        return -1;
    }

    private static class MyTrustManager
    implements X509TrustManager {
        private MyTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            Logger.T(SSLImpl.TAG, "checkClientTrusted");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            Logger.T(SSLImpl.TAG, "checkServerTrusted");
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            Logger.T(SSLImpl.TAG, "getAcceptedIssuers");
            return new X509Certificate[0];
        }
    }
}

