/*------------------------------------------------------------------------
* (The MIT License)
* 
* Copyright (c) 2008-2011 Rhomobile, Inc.
* 
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
* 
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
* 
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
* 
* http://rhomobile.com
*------------------------------------------------------------------------*/

package com.rhomobile.rhodes.osfunctionality;

import com.rhomobile.rhodes.event.CalendarIDsProvider;

import android.content.Context;
import android.webkit.WebView;


public interface AndroidFunctionality {
    final String TAG = AndroidFunctionality.class.getSimpleName();
    String AccessOwnerInfo_getEmail(Context context);
    String AccessOwnerInfo_getUsername(Context context);

    /**
     * Returns current screen rotation against default device rotation
     * @return screen rotation in degrees
     */
    int getDeviceRotation(Context context);

    /**
     * Returns current screen orientation
     * @return value in terms of ActivityInfo.screenOrientation
     */
    int getScreenOrientation(Context context);

    void applyWebSettings(WebView view);
    void pauseWebView( WebView view, boolean doPause );
    
    CalendarIDsProvider buildCalendarIDsProvider();
}