/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.asm.AnnotationVisitor;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.ClassAdapter;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.asm.FieldVisitor;
import com.tonicsystems.jarjar.asm.Label;
import com.tonicsystems.jarjar.asm.MethodAdapter;
import com.tonicsystems.jarjar.asm.MethodVisitor;
import com.tonicsystems.jarjar.asm.Type;
import com.tonicsystems.jarjar.asm.signature.SignatureReader;
import com.tonicsystems.jarjar.asm.signature.SignatureWriter;
import com.tonicsystems.jarjar.ext_util.SignatureAdapter;

abstract class DependencyVisitor
extends ClassAdapter {
    private String className;

    public DependencyVisitor(ClassVisitor cv) {
        super(cv);
    }

    protected abstract String fixDesc(String var1);

    protected abstract String fixName(String var1);

    protected abstract String fixMethodDesc(String var1);

    protected abstract String fixString(String var1, String var2);

    protected abstract Attribute fixAttribute(Attribute var1);

    private String[] fixNames(String[] names) {
        if (names == null) {
            return null;
        }
        String[] fixed = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            fixed[i] = this.fixName(names[i]);
        }
        return fixed;
    }

    private Object fixValue(Object value) {
        if (value instanceof String) {
            return this.fixString(this.className, (String)value);
        }
        if (value instanceof Type) {
            return Type.getType(this.fixDesc(((Type)value).getDescriptor()));
        }
        return value;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name.replace('/', '.');
        this.cv.visit(version, access, this.fixName(name), this.fixSignature(signature, false), this.fixName(superName), this.fixNames(interfaces));
    }

    public void visitAttribute(Attribute attr) {
        this.cv.visitAttribute(this.fixAttribute(attr));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new AnnotationFixer(this.cv.visitAnnotation(this.fixDesc(desc), visible));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldVisitor fv = this.cv.visitField(access, name, this.fixDesc(desc), this.fixSignature(signature, true), this.fixValue(value));
        return fv != null ? new FieldFixer(fv) : null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.cv.visitInnerClass(this.fixName(name), this.fixName(outerName), innerName, access);
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.cv.visitOuterClass(this.fixName(owner), name, desc != null ? this.fixMethodDesc(desc) : null);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, this.fixMethodDesc(desc), this.fixSignature(signature, false), this.fixNames(exceptions));
        return mv != null ? new MethodFixer(mv) : null;
    }

    public void visitEnd() {
        this.cv.visitEnd();
    }

    public void visitSource(String source, String debug) {
        this.cv.visitSource(source, debug);
    }

    private AnnotationVisitor fixAnnotation(AnnotationVisitor av) {
        return av != null ? new AnnotationFixer(av) : null;
    }

    private String fixSignature(String signature, boolean type) {
        if (signature == null) {
            return null;
        }
        SignatureReader reader = new SignatureReader(signature);
        SignatureWriter writer = new SignatureWriter();
        SignatureFixer fixer = new SignatureFixer(writer);
        if (type) {
            reader.acceptType(fixer);
        } else {
            reader.accept(fixer);
        }
        return writer.toString();
    }

    private class SignatureFixer
    extends SignatureAdapter {
        public SignatureFixer(SignatureWriter sw) {
            super(sw);
        }

        public void visitTypeVariable(String name) {
            this.sw.visitTypeVariable(DependencyVisitor.this.fixName(name));
        }

        public void visitClassType(String name) {
            this.sw.visitClassType(DependencyVisitor.this.fixName(name));
        }

        public void visitInnerClassType(String name) {
            this.sw.visitInnerClassType(DependencyVisitor.this.fixName(name));
        }
    }

    private class AnnotationFixer
    implements AnnotationVisitor {
        private AnnotationVisitor av;

        public AnnotationFixer(AnnotationVisitor av) {
            this.av = av;
        }

        public void visit(String name, Object value) {
            this.av.visit(name, DependencyVisitor.this.fixValue(value));
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return DependencyVisitor.this.fixAnnotation(this.av.visitAnnotation(name, DependencyVisitor.this.fixDesc(desc)));
        }

        public AnnotationVisitor visitArray(String name) {
            return DependencyVisitor.this.fixAnnotation(this.av.visitArray(name));
        }

        public void visitEnum(String name, String desc, String value) {
            this.av.visitEnum(name, DependencyVisitor.this.fixDesc(desc), (String)DependencyVisitor.this.fixValue(value));
        }

        public void visitEnd() {
            this.av.visitEnd();
        }
    }

    private class MethodFixer
    extends MethodAdapter {
        public MethodFixer(MethodVisitor mv) {
            super(mv);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return DependencyVisitor.this.fixAnnotation(this.mv.visitAnnotation(DependencyVisitor.this.fixDesc(desc), visible));
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return DependencyVisitor.this.fixAnnotation(this.mv.visitAnnotationDefault());
        }

        public void visitTypeInsn(int opcode, String desc) {
            this.mv.visitTypeInsn(opcode, desc.charAt(0) == '[' ? DependencyVisitor.this.fixDesc(desc) : DependencyVisitor.this.fixName(desc));
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitFieldInsn(opcode, DependencyVisitor.this.fixName(owner), name, DependencyVisitor.this.fixDesc(desc));
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.mv.visitMethodInsn(opcode, DependencyVisitor.this.fixName(owner), name, DependencyVisitor.this.fixMethodDesc(desc));
        }

        public void visitLdcInsn(Object cst) {
            this.mv.visitLdcInsn(DependencyVisitor.this.fixValue(cst));
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.mv.visitMultiANewArrayInsn(DependencyVisitor.this.fixDesc(desc), dims);
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            this.mv.visitTryCatchBlock(start, end, handler, DependencyVisitor.this.fixName(type));
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.mv.visitLocalVariable(name, DependencyVisitor.this.fixDesc(desc), DependencyVisitor.this.fixSignature(signature, true), start, end, index);
        }

        public void visitAttribute(Attribute attr) {
            this.mv.visitAttribute(DependencyVisitor.this.fixAttribute(attr));
        }
    }

    private class FieldFixer
    implements FieldVisitor {
        private FieldVisitor fv;

        public FieldFixer(FieldVisitor fv) {
            this.fv = fv;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationFixer(this.fv.visitAnnotation(DependencyVisitor.this.fixDesc(desc), visible));
        }

        public void visitAttribute(Attribute attr) {
            this.fv.visitAttribute(DependencyVisitor.this.fixAttribute(attr));
        }

        public void visitEnd() {
            this.fv.visitEnd();
        }
    }
}

