/*
 * Decompiled with CFR 0.152.
 */
package com.tonicsystems.jarjar;

import com.tonicsystems.jarjar.DependencyVisitor;
import com.tonicsystems.jarjar.PatternElement;
import com.tonicsystems.jarjar.Wildcard;
import com.tonicsystems.jarjar.asm.Attribute;
import com.tonicsystems.jarjar.asm.ClassVisitor;
import com.tonicsystems.jarjar.ext_util.ClassTransformer;
import java.util.HashMap;
import java.util.List;

class PackageTransformer
extends DependencyVisitor
implements ClassTransformer {
    private static final String RESOURCE_SUFFIX = "RESOURCE";
    private Wildcard[] wildcards;
    private HashMap cache = new HashMap();
    private boolean verbose;

    public PackageTransformer(List ruleList, boolean verbose) {
        super(null);
        this.verbose = verbose;
        this.wildcards = PatternElement.createWildcards(ruleList);
    }

    public void setTarget(ClassVisitor target) {
        this.cv = target;
    }

    public String fixPath(String path) {
        String end;
        int slash = path.lastIndexOf(47);
        if (slash < 0) {
            end = path;
            path = RESOURCE_SUFFIX;
        } else {
            end = path.substring(slash + 1);
            path = path.substring(0, slash + 1) + RESOURCE_SUFFIX;
        }
        boolean absolute = path.startsWith("/");
        if (absolute) {
            path = path.substring(1);
        }
        path = this.fixName(path);
        if (absolute) {
            path = "/" + path;
        }
        path = path.substring(0, path.length() - RESOURCE_SUFFIX.length()) + end;
        return path;
    }

    protected String fixName(String name) {
        if (name == null) {
            return null;
        }
        String desc = this.fixDesc("L" + name + ";");
        return desc.substring(1, desc.length() - 1);
    }

    protected String fixDesc(String desc) {
        return this.fixDesc(desc, false);
    }

    private String fixDesc(String desc, boolean allowGenerics) {
        if (desc.charAt(desc.length() - 1) != ';') {
            return desc;
        }
        String value = (String)this.cache.get(desc);
        if (value == null) {
            if (allowGenerics && desc.charAt(desc.length() - 2) == '>') {
                int lt = desc.indexOf(60);
                String main = this.replaceHelper(desc.substring(0, lt) + ";", 0);
                String param = this.replaceHelper(desc.substring(lt + 1, desc.length() - 2), 0);
                value = main.substring(0, main.length() - 1) + "<" + param + ">;";
            } else {
                value = this.replaceHelper(desc, 0);
            }
            this.cache.put(desc, value);
        }
        return value;
    }

    private String replaceHelper(String value, int style) {
        for (int i = 0; i < this.wildcards.length; ++i) {
            String test = this.wildcards[i].replace(value, style);
            if (test == null) continue;
            return test;
        }
        return value;
    }

    protected String fixMethodDesc(String desc) {
        return this.fixMethodDesc(desc, false);
    }

    private String fixMethodDesc(String desc, boolean allowGenerics) {
        String value = (String)this.cache.get(desc);
        if (value == null) {
            if (desc.indexOf(76) < 0) {
                value = desc;
            } else {
                StringBuffer sb = new StringBuffer();
                sb.append('(');
                int end = desc.lastIndexOf(41);
                block0: for (int i = 1; i < end; ++i) {
                    char c = desc.charAt(i);
                    if (c == 'L') {
                        for (int j = i + 1; j < end; ++j) {
                            if (desc.charAt(j) != ';') continue;
                            if (allowGenerics && j + 1 < end && desc.charAt(j + 1) == '>') {
                                j += 2;
                            }
                            sb.append(this.fixDesc(desc.substring(i, j + 1), allowGenerics));
                            i = j;
                            continue block0;
                        }
                        continue;
                    }
                    sb.append(c);
                }
                sb.append(')');
                sb.append(this.fixDesc(desc.substring(end + 1), allowGenerics));
                value = sb.toString();
            }
            this.cache.put(desc, value);
        }
        return value;
    }

    protected String fixString(String className, String value) {
        String newValue = this.fixClassForName(value);
        if (newValue.equals(value)) {
            newValue = this.fixPath(value);
        }
        if (newValue.equals(value)) {
            newValue = this.replaceHelper(newValue, 1);
        }
        if (this.verbose && !newValue.equals(value)) {
            System.err.println("Changed " + className + " \"" + value + "\" -> \"" + newValue + "\"");
        }
        return newValue;
    }

    private String fixClassForName(String value) {
        String desc1;
        String desc2;
        if (value.indexOf(46) >= 0 && !(desc2 = this.fixDesc(desc1 = value.replace('.', '/'))).equals(desc1)) {
            return desc2.replace('/', '.');
        }
        return value;
    }

    protected Attribute fixAttribute(Attribute attr) {
        return attr;
    }
}

