/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.collections.impl.IndexedVector;
import antlr.preprocessor.Grammar;
import antlr.preprocessor.Option;
import java.util.Enumeration;

class Rule {
    protected String name;
    protected String block;
    protected String args;
    protected String returnValue;
    protected String throwsSpec;
    protected String initAction;
    protected IndexedVector options;
    protected String visibility;
    protected Grammar enclosingGrammar;
    protected boolean bang = false;

    public Rule(String string2, String string3, IndexedVector indexedVector, Grammar grammar) {
        this.name = string2;
        this.block = string3;
        this.options = indexedVector;
        this.setEnclosingGrammar(grammar);
    }

    public String getArgs() {
        return this.args;
    }

    public boolean getBang() {
        return this.bang;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public boolean narrowerVisibility(Rule rule) {
        if (this.visibility.equals("public")) {
            return !rule.equals("public");
        }
        if (this.visibility.equals("protected")) {
            return rule.equals("private");
        }
        if (this.visibility.equals("private")) {
            return false;
        }
        return false;
    }

    public boolean sameSignature(Rule rule) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        bl = this.name.equals(rule.getName());
        if (this.args != null) {
            bl2 = this.args.equals(rule.getArgs());
        }
        if (this.returnValue != null) {
            bl3 = this.returnValue.equals(rule.getReturnValue());
        }
        return bl && bl2 && bl3;
    }

    public void setArgs(String string2) {
        this.args = string2;
    }

    public void setBang() {
        this.bang = true;
    }

    public void setEnclosingGrammar(Grammar grammar) {
        this.enclosingGrammar = grammar;
    }

    public void setInitAction(String string2) {
        this.initAction = string2;
    }

    public void setOptions(IndexedVector indexedVector) {
        this.options = indexedVector;
    }

    public void setReturnValue(String string2) {
        this.returnValue = string2;
    }

    public void setThrowsSpec(String string2) {
        this.throwsSpec = string2;
    }

    public void setVisibility(String string2) {
        this.visibility = string2;
    }

    public String toString() {
        String string2 = "";
        String string3 = this.returnValue == null ? "" : "returns " + this.returnValue;
        String string4 = this.args == null ? "" : this.args;
        String string5 = this.getBang() ? "!" : "";
        string2 = string2 + (this.visibility == null ? "" : this.visibility + " ");
        string2 = string2 + this.name + string5 + string4 + " " + string3 + this.throwsSpec;
        if (this.options != null) {
            string2 = string2 + System.getProperty("line.separator") + "options {" + System.getProperty("line.separator");
            Enumeration enumeration = this.options.elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + (Option)enumeration.nextElement() + System.getProperty("line.separator");
            }
            string2 = string2 + "}" + System.getProperty("line.separator");
        }
        if (this.initAction != null) {
            string2 = string2 + this.initAction + System.getProperty("line.separator");
        }
        string2 = string2 + this.block;
        return string2;
    }
}

