/*
 * Decompiled with CFR 0.152.
 */
package com.xruby;

import antlr.RecognitionException;
import com.xruby.CommandLineOptions;
import com.xruby.compiler.RubyCompiler;
import com.xruby.compiler.codegen.CompilationResults;
import com.xruby.runtime.lang.GlobalVariables;
import com.xruby.runtime.lang.RubyProgram;
import com.xruby.runtime.lang.RubyRuntime;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class Main {
    private CommandLineOptions options;

    public Main(CommandLineOptions options) {
        this.options = options;
    }

    public void run() throws Exception {
        if (this.options.isHelp()) {
            this.help();
            return;
        }
        if (this.options.isEvalOneLine()) {
            if (this.options.getBackupExtension() != null && this.options.getFilename() != null) {
                this.copyFile(this.options.getFilename(), this.options.getFilename() + this.options.getBackupExtension());
            }
            RubyCompiler compiler = new RubyCompiler(this.options.isStrip());
            CompilationResults results = compiler.compileString(this.options.getEvalScript());
            if (this.options.isPe()) {
                this.redirectStdinout(this.options.getFilename());
            }
            this.run(results, null);
        } else if (this.options.getFilename() == null) {
            CompilationResults results = this.compileStdin();
            this.run(results, null);
        } else if (this.options.isCompileOnly()) {
            String filename = this.options.getFilename();
            this.options.enableDebug();
            CompilationResults results = this.compile(filename);
            results.save(filename);
        } else {
            String filename = this.options.getFilename();
            this.options.enableDebug();
            CompilationResults results = this.compile(filename);
            this.options.parseOptionsFromFile(filename);
            GlobalVariables.setProgramName(filename);
            GlobalVariables.importValuesFromCommandLine(this.options.getVars());
            this.run(results, this.options.getArgs());
        }
    }

    private void redirectStdinout(String filename) throws IOException {
        BufferedReader r = new BufferedReader(new FileReader(filename));
        int line = 0;
        StringBuilder sb = new StringBuilder();
        while (r.readLine() != null) {
            sb.append(++line);
            sb.append("\n");
        }
        r.close();
        ByteArrayInputStream s = new ByteArrayInputStream(sb.toString().getBytes());
        System.setIn(s);
        FileOutputStream output = new FileOutputStream(filename);
        System.setOut(new PrintStream(output));
    }

    private void help() {
        System.out.println("Usage: xruby [-c] filename1, filename2, ...");
    }

    private CompilationResults compileStdin() throws Exception {
        RubyCompiler compiler = this.createCompiler();
        return compiler.compileStdin();
    }

    private CompilationResults compile(String filename) throws Exception {
        RubyCompiler compiler = this.createCompiler();
        return compiler.compileFile(this.options.getFilename());
    }

    private RubyCompiler createCompiler() {
        RubyCompiler compiler = new RubyCompiler(this.options.isStrip());
        if (this.options.isVerbose()) {
            compiler.setVerbose();
        }
        if (this.options.isEnableDebug()) {
            compiler.enableDebug();
        }
        return compiler;
    }

    private void run(CompilationResults results, String[] args) throws Exception {
        RubyProgram p2 = results.getRubyProgram();
        RubyRuntime.init(args);
        p2.invoke();
        RubyRuntime.fini();
    }

    private void copyFile(String from, String to) {
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            srcChannel = new FileInputStream(from).getChannel();
            dstChannel = new FileOutputStream(to).getChannel();
            ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, srcChannel.size());
        }
        catch (IOException e) {
            throw new Error(e);
        }
        finally {
            try {
                if (srcChannel != null) {
                    srcChannel.close();
                }
                if (dstChannel != null) {
                    dstChannel.close();
                }
            }
            catch (IOException ioe) {}
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            CommandLineOptions options = new CommandLineOptions(args);
            Main xruby = new Main(options);
            xruby.run();
        }
        catch (RecognitionException exc) {
            System.out.println("XRuby compilation failed. Line: " + exc.line + "; Column: " + exc.column + "; Description: " + exc.getErrorMessage());
            System.exit(1);
        }
        catch (Exception exc1) {
            System.out.println("XRuby compilation failed: " + exc1);
            System.exit(1);
        }
    }
}

