/*
 * Decompiled with CFR 0.152.
 */
package com.xruby.compiler.codedom;

import com.xruby.compiler.codedom.CodeVisitor;
import com.xruby.compiler.codedom.Expression;
import com.xruby.compiler.codedom.MethodCallExpression;
import com.xruby.compiler.codedom.YieldExpression;
import java.util.ArrayList;

public class ArrayExpression
extends Expression {
    private ArrayList<Expression> elements_;
    private Expression asterisk_element_;
    int rhs_size_;
    boolean has_single_asterisk_;

    public ArrayExpression() {
        this.elements_ = new ArrayList();
        this.asterisk_element_ = null;
        this.rhs_size_ = 0;
        this.has_single_asterisk_ = false;
    }

    ArrayExpression(ArrayList<Expression> elements, Expression asterisk_element) {
        this.elements_ = elements;
        this.asterisk_element_ = asterisk_element;
        this.rhs_size_ = elements.size();
        this.has_single_asterisk_ = null != asterisk_element;
    }

    public void addElement(Expression e) {
        this.elements_.add(e);
    }

    public void setAsteriskElement(Expression e) {
        this.asterisk_element_ = e;
    }

    public ArrayList<Expression> getElements() {
        return this.elements_;
    }

    @Override
    public void accept(CodeVisitor visitor) {
        visitor.visitArrayBegin(this.elements_.size(), this.rhs_size_, this.has_single_asterisk_);
        for (Expression e : this.elements_) {
            e.accept(visitor);
            visitor.visitArrayElement(false, e instanceof MethodCallExpression || e instanceof YieldExpression);
        }
        if (null != this.asterisk_element_) {
            this.asterisk_element_.accept(visitor);
            visitor.visitArrayElement(true, this.asterisk_element_ instanceof MethodCallExpression || this.asterisk_element_ instanceof YieldExpression);
        }
        visitor.visitArrayEnd();
    }
}

